/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoelogeo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.tributos.domain.ModeloCampo;
import br.com.elotech.tributos.dto.integracaoelogeo.ModeloCampoElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.ModeloRespostaElogeoDTO;
import br.com.elotech.tributos.service.integracaoelogeo.CampoElogeoService;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Profile(value={"onpremise"})
@Service
public class AiseCampoElogeoService
extends ReadOnlyService<ModeloCampo, Long>
implements CampoElogeoService {
    public Page<ModeloCampoElogeoDTO> findAllCampo(Pageable page) {
        return super.findAll(page).map(ModeloCampoElogeoDTO::from);
    }

    public ModeloCampoElogeoDTO findCampoById(Long id) {
        return super.findById((Serializable)id).map(ModeloCampoElogeoDTO::from).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o ModeloCampo com o id '%d'.", id)));
    }

    public List<ModeloRespostaElogeoDTO> findRespostaByIdCampo(Long id) {
        ModeloCampo modeloCampo = (ModeloCampo)super.findById((Serializable)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o ModeloCampo com o id '%d'.", id)));
        return modeloCampo.getModeloRespostas().stream().map(ModeloRespostaElogeoDTO::from).collect(Collectors.toList());
    }
}

