/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.bancodobrasil;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoBoletoPixLog;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.CertificadoBBDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.PagamentoBBPayErrorResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.PagamentoBBPayResponseDTO;
import br.com.elotech.tributos.enums.IntegracaoTokenOperation;
import br.com.elotech.tributos.enums.integracaoboleto.TipoIntegracaoBoletoPix;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoBoletoPixLogRepository;
import br.com.elotech.tributos.service.integracaoboleto.bancodobrasil.BbOauth;
import br.com.elotech.tributos.service.integracaoboleto.bancodobrasil.BbUtilsService;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class ConsultaPagamentoBBPayService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsultaPagamentoBBPayService.class);
    private final ObjectMapper mapper;
    private final IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository;
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);
    private final BbUtilsService bbUtilsService;
    private IntegracaoBoletoPixLog integracaoBoletoPixLog;
    private static final String URL_BBPAY_PAGAMENTOS = "pagamentos";
    private BbOauth oAauth;

    public PagamentoBBPayResponseDTO listarPagamentos(Map<String, Object> queryMap) {
        this.integracaoBoletoPixLog = this.iniciarLog();
        this.oAauth = this.criarBBOauth();
        CertificadoBBDTO certificadoBBDTO = this.bbUtilsService.buscarCertificadoBB();
        try {
            PagamentoBBPayResponseDTO solicitacaoConsultaResponse;
            ObjectMapper mapper = new ObjectMapper();
            String urlPagamento = this.montarUrlPagamento(queryMap);
            JsonNode responseConsulta = this.bbUtilsService.executarRequisicaoBB(HttpMethod.GET, urlPagamento, null, certificadoBBDTO, IntegracaoTokenOperation.BOLETO_HIBRIDO);
            this.integracaoBoletoPixLog.setJsonResponse(mapper.writeValueAsString((Object)responseConsulta));
            PagamentoBBPayResponseDTO pagamentoBBPayResponseDTO = solicitacaoConsultaResponse = (PagamentoBBPayResponseDTO)mapper.treeToValue((TreeNode)responseConsulta, PagamentoBBPayResponseDTO.class);
            return pagamentoBBPayResponseDTO;
        }
        catch (RestException e) {
            PagamentoBBPayErrorResponseDTO dtoErros = (PagamentoBBPayErrorResponseDTO)this.bbUtilsService.converteErroResposta(e.getMessage(), PagamentoBBPayErrorResponseDTO.class);
            String descricaoErros = Optional.ofNullable(dtoErros).filter(PagamentoBBPayErrorResponseDTO::hasErro).map(PagamentoBBPayErrorResponseDTO::getErrosConcatenado).orElse(e.getMessage());
            this.integracaoBoletoPixLog.setJsonResponse(e.getMessage());
            this.integracaoBoletoPixLog.setDescricaoErro(descricaoErros);
            throw new RestException(e.getStatus(), "Erro na busca da solicitacao: " + descricaoErros, (Throwable)e);
        }
        catch (Exception e) {
            log.error("Erro ao listar os pagamentos do BBPAY: {}", (Throwable)e);
            this.integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
        finally {
            this.salvarIntegracaoBoletoPixLog(this.integracaoBoletoPixLog);
        }
    }

    private void salvarIntegracaoBoletoPixLog(IntegracaoBoletoPixLog integracaoBoletoPixLog) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                return (IntegracaoBoletoPixLog)this.integracaoBoletoPixLogRepository.save((Object)integracaoBoletoPixLog);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    private IntegracaoBoletoPixLog iniciarLog() {
        this.integracaoBoletoPixLog = new IntegracaoBoletoPixLog(TipoIntegracaoBoletoPix.CONSULTA_PAGAMENTO_BBPAY);
        this.integracaoBoletoPixLog.setDataIntegracao(LocalDateTime.now());
        return this.integracaoBoletoPixLog;
    }

    private BbOauth criarBBOauth() {
        return BbOauth.builder().url(this.bbUtilsService.getParametro(ParametroGeralEnum.BOLETO_BB_OAUTH_URL)).clientId(this.bbUtilsService.getParametro(ParametroGeralEnum.BOLETO_BB_PAY_CLIENTID)).clientSecret(this.bbUtilsService.getParametro(ParametroGeralEnum.BOLETO_BB_PAY_CLIENTSECRET)).scope("checkout.solicitacoes-info checkout.solicitacoes-requisicao checkout.pagamentos-info checkout.pagamentos-requisicao checkout.devolucoes-info checkout.devolucoes-requisicao checkout.participantes-info checkout.participantes-requisicao").codBanco(Banco.CODIGO_BANCO_BRASIL.longValue()).operacaoBanco(IntegracaoTokenOperation.BOLETO_HIBRIDO).build();
    }

    private String montarUrlPagamento(Map<String, Object> queryMap) {
        String urlPagamento = URL_BBPAY_PAGAMENTOS;
        return this.bbUtilsService.montarUrlBbPay(urlPagamento, queryMap);
    }

    @Generated
    public ConsultaPagamentoBBPayService(ObjectMapper mapper, IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository, PlatformTransactionManager transactionManager, BbUtilsService bbUtilsService) {
        this.mapper = mapper;
        this.integracaoBoletoPixLogRepository = integracaoBoletoPixLogRepository;
        this.transactionManager = transactionManager;
        this.bbUtilsService = bbUtilsService;
    }
}

