/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.contencioso;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Contencioso;
import br.com.elotech.tributos.domain.ContenciosoDebito;
import br.com.elotech.tributos.domain.ContenciosoDebitoParcela;
import br.com.elotech.tributos.domain.ContenciosoSituacaoEnum;
import br.com.elotech.tributos.domain.SituacaoContenciosoDebito;
import br.com.elotech.tributos.domain.SituacaoParcela;
import br.com.elotech.tributos.domain.TipoEventoSituacaoParcelaEnum;
import br.com.elotech.tributos.domain.TipoSituacaoParcela;
import br.com.elotech.tributos.dto.contencioso.ContenciosoDebitoDTO;
import br.com.elotech.tributos.dto.contencioso.ContenciosoDebitosExararDTO;
import br.com.elotech.tributos.repository.ContenciosoRepository;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.SituacaoParcelaService;
import br.com.elotech.tributos.service.cancelamento.CancelamentoDebitoService;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public abstract class AcaoExararAbstract {
    protected ContenciosoRepository contenciosoRepository;
    protected CancelamentoDebitoService cancelamentoDebitoService;
    protected DebitoParcelaService debitoParcelaService;
    protected SituacaoParcelaService situacaoParcelaService;

    protected void validaContenciosoEmAberto(Contencioso contencioso) {
        if (!ContenciosoSituacaoEnum.ABERTO.equals((Object)contencioso.getSituacao())) {
            throw new EloValidationException("Contencioso deve estar com a situa\u00e7\u00e3o ABERTO para poder ser exarado");
        }
    }

    protected void atualizaStatusDoContenciosoEParcelas(ContenciosoDebitosExararDTO dto, Contencioso contencioso, List<ContenciosoDebitoDTO> contenciosoDebitosDTOSelected) {
        List<ContenciosoDebito> contenciosoDebitosSelected = contencioso.getDebitos().stream().filter(d -> contenciosoDebitosDTOSelected.stream().anyMatch(arg_0 -> ((ContenciosoDebito)d).equalsToDto(arg_0))).collect(Collectors.toList());
        contenciosoDebitosSelected.forEach(debitoContencioso -> {
            debitoContencioso.setSituacao(dto.getParecer());
            debitoContencioso.setMotivoParecer(dto.getMotivoParecer());
            debitoContencioso.getParcelas().forEach(arg_0 -> this.updateSituacaoParcelaAntiga(arg_0));
        });
    }

    protected void updateSituacaoParcelaAntiga(ContenciosoDebitoParcela parcela) {
        Optional debitoParcela = this.debitoParcelaService.findByDebitoParcela(parcela.getId().getEntidade(), parcela.getId().getExercicio(), parcela.getId().getTipoCadastro().getValue(), parcela.getId().getCadastroGeral(), parcela.getId().getDivida(), parcela.getId().getSubDivida(), parcela.getId().getParcela());
        debitoParcela.ifPresent(e -> {
            if (parcela.getSituacaoAtual().getTipoSituacaoParcela() == TipoSituacaoParcela.RECURSO_ADMINISTRATIVO) {
                SituacaoParcela novaSituacao = this.generateNovaSituacao(parcela);
                e.setSituacaoDebito(novaSituacao);
                e.setDataSituacao(LocalDate.now());
                this.debitoParcelaService.save((EloEntity)e, null);
            }
        });
    }

    protected SituacaoParcela generateNovaSituacao(ContenciosoDebitoParcela contenciosoDebitoParcela) {
        TipoEventoSituacaoParcelaEnum situacao = TipoEventoSituacaoParcelaEnum.fromValue((Long)contenciosoDebitoParcela.getSituacaoDebito().getId());
        return this.situacaoParcelaService.getNovaSituacaoParcela(situacao, contenciosoDebitoParcela.getSituacaoAtual());
    }

    protected void encerraContenciosoSeNenhumDebitoAguardaParecer(Contencioso contencioso) {
        if (contencioso.getDebitos().stream().noneMatch(e -> SituacaoContenciosoDebito.AGUARDANDOPARECER.equals((Object)e.getSituacao()))) {
            contencioso.setSituacao(ContenciosoSituacaoEnum.ENCERRADO);
        }
    }

    @Generated
    public AcaoExararAbstract(ContenciosoRepository contenciosoRepository, CancelamentoDebitoService cancelamentoDebitoService, DebitoParcelaService debitoParcelaService, SituacaoParcelaService situacaoParcelaService) {
        this.contenciosoRepository = contenciosoRepository;
        this.cancelamentoDebitoService = cancelamentoDebitoService;
        this.debitoParcelaService = debitoParcelaService;
        this.situacaoParcelaService = situacaoParcelaService;
    }
}

