/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.dto.contencioso.ContenciosoRecalculoDebitoDTO;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.List;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ContenciosoRecalculoJobStarter {
    private final JobExplorer jobExplorer;
    private final JobLauncher jobLauncher;
    private final Job contenciosoRecalculoBatchJob;
    private final ObjectMapper objectMapper;

    public ContenciosoRecalculoJobStarter(JobExplorer jobExplorer, JobLauncher jobLauncher, @Qualifier(value="contenciosoRecalculoBatchJob") Job contenciosoRecalculoBatchJob, ObjectMapper objectMapper) {
        this.jobExplorer = jobExplorer;
        this.jobLauncher = jobLauncher;
        this.contenciosoRecalculoBatchJob = contenciosoRecalculoBatchJob;
        this.objectMapper = objectMapper;
    }

    public JobExecution startJob(Long idContencioso, Long exercicio, Long idDivida, List<ContenciosoRecalculoDebitoDTO> debitosParaRecalculo) throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JsonProcessingException {
        boolean existeJobComMesmosParametros = this.jobExplorer.findRunningJobExecutions(JobType.CONTENCIOSO_RECALCULO.getTipo()).stream().anyMatch(jobExecution -> {
            Long id = jobExecution.getJobParameters().getLong("idContencioso");
            return id.equals(idContencioso);
        });
        if (existeJobComMesmosParametros) {
            throw new EloValidationException(String.format("J\u00e1 existe um rec\u00e1lculo em processamento para o contencioso %d.", idContencioso));
        }
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong("idContencioso", idContencioso);
        jobParametersBuilder.addLong("exercicio", exercicio);
        jobParametersBuilder.addLong("idDivida", idDivida);
        jobParametersBuilder.addString("debitos", this.objectMapper.writeValueAsString(debitosParaRecalculo));
        jobParametersBuilder.addDate("data", new Date());
        return this.jobLauncher.run(this.contenciosoRecalculoBatchJob, jobParametersBuilder.toJobParameters());
    }
}

