/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoSituacaoParcela;
import br.com.elotech.tributos.dto.DebitoEmAbertoDTO;
import br.com.elotech.tributos.dto.DebitoParcelaTributoDTO;
import br.com.elotech.tributos.repository.ValidaEmissaoBoletoRepository;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.exception.GeraBoletoException;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ValidaEmissaoBoletoService {
    private final ParametroGeralService parametroGeralService;
    private final ValidaEmissaoBoletoRepository validaEmissaoBoletoRepository;

    public ValidaEmissaoBoletoService(ParametroGeralService parametroGeralService, ValidaEmissaoBoletoRepository validaEmissaoBoletoRepository) {
        this.parametroGeralService = parametroGeralService;
        this.validaEmissaoBoletoRepository = validaEmissaoBoletoRepository;
    }

    public void validaEmissaoBoleto(List<DebitoEmAbertoDTO> listDebitoParcelaReceita) {
        this.podeEmitirBoleto(listDebitoParcelaReceita, Boolean.valueOf(true), Boolean.valueOf(false));
        this.validaProcessoCancelamento(listDebitoParcelaReceita);
    }

    public void podeEmitirBoleto(List<DebitoEmAbertoDTO> listDebitoParcelaReceita, Boolean exibeErro, Boolean validaEmissaoPorContribuinte) {
        Boolean bloqueiaAjuizamentoEletronico = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.AJUIZAMENTO_BLOQUEIA_BOLETO_ATENDIMENTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        listDebitoParcelaReceita.forEach(debito -> {
            if (exibeErro.booleanValue()) {
                this.validaConfiguracaoGuia(debito);
            }
            this.validaSituacaoParcela(debito, exibeErro);
            if (bloqueiaAjuizamentoEletronico.booleanValue()) {
                this.validaAjuizamentoEletronico(debito, exibeErro);
            }
            if (Boolean.TRUE.equals(validaEmissaoPorContribuinte)) {
                this.validaDebitoPorContribuinte(debito, exibeErro);
            }
        });
    }

    private void validaAjuizamentoEletronico(DebitoEmAbertoDTO debito, Boolean exibeErro) {
        if (debito.isAjuizadoEletronicamente().booleanValue()) {
            debito.setEmiteBoleto(Boolean.valueOf(false));
            if (exibeErro.booleanValue()) {
                throw GeraBoletoException.debitoAjuizadoEletronicamente((DebitoEmAbertoDTO)debito);
            }
        }
    }

    private void validaConfiguracaoGuia(DebitoEmAbertoDTO debito) {
        if (!debito.getEmiteBoleto().booleanValue()) {
            throw GeraBoletoException.guiaNaoEmiteBoleto((Long)debito.getDivida(), (Long)debito.getExercicio());
        }
    }

    private void validaSituacaoParcela(DebitoEmAbertoDTO debito, Boolean exibeErro) {
        TipoSituacaoParcela tipoSituacaoParcela = TipoSituacaoParcela.fromValue((Object)debito.getTipoSituacaoParcela());
        if (TipoSituacaoParcela.RECURSO_ADMINISTRATIVO.equals((Object)tipoSituacaoParcela) || TipoSituacaoParcela.SUBJUDICE.equals((Object)tipoSituacaoParcela) || TipoSituacaoParcela.DIVIDA_SUSPENSA.equals((Object)tipoSituacaoParcela)) {
            debito.setEmiteBoleto(Boolean.valueOf(false));
            if (exibeErro.booleanValue()) {
                throw GeraBoletoException.situacaoParcelaInvalida((String)tipoSituacaoParcela.getDescricao(), (Long)debito.getExercicio(), (Long)debito.getDivida(), (Long)debito.getSubDivida(), (Long)debito.getParcela());
            }
        }
    }

    private void validaDebitoPorContribuinte(DebitoEmAbertoDTO debito, Boolean exibeErro) {
        if (Boolean.TRUE.equals(debito.getPorContribuinte())) {
            debito.setEmiteBoleto(Boolean.valueOf(false));
            if (exibeErro.booleanValue()) {
                throw GeraBoletoException.debitoReparcelamentoPorContribuinte();
            }
        }
    }

    private void validaProcessoCancelamento(List<DebitoEmAbertoDTO> debitos) {
        List debitoParcelaReceita;
        if (this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_APROVACAO_PROCESSO, ModuloEnum.MODULO_TRIBUTARIO.getValue()).booleanValue() && !(debitoParcelaReceita = this.validaEmissaoBoletoRepository.findDebitoComProcessoAprovacaoEmAberto(debitos.stream().map(DebitoEmAbertoDTO::getIdDebitoParcelaReceita).collect(Collectors.toList()))).isEmpty()) {
            throw GeraBoletoException.debitoPossuiProcessoAprovacao((DebitoParcelaTributoDTO)((DebitoParcelaTributoDTO)debitoParcelaReceita.get(0)));
        }
    }
}

