/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoDeducaoEnum;
import br.com.elotech.tributos.dto.CancelamentoDebitoTributoDTO;
import br.com.elotech.tributos.dto.EntidadeDTO;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.dto.cancelamento.CancelamentoTributosFormDTO;
import br.com.elotech.tributos.service.CertidaoDividaAtivaService;
import br.com.elotech.tributos.service.DebitoParcelaTributoService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.ProtestoService;
import br.com.elotech.tributos.service.ValidaDataMovimentacaoService;
import br.com.elotech.tributos.service.cancelamento.validacancelamentodebito.ValidaCancelamentoPorEstado;
import br.com.elotech.tributos.service.exception.CancelamentoDebitoException;
import br.com.elotech.tributos.service.impl.EntidadeServiceImpl;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ValidaCancelamentoDebitoService {
    private final ParametroGeralService parametroGeralService;
    private final CertidaoDividaAtivaService certidaoDividaAtivaService;
    private final DebitoService debitoService;
    private final ValidaDataMovimentacaoService validaDataMovimentacaoService;
    private final ProtestoService protestoService;
    private final DebitoParcelaTributoService debitoParcelaTributoService;
    private final EntidadeServiceImpl entidadeService;
    private final List<ValidaCancelamentoPorEstado> serviceValidacaoPorEstado;
    private static final Long TODAS_SITUACOES_LEGAL = 3L;

    public void validaCancelamento(CancelamentoTributosFormDTO cancelamentoTributosFormDTO) {
        this.validaCancelamento(cancelamentoTributosFormDTO, true);
    }

    public void validaCancelamentoSemDividaAtiva(CancelamentoTributosFormDTO cancelamentoTributosFormDTO) {
        this.validaCancelamento(cancelamentoTributosFormDTO, false);
    }

    private void validaCancelamento(CancelamentoTributosFormDTO cancelamentoTributosFormDTO, boolean validaDividaAtiva) {
        this.validaDataMovimentacaoService.validaMesEDia(cancelamentoTributosFormDTO.getEntidade(), cancelamentoTributosFormDTO.getDataCancelamento());
        if (validaDividaAtiva) {
            this.validateEstornoDebitoEmDividaAtiva(cancelamentoTributosFormDTO);
        }
        this.validaDebitoParcelado(cancelamentoTributosFormDTO);
        this.validaCertidaoDividaAtivaDebito(cancelamentoTributosFormDTO);
        if (cancelamentoTributosFormDTO.getSituacaoLegal() != null) {
            Optional entidade = this.entidadeService.getInfoEntidadePrincipal();
            this.validateCancelamentoDebitoSituacaoLegalTodas(cancelamentoTributosFormDTO);
            this.getServiceValidacaoPorEstado(((EntidadeDTO)entidade.get()).getUnidadeFederacao()).ifPresent(service -> service.validate(cancelamentoTributosFormDTO));
        }
        cancelamentoTributosFormDTO.getParcelas().stream().map(tributo -> (DebitoParcelaTributo)this.debitoParcelaTributoService.findOne((Serializable)tributo.getId())).map(DebitoParcelaTributo::getDebitoParcela).forEach(arg_0 -> ((ProtestoService)this.protestoService).validaDebitoProtestado(arg_0));
    }

    private void validateEstornoDebitoEmDividaAtiva(CancelamentoTributosFormDTO cancelamentoTributosFormDTO) {
        if (TipoDeducaoEnum.ESTORNO.getValue().equals(cancelamentoTributosFormDTO.getMotivoCancelamento().getTipoDeducao().getId()) && (Long.valueOf(SituacaoLegal.DIVIDA_ATIVA.getCodigo().intValue()).equals(cancelamentoTributosFormDTO.getSituacaoLegal()) || Long.valueOf(SituacaoLegal.JUIZO.getCodigo().intValue()).equals(cancelamentoTributosFormDTO.getSituacaoLegal()))) {
            throw new EloValidationException("Cancelamento n\u00e3o permitido, d\u00e9bitos em d\u00edvida ativa/ajuizados n\u00e3o podem ser estornados");
        }
    }

    public void validateCancelamentoDebitoSituacaoLegalTodas(CancelamentoTributosFormDTO cancelamentoTributosFormDTO) {
        Boolean existeSituacaoLegalDiferente = this.existeSituacaoLegalDiferenteEntreDebitos(cancelamentoTributosFormDTO.getParcelas());
        Boolean isCancelamento = cancelamentoTributosFormDTO.getTipoDeducao().getId().equals(TipoDeducaoEnum.CANCELAMENTO.getValue());
        Boolean isEstorno = cancelamentoTributosFormDTO.getTipoDeducao().getId().equals(TipoDeducaoEnum.ESTORNO.getValue());
        if (!cancelamentoTributosFormDTO.getSituacaoLegal().equals(TODAS_SITUACOES_LEGAL)) {
            return;
        }
        if (existeSituacaoLegalDiferente.booleanValue() && (isCancelamento.booleanValue() || isEstorno.booleanValue())) {
            throw new EloValidationException("Cancelamento n\u00e3o permitido, existe mais de uma situa\u00e7\u00e3o legal no mesmo cancelamento, incompativel com os Tipo de Dedu\u00e7\u00e3o, Cancelamento ou Estorno. Para prosseguir voc\u00ea dever\u00e1 separar em dois cancelamentos distintos.");
        }
        if (!existeSituacaoLegalDiferente.booleanValue()) {
            boolean isDividaAtiva = cancelamentoTributosFormDTO.getParcelas().stream().anyMatch(parcela -> parcela.getSituacaoLegal().equals((Object)SituacaoLegal.DIVIDA_ATIVA));
            if (isEstorno.booleanValue() && isDividaAtiva) {
                throw new EloValidationException("N\u00e3o \u00e9 permitido estorno de parcelas em d\u00edvida ativa.");
            }
        }
    }

    private void validaDebitoParcelado(CancelamentoTributosFormDTO cancelamentoTributosFormDTO) {
        if (!this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.PERMITE_CANCELAMENTO_DEBITO_PARCELADO).booleanValue()) {
            Map debitos = CancelamentoDebitoTributoDTO.getItensCanceladosByDebitos((List)cancelamentoTributosFormDTO.getParcelas());
            debitos.forEach((debitoIdDTO, listaCancelamentoDebitoTributoDTO) -> {
                Debito debito = (Debito)this.debitoService.findOne((Serializable)debitoIdDTO.getIdDebito());
                if (Objects.isNull(debito)) {
                    throw CancelamentoDebitoException.debitoNotFound((Long)debitoIdDTO.getExercicio(), (Long)debitoIdDTO.getDivida(), (Long)debitoIdDTO.getSubDivida(), (Long)debitoIdDTO.getTipoCadastro(), (Long)debitoIdDTO.getCadastroGeral());
                }
                if (debito.getReparcelado().booleanValue()) {
                    throw CancelamentoDebitoException.debitoReparcelado((Long)debitoIdDTO.getExercicio(), (Long)debitoIdDTO.getDivida(), (Long)debitoIdDTO.getSubDivida(), (Long)debitoIdDTO.getTipoCadastro(), (Long)debitoIdDTO.getCadastroGeral());
                }
            });
        }
    }

    private void validaCertidaoDividaAtivaDebito(CancelamentoTributosFormDTO form) {
        if (this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VALIDA_CDA_VALIDA_NO_CANCELAMENTO).booleanValue()) {
            Map debitoParcelas = form.getItensCanceladosByParcelas();
            debitoParcelas.forEach((debitoParcelaId, listaCancelamentoDebitoTributoDTO) -> {
                List certidoes = this.certidaoDividaAtivaService.findByDebitoParcela(debitoParcelaId);
                if (!certidoes.isEmpty()) {
                    throw CancelamentoDebitoException.debitoCertidaoDividaAtiva((Long)debitoParcelaId.getExercicio(), (Long)debitoParcelaId.getDivida(), (Long)debitoParcelaId.getSubDivida(), (Long)debitoParcelaId.getTipoCadastro(), (Long)debitoParcelaId.getCadastroGeral());
                }
            });
        }
    }

    public Boolean existeSituacaoLegalDiferenteEntreDebitos(List<CancelamentoDebitoTributoDTO> debitos) {
        CancelamentoDebitoTributoDTO primeiroDebito = debitos.get(0);
        return debitos.stream().anyMatch(debito -> !debito.getSituacaoLegal().equals((Object)primeiroDebito.getSituacaoLegal()));
    }

    public Optional<ValidaCancelamentoPorEstado> getServiceValidacaoPorEstado(String estado) {
        return this.serviceValidacaoPorEstado.stream().filter(service -> service.accept(estado)).findFirst();
    }

    @Generated
    public ValidaCancelamentoDebitoService(ParametroGeralService parametroGeralService, CertidaoDividaAtivaService certidaoDividaAtivaService, DebitoService debitoService, ValidaDataMovimentacaoService validaDataMovimentacaoService, ProtestoService protestoService, DebitoParcelaTributoService debitoParcelaTributoService, EntidadeServiceImpl entidadeService, List<ValidaCancelamentoPorEstado> serviceValidacaoPorEstado) {
        this.parametroGeralService = parametroGeralService;
        this.certidaoDividaAtivaService = certidaoDividaAtivaService;
        this.debitoService = debitoService;
        this.validaDataMovimentacaoService = validaDataMovimentacaoService;
        this.protestoService = protestoService;
        this.debitoParcelaTributoService = debitoParcelaTributoService;
        this.entidadeService = entidadeService;
        this.serviceValidacaoPorEstado = serviceValidacaoPorEstado;
    }
}

