/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.console.client.ConsoleClient;
import br.com.elotech.console.client.UsuarioClient;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.console.dto.RolesUsuarioDTO;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.Usuario;
import br.com.elotech.tributos.repository.UsuarioRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.impl.EntidadeServiceImpl;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import org.keycloak.representations.AccessToken;
import org.springframework.stereotype.Service;

@Service
public class UsuarioService
extends CrudService<Usuario, String> {
    private final UsuarioRepository usuarioRepository;
    private final ConsoleClient consoleClient;
    private final EntidadeServiceImpl entidadeServiceImpl;
    private final UsuarioClient usuarioClient;

    public UsuarioService(UsuarioRepository usuarioRepository, ConsoleClient consoleClient, EntidadeServiceImpl entidadeServiceImpl, UsuarioClient usuarioClient) {
        this.usuarioRepository = usuarioRepository;
        this.consoleClient = consoleClient;
        this.entidadeServiceImpl = entidadeServiceImpl;
        this.usuarioClient = usuarioClient;
    }

    public Usuario updatePermissaoTotalDivida(String idUsuario) {
        Usuario usuario;
        usuario.setPermissaoTotalDivida(Boolean.valueOf((usuario = (Usuario)this.usuarioRepository.findOne((Object)idUsuario)).getPermissaoTotalDivida() == false));
        return (Usuario)this.usuarioRepository.save((Object)usuario);
    }

    public RolesUsuarioDTO getPermissoesUsuario(Long idEntidade) {
        Entidade entidade;
        Entidade entidade2 = entidade = Objects.isNull(idEntidade) ? (Entidade)this.entidadeServiceImpl.getEntidadePrincipal().orElseThrow(() -> new EloValidationException("Entidade principal n\u00e3o encontrada.")) : (Entidade)this.entidadeServiceImpl.findById((Serializable)idEntidade).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar entidade com o id %d.", idEntidade)));
        if (Objects.isNull(entidade.getEntidadeConsole())) {
            throw new EloValidationException("Necess\u00e1rio configurar o campo \"entidadeconsole\" no cadastro da entidade.");
        }
        AccessToken accessToken = SecurityUtils.getAccessToken();
        return this.usuarioClient.findAllRolesByUsuarioAndEntidadeAndModulo(UUID.fromString(accessToken.getSubject()), entidade.getEntidadeConsole(), Modulo.OXY_TRIBUTOS);
    }
}

