/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.ParametroTotem;
import br.com.elotech.tributos.domain.SituacaoParcela;
import br.com.elotech.tributos.domain.TipoEventoSituacaoParcelaEnum;
import br.com.elotech.tributos.domain.TipoSituacaoParcela;
import br.com.elotech.tributos.repository.SituacaoParcelaRepository;
import br.com.elotech.tributos.service.EventoSituacaoParcelaService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.ParametroTotemService;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class SituacaoParcelaService
extends ReadOnlyService<SituacaoParcela, Long> {
    private final SituacaoParcelaRepository situacaoParcelaRepository;
    private final ParametroGeralService parametroGeralService;
    private final EventoSituacaoParcelaService eventoSituacaoParcelaService;
    private final ParametroTotemService parametroTotemService;

    public SituacaoParcelaService(SituacaoParcelaRepository situacaoParcelaRepository, ParametroGeralService parametroGeralService, EventoSituacaoParcelaService eventoSituacaoParcelaService, ParametroTotemService parametroTotemService) {
        this.situacaoParcelaRepository = situacaoParcelaRepository;
        this.parametroGeralService = parametroGeralService;
        this.eventoSituacaoParcelaService = eventoSituacaoParcelaService;
        this.parametroTotemService = parametroTotemService;
    }

    public SituacaoParcela getNovaSituacaoParcela(TipoEventoSituacaoParcelaEnum tipoEvento, SituacaoParcela situacaoParcelaAtual) {
        if (Objects.isNull(tipoEvento)) {
            throw new EloValidationException("Tipo de evento inv\u00e1lido para consulta de nova situa\u00e7\u00e3o da parcela.");
        }
        if (Optional.ofNullable(situacaoParcelaAtual).map(e -> e.isValid() == false).orElse(Boolean.TRUE).booleanValue()) {
            throw new EloValidationException(String.format("Situa\u00e7\u00e3o da parcela inv\u00e1lida para o tipo de evento \"%s\".", tipoEvento.getDescricao()));
        }
        boolean parametroUtilizaTabelaEvento = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_TABELA_EVENTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        Optional novaSituacaoParcela = parametroUtilizaTabelaEvento ? this.eventoSituacaoParcelaService.getNovaSituacaoParcela(tipoEvento, situacaoParcelaAtual) : tipoEvento.getSituacaoParcelaEvento().getNovaSituacaoParcela(situacaoParcelaAtual);
        return novaSituacaoParcela.map(arg_0 -> this.findSituacaoParcelaById(arg_0)).orElse(situacaoParcelaAtual);
    }

    public SituacaoParcela findSituacaoParcelaById(Long situacaoParcela) {
        return (SituacaoParcela)this.situacaoParcelaRepository.findById((Object)situacaoParcela).orElseThrow(() -> new EloValidationException("Situa\u00e7\u00e3o da parcela n\u00e3o encontrada."));
    }

    public SituacaoParcela getSituacaoParcelaNovoDebito(SituacaoParcela situacaoParcelaAtual, BigDecimal valorTotalDebitoParcela) {
        if (Optional.ofNullable(situacaoParcelaAtual).map(e -> e.isValid() == false).orElse(Boolean.TRUE).booleanValue()) {
            situacaoParcelaAtual = new SituacaoParcela();
            situacaoParcelaAtual.setId(Long.valueOf(1L));
            situacaoParcelaAtual.setTipoSituacaoParcela(TipoSituacaoParcela.ABERTO);
        }
        if (valorTotalDebitoParcela.compareTo(BigDecimal.ZERO) == 0) {
            return this.getNovaSituacaoParcela(TipoEventoSituacaoParcelaEnum.BAIXA_ISENCAO, situacaoParcelaAtual);
        }
        return this.getNovaSituacaoParcela(TipoEventoSituacaoParcelaEnum.INSCRICAO, situacaoParcelaAtual);
    }

    public SituacaoParcela findSituacaoParcelaPagoTotem(Long entidade) {
        ParametroTotem parametroTotem = this.parametroTotemService.findByEntidade(entidade);
        Long idSituacaoParcelaPagoTotem = parametroTotem.getSituacaoParcela();
        if (Objects.isNull(idSituacaoParcelaPagoTotem)) {
            throw new EloValidationException(String.format("A situa\u00e7\u00e3o da parcela para o pagamento totem est\u00e1 nula no par\u00e2metro da entidade %d.", entidade));
        }
        return this.findSituacaoParcelaById(idSituacaoParcelaPagoTotem);
    }
}

