/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.MovimentacaoDiariaId;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.movimentacaodiaria.MovimentacaoDiaria;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.domain.pagamento.SituacaoPagamentoLote;
import br.com.elotech.tributos.domain.pagamento.TipoPagamentoLote;
import br.com.elotech.tributos.dto.pagamento.PagamentoLoteDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoLoteManualDTO;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.ConvenioService;
import br.com.elotech.tributos.service.MovimentacaoDiariaService;
import br.com.elotech.tributos.service.PagamentoLoteService;
import br.com.elotech.tributos.service.PagamentoService;
import br.com.elotech.tributos.service.ParcelamentoService;
import br.com.elotech.tributos.service.ProtestoService;
import br.com.elotech.tributos.service.TransferenciaItbiService;
import br.com.elotech.tributos.service.ValidaDataMovimentacaoService;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PagamentoLoteManualService {
    private final PagamentoLoteService pagamentoLoteService;
    private final MovimentacaoDiariaService movimentacaoDiariaService;
    private final ValidaDataMovimentacaoService validaDataMovimentacaoService;
    private final PagamentoService pagamentoService;
    private final BloquetoService boletoService;
    private final ConvenioService convenioService;
    private final TransferenciaItbiService transferenciaItbiService;
    private final ParcelamentoService parcelamentoService;
    private final ProtestoService protestoService;

    @Transactional
    public PagamentoLoteDTO salvarPagamentoLote(PagamentoLoteManualDTO lote) {
        if (lote.getBoletos().isEmpty()) {
            throw new EloValidationException("Lote pagamento deve possuir pelo menos um boleto.");
        }
        this.validaMovimentacaoDiaria(lote);
        List boletos = this.validaBoletos(lote);
        PagamentoLote pagamentoLote = this.createPagamentoLote(lote);
        this.geraPagamentos(pagamentoLote, boletos, Boolean.TRUE);
        return PagamentoLoteDTO.of((PagamentoLote)this.pagamentoLoteService.fecharLote(pagamentoLote));
    }

    public void validaMovimentacaoDiaria(PagamentoLoteManualDTO lote) {
        MovimentacaoDiariaId movimentacaoDiariaId = new MovimentacaoDiariaId();
        movimentacaoDiariaId.setEntidade(lote.getEntidade());
        movimentacaoDiariaId.setData(lote.getDataMovimento());
        MovimentacaoDiaria movimentacaoDiaria = this.movimentacaoDiariaService.findOrCreateMovimentacaoDiaria(movimentacaoDiariaId);
        this.validaDataMovimentacaoService.verificaMovimentacaoDiaria(movimentacaoDiaria.getId());
    }

    public List<Pagamento> geraPagamentos(PagamentoLote pagamentoLote, List<Bloqueto> boletos, Boolean acrescimoPagamento) {
        return boletos.stream().map(boleto -> {
            Pagamento pagamento = this.pagamentoService.geraPagamentoBaixaManual(pagamentoLote, boleto, acrescimoPagamento);
            this.transferenciaItbiService.validaTransferenciaItbi(pagamento);
            this.parcelamentoService.quitarContratoParcelamento(pagamento);
            this.pagamentoService.constituirDebitosDoPagamento(pagamento);
            return pagamento;
        }).collect(Collectors.toList());
    }

    public PagamentoLote createPagamentoLote(PagamentoLoteManualDTO lote) {
        Convenio convenio = (Convenio)this.convenioService.findById((Serializable)lote.getConvenio()).orElseThrow(() -> new EloValidationException("Conv\u00eanio n\u00e3o encontrado."));
        PagamentoLoteId id = new PagamentoLoteId();
        id.setEntidade(lote.getEntidade());
        id.setExercicio(Long.valueOf(lote.getDataMovimento().getYear()));
        PagamentoLote pagamentoLote = new PagamentoLote();
        pagamentoLote.setId(id);
        pagamentoLote.setDataMovimento(lote.getDataMovimento());
        pagamentoLote.setDataCredito(lote.getDataCredito());
        pagamentoLote.setDataLote(lote.getDataLote());
        pagamentoLote.setSituacao(SituacaoPagamentoLote.ABERTO);
        pagamentoLote.setTipo(TipoPagamentoLote.MANUAL);
        pagamentoLote.setConvenio(convenio);
        pagamentoLote.setContaBancaria(convenio.getContaBancaria());
        pagamentoLote.setBanco(convenio.getBanco());
        pagamentoLote.setObservacao(lote.getObservacao());
        return (PagamentoLote)this.pagamentoLoteService.save((EloEntity)pagamentoLote, null);
    }

    private List<Bloqueto> validaBoletos(PagamentoLoteManualDTO lote) {
        return lote.getBoletos().stream().map(boletoDTO -> {
            Bloqueto boleto = (Bloqueto)this.boletoService.findById((Serializable)boletoDTO.getId()).orElseThrow(() -> new EloValidationException("Boleto n\u00e3o encontrado."));
            if (boleto.getPago().booleanValue() || boleto.validaSeBoletoComParcelaPaga()) {
                throw new EloValidationException(String.format("Boleto %d/%d pago ou com parcelas pagas.", boleto.getBloqueto(), boleto.getExercicioBloqueto()));
            }
            if (lote.getDataMovimento().isAfter(boleto.getDataVencimento())) {
                throw new EloValidationException(String.format("Boleto %d/%d vencido em rela\u00e7\u00e3o a Data Movimento.", boleto.getBloqueto(), boleto.getExercicioBloqueto()));
            }
            this.protestoService.validaDebitoProtestado(boleto.getDebitos());
            this.preencheCamposValorAcrescimoBoleto(boleto);
            return boleto;
        }).collect(Collectors.toList());
    }

    private void preencheCamposValorAcrescimoBoleto(Bloqueto boleto) {
        boleto.getDebitos().forEach(boletoDebito -> {
            boletoDebito.setValorPrincipalAcrescimo(boletoDebito.getValorPrincipal());
            boletoDebito.setValorJurosAcrescimo(boletoDebito.getValorJuros());
            boletoDebito.setValorMultaAcrescimo(boletoDebito.getValorMulta());
            boletoDebito.setValorCorrecaoAcrescimo(boletoDebito.getValorCorrecao());
        });
    }

    @Generated
    public PagamentoLoteManualService(PagamentoLoteService pagamentoLoteService, MovimentacaoDiariaService movimentacaoDiariaService, ValidaDataMovimentacaoService validaDataMovimentacaoService, PagamentoService pagamentoService, BloquetoService boletoService, ConvenioService convenioService, TransferenciaItbiService transferenciaItbiService, ParcelamentoService parcelamentoService, ProtestoService protestoService) {
        this.pagamentoLoteService = pagamentoLoteService;
        this.movimentacaoDiariaService = movimentacaoDiariaService;
        this.validaDataMovimentacaoService = validaDataMovimentacaoService;
        this.pagamentoService = pagamentoService;
        this.boletoService = boletoService;
        this.convenioService = convenioService;
        this.transferenciaItbiService = transferenciaItbiService;
        this.parcelamentoService = parcelamentoService;
        this.protestoService = protestoService;
    }
}

