/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.procuradoria.client.feign.EnviaPeticaoProcuradoriaFeignClient;
import br.com.elotech.procuradoria.dto.CancelarDocumentoDTO;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.SituacaoDocumento;
import br.com.elotech.tributos.domain.relatorio.TipoRelatorio;
import br.com.elotech.tributos.dto.CancelarMultiPeticoesDTO;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.DocumentoItemPeticaoDTO;
import br.com.elotech.tributos.dto.ErroCancelarPeticaoDTO;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.PeticaoProcuradoriaDTO;
import br.com.elotech.tributos.dto.SubReportDTO;
import br.com.elotech.tributos.dto.SubReportItemDTO;
import br.com.elotech.tributos.dto.cancelamento.CancelamentoDocumentoDTO;
import br.com.elotech.tributos.exception.PeticaoNotFoundException;
import br.com.elotech.tributos.report.loader.PeticaoDividaAtivaParamLoader;
import br.com.elotech.tributos.repository.DocumentoPeticaoRepository;
import br.com.elotech.tributos.repository.SituacaoDocumentoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.DocumentoService;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DocumentoPeticaoService {
    private final DocumentoPeticaoRepository documentoPeticaoRepository;
    private final DocumentoService documentoService;
    private final DebitoParcelaService debitoParcelaService;
    private final PeticaoDividaAtivaParamLoader peticaoDividaAtivaParamLoader;
    private final SituacaoDocumentoRepository situacaoDocumentoRepository;
    private final Optional<EnviaPeticaoProcuradoriaFeignClient> procuradoriaFeignClient;
    private static final Logger log = LoggerFactory.getLogger(DocumentoPeticaoService.class);

    public DocumentoDTO findPeticaoDividaAtiva(Long id) {
        Documento documento = (Documento)this.documentoService.findOne((Serializable)id);
        if (Objects.isNull(documento)) {
            throw new EloValidationException("Peti\u00e7\u00e3o n\u00e3o encontrado");
        }
        DocumentoDTO documentoDTO = DocumentoDTO.from((Documento)documento);
        documentoDTO.getDocumentosItensPeticaoDTO().addAll(this.documentoPeticaoRepository.findAllDocumentoPeticaoCdaByPeticao(documento.getId()));
        return documentoDTO;
    }

    public List<DocumentoItemPeticaoDTO> findDividaAtivaPorPeticao(Long id) {
        Documento documento = (Documento)this.documentoService.findById((Serializable)id).orElseThrow(() -> new PeticaoNotFoundException("Peti\u00e7\u00e3o n\u00e3o encontrada"));
        return this.documentoPeticaoRepository.findAllDocumentoPeticaoCdaByPeticao(documento.getId()).stream().filter(item -> item.getCanceladoCertidao().equals(Boolean.FALSE)).collect(Collectors.toList());
    }

    public DocumentoDTO cancelarPeticao(Long id, CancelamentoDocumentoDTO cancelamentoDocumentoDTO) {
        DocumentoDTO peticaoDTO = DocumentoDTO.from((Documento)this.documentoService.cancelarDocumento(id, cancelamentoDocumentoDTO));
        List listaDebitoParcelaDTO = this.documentoPeticaoRepository.findDebitoParcelasPorPeticao(id);
        listaDebitoParcelaDTO.forEach(arg_0 -> ((DebitoParcelaService)this.debitoParcelaService).updateSituacaoLegalParcela(arg_0));
        if (Boolean.TRUE.equals(peticaoDTO.getEnviadoProcuradoria())) {
            this.cancelaPeticaoProcuradoria(peticaoDTO);
        }
        return peticaoDTO;
    }

    public DocumentoDTO cancelarPeticaoProvindaDoProcuradoria(Long id, CancelamentoDocumentoDTO cancelamentoDocumentoDTO) {
        DocumentoDTO peticaoDTO = DocumentoDTO.from((Documento)this.documentoService.cancelarDocumento(id, cancelamentoDocumentoDTO));
        List listaDebitoParcelaDTO = this.documentoPeticaoRepository.findDebitoParcelasPorPeticao(id);
        listaDebitoParcelaDTO.forEach(arg_0 -> ((DebitoParcelaService)this.debitoParcelaService).updateSituacaoLegalParcela(arg_0));
        return peticaoDTO;
    }

    public ImprimirRelatorioDTO buildImpressaoPeticaoDTO(Long id) {
        DocumentoDTO documento = this.findPeticaoDividaAtiva(id);
        if (Objects.isNull(documento.getRelatorio())) {
            throw new EloValidationException("Relat\u00f3rio n\u00e3o encontrado ou n\u00e3o configurado na peti\u00e7\u00e3o de d\u00edvida ativa");
        }
        ImprimirRelatorioDTO dto = new ImprimirRelatorioDTO();
        dto.setRelatorio(Integer.valueOf(documento.getRelatorio().intValue()));
        dto.setModulo(documento.getModulo());
        dto.setTipoRelatorio(TipoRelatorio.fromValue((String)documento.getTipoRelatorio()));
        dto.setFiltro(String.format(" td.Exercicio = %d and td.Documento = %d", documento.getExercicio(), documento.getDocumento()));
        dto.setListParametros(this.peticaoDividaAtivaParamLoader.load(documento.getExercicio()));
        dto.setSubReports(this.createSubReportImprimirPeticao(dto.getFiltro()));
        return dto;
    }

    private SubReportDTO createSubReportImprimirPeticao(String filtro) {
        SubReportDTO subReportDTO = new SubReportDTO();
        subReportDTO.setItems((Set)Sets.newHashSet((Object[])new SubReportItemDTO[]{new SubReportItemDTO("Certidao", filtro), new SubReportItemDTO("CertidaoProprietario", filtro)}));
        return subReportDTO;
    }

    public List<DocumentoItemPeticaoDTO> findPeticoesVinculadasComCDA(Long id) {
        Documento documento = (Documento)this.documentoService.findOne((Serializable)id);
        if (Objects.isNull(documento)) {
            throw new EloValidationException("Certid\u00e3o de d\u00edvida ativa n\u00e3o encontrado");
        }
        return this.documentoPeticaoRepository.findPeticaoVinculadaComCDA(documento.getEntidade(), documento.getExercicio(), documento.getDocumento());
    }

    private CancelamentoDocumentoDTO gerarCancelamentoDocumentoDTO(CancelarMultiPeticoesDTO cancelarPeticaoEmLoteProcuradoria) {
        CancelamentoDocumentoDTO cancelamentoDocumentoDTO = new CancelamentoDocumentoDTO();
        cancelamentoDocumentoDTO.setSituacao((SituacaoDocumento)this.situacaoDocumentoRepository.findOne((Object)2L));
        cancelamentoDocumentoDTO.setObservacao(cancelarPeticaoEmLoteProcuradoria.getMotivo());
        cancelamentoDocumentoDTO.setUsuario(cancelarPeticaoEmLoteProcuradoria.getUsuario());
        return cancelamentoDocumentoDTO;
    }

    private void validarCancelamentoDePeticao(CancelarMultiPeticoesDTO cancelarPeticaoEmLote) {
        if (Objects.isNull(cancelarPeticaoEmLote.getPeticoes())) {
            throw new EloValidationException("N\u00e3o foram encontrados os documentos ou exerc\u00edcios correspondentes");
        }
        if (StringUtils.isBlank((CharSequence)cancelarPeticaoEmLote.getMotivo())) {
            throw new EloValidationException("N\u00e3o foi encontrado o motivo do cancelamento das peti\u00e7\u00f5es");
        }
    }

    private void adicionarErro(List<ErroCancelarPeticaoDTO> errosCancelarPeticaoDto, PeticaoProcuradoriaDTO peticao, String erro) {
        errosCancelarPeticaoDto.add(new ErroCancelarPeticaoDTO(peticao.getNumero(), peticao.getExercicio(), erro));
    }

    private void cancelaPeticaoProcuradoria(DocumentoDTO peticaoDTO) {
        try {
            EnviaPeticaoProcuradoriaFeignClient client = this.getProcuradoriaFeignClient();
            log.debug(String.format("Enviando a peti\u00e7\u00e3o %s/%s ao procuradoria", peticaoDTO.getDocumento(), peticaoDTO.getExercicio()));
            client.cancelarPeticao(this.createCancelamentoDTO(peticaoDTO));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new EloValidationException(e.getMessage());
        }
    }

    private CancelarDocumentoDTO createCancelamentoDTO(DocumentoDTO peticaoDTO) {
        CancelarDocumentoDTO cancelamentoDTO = new CancelarDocumentoDTO();
        cancelamentoDTO.setDocumento(peticaoDTO.getDocumento());
        cancelamentoDTO.setExercicio(peticaoDTO.getExercicio());
        cancelamentoDTO.setObservacaoCancelamento(peticaoDTO.getObservacaoCancelamento());
        cancelamentoDTO.setUsuarioCancelamento(SecurityUtils.getUserAise());
        return cancelamentoDTO;
    }

    private EnviaPeticaoProcuradoriaFeignClient getProcuradoriaFeignClient() {
        return (EnviaPeticaoProcuradoriaFeignClient)this.procuradoriaFeignClient.orElseThrow(() -> new EloValidationException("Client da procuradoria n\u00e3o esta dispon\u00edvel"));
    }

    public List<ErroCancelarPeticaoDTO> cancelarPeticaoEmLote(CancelarMultiPeticoesDTO cancelarPeticaoEmLote) {
        this.validarCancelamentoDePeticao(cancelarPeticaoEmLote);
        ArrayList<ErroCancelarPeticaoDTO> errosCancelarPeticaoDto = new ArrayList<ErroCancelarPeticaoDTO>();
        CancelamentoDocumentoDTO cancelamentoDocumentoDTO = this.gerarCancelamentoDocumentoDTO(cancelarPeticaoEmLote);
        cancelarPeticaoEmLote.getPeticoes().forEach(peticao -> this.documentoService.findDocumentoByNumeroDocumentoExercicioTipo(peticao.getNumero(), peticao.getExercicio()).ifPresentOrElse(documento -> {
            try {
                log.debug(String.format(String.format("Iniciando cancelamento do documento %d, peticao %d, exercicio %d e idPeticao %d", documento.getDocumento(), peticao.getNumero(), peticao.getExercicio(), peticao.getId()), new Object[0]));
                this.cancelarPeticaoProvindaDoProcuradoria(documento.getId(), cancelamentoDocumentoDTO);
            }
            catch (Exception e) {
                this.adicionarErro(errosCancelarPeticaoDto, peticao, "Erro ao cancelar peti\u00e7\u00e3o: " + e.getMessage());
            }
        }, () -> this.adicionarErro(errosCancelarPeticaoDto, peticao, String.format("Erro ao cancelar peti\u00e7\u00e3o. Documento n\u00e3o encontrado para n\u00famero de documento %s e exerc\u00edcio %s", peticao.getNumero(), peticao.getExercicio()))));
        return errosCancelarPeticaoDto;
    }

    @Generated
    public DocumentoPeticaoService(DocumentoPeticaoRepository documentoPeticaoRepository, DocumentoService documentoService, DebitoParcelaService debitoParcelaService, PeticaoDividaAtivaParamLoader peticaoDividaAtivaParamLoader, SituacaoDocumentoRepository situacaoDocumentoRepository, Optional<EnviaPeticaoProcuradoriaFeignClient> procuradoriaFeignClient) {
        this.documentoPeticaoRepository = documentoPeticaoRepository;
        this.documentoService = documentoService;
        this.debitoParcelaService = debitoParcelaService;
        this.peticaoDividaAtivaParamLoader = peticaoDividaAtivaParamLoader;
        this.situacaoDocumentoRepository = situacaoDocumentoRepository;
        this.procuradoriaFeignClient = procuradoriaFeignClient;
    }
}

