/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.ContaBancaria;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.PagamentoBoleto;
import br.com.elotech.tributos.domain.PagamentoDebito;
import br.com.elotech.tributos.domain.PagamentoDebitoId;
import br.com.elotech.tributos.domain.PagamentoId;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.SituacaoDevolucaoCredito;
import br.com.elotech.tributos.domain.TipoEventoSituacaoParcelaEnum;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCredito;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCreditoDebito;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCreditoDebitoId;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCreditoItem;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCreditoItemId;
import br.com.elotech.tributos.domain.movimentacaodiaria.SituacaoMovimentacaoDiaria;
import br.com.elotech.tributos.domain.pagamentocredito.PagamentoCredito;
import br.com.elotech.tributos.dto.MovimentacaoDiariaDTO;
import br.com.elotech.tributos.dto.devolucaocredito.DevolucaoCreditoRestituicaoDTO;
import br.com.elotech.tributos.dto.devolucaocredito.DevolucaoCreditoRestituicaoResumoDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoDebitoPorTributoDTO;
import br.com.elotech.tributos.enums.SituacaoPagamentoDebitoEnum;
import br.com.elotech.tributos.repository.DebitoParcelaTributoRepository;
import br.com.elotech.tributos.repository.DevolucaoCreditoRepository;
import br.com.elotech.tributos.repository.PagamentoDebitoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ContaBancariaService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.DevolucaoCreditoDebitoService;
import br.com.elotech.tributos.service.MotivoDeducaoService;
import br.com.elotech.tributos.service.MovimentacaoDiariaService;
import br.com.elotech.tributos.service.PagamentoBoletoService;
import br.com.elotech.tributos.service.PagamentoService;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.SituacaoParcelaService;
import br.com.elotech.tributos.service.pagamentocredito.CreditoService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class DevolucaoCreditoService
extends CrudService<DevolucaoCredito, Long> {
    private final MotivoDeducaoService motivoDeducaoService;
    private final PessoaService pessoaService;
    private final CadastroGeralService cadastroGeralService;
    private final DevolucaoCreditoRepository devolucaoCreditoRepository;
    private final ContaBancariaService contaBancariaService;
    private final DebitoParcelaTributoRepository debitoParcelaTributoRepository;
    private final DevolucaoCreditoDebitoService devolucaoCreditoDebitoService;
    private final PagamentoDebitoRepository pagamentoDebitoRepository;
    private final SituacaoParcelaService situacaoParcelaService;
    private final DebitoParcelaService debitoParcelaService;
    private final MovimentacaoDiariaService movimentacaoDiariaService;
    private final CreditoService pagamentoCreditoService;
    private final PagamentoBoletoService pagamentoBoletoService;
    private final PagamentoService pagamentoService;

    public Page<DevolucaoCreditoRestituicaoDTO> getDevolucaoCreditos(Optional<String> search, Pageable pageable) {
        return this.findByRsql(search.orElse(""), pageable).map(DevolucaoCreditoRestituicaoDTO::from);
    }

    public List<DevolucaoCreditoItem> saveItens(DevolucaoCreditoRestituicaoResumoDTO devolucaoCreditoRestituicaoDTO, DevolucaoCredito devolucaoCredito) {
        AtomicLong sequenciaItem = new AtomicLong(1L);
        List<DevolucaoCreditoItem> devolucaoCreditoItems = devolucaoCreditoRestituicaoDTO.getItens().stream().map(item -> {
            DevolucaoCreditoItem devolucaoCreditoItem = new DevolucaoCreditoItem();
            DevolucaoCreditoItemId devolucaoCreditoItemId = new DevolucaoCreditoItemId();
            BigDecimal valorDevolucao = item.getPagamentoDebitos().stream().map(PagamentoDebitoPorTributoDTO::getValorADevolver).reduce(BigDecimal.ZERO, BigDecimal::add);
            PagamentoCredito pagamentoCredito = this.getCreditoIfExists(item.getIdCredito());
            Pagamento pagamento = this.getPagamentoIfExists(item.getEntidade(), item.getPagamento(), item.getExercicioPagamento());
            devolucaoCreditoItem.setCadastroGeral((CadastroGeral)this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(item.getTipoCadastro(), item.getCadastroGeral()).orElseThrow(() -> new EloValidationException("Cadastro Geral n\u00e3o encontrado.")));
            devolucaoCreditoItem.setValorDevolucao(valorDevolucao);
            devolucaoCreditoItem.setValorCorrecao(item.getValorCorrecao());
            devolucaoCreditoItem.setValorCorrigido(item.getValorCorrigido());
            devolucaoCreditoItem.setEntidade(item.getEntidade());
            devolucaoCreditoItemId.setSequenciaItem(Long.valueOf(sequenciaItem.getAndIncrement()));
            devolucaoCreditoItemId.setDevolucaoCredito(devolucaoCredito);
            devolucaoCreditoItem.setId(devolucaoCreditoItemId);
            devolucaoCreditoItem.setPagamentoCredito(pagamentoCredito);
            devolucaoCreditoItem.setPagamento(pagamento);
            AtomicLong sequenciaDebito = new AtomicLong(1L);
            ArrayList devolucaoCreditoDebitos = new ArrayList();
            item.getPagamentoDebitos().forEach(debitoDTO -> {
                this.validateSaldoItem(debitoDTO);
                DevolucaoCreditoDebitoId devolucaoCreditoDebitoId = new DevolucaoCreditoDebitoId();
                devolucaoCreditoDebitoId.setDevolucaoCreditoItem(devolucaoCreditoItem);
                devolucaoCreditoDebitoId.setSequenciaDebito(Long.valueOf(sequenciaDebito.getAndIncrement()));
                DevolucaoCreditoDebito devolucaoCreditoDebito = new DevolucaoCreditoDebito();
                devolucaoCreditoDebito.setId(devolucaoCreditoDebitoId);
                devolucaoCreditoDebito.setValorOriginal(debitoDTO.getValorCalculado());
                devolucaoCreditoDebito.setValorDevolvido(debitoDTO.getValorADevolver());
                devolucaoCreditoDebito.setDebitoParcelaTributo((DebitoParcelaTributo)this.debitoParcelaTributoRepository.findById((Object)debitoDTO.getIdDebitoParcelatributo()).orElseThrow(() -> new EloValidationException("Debito Parcela Tributo n\u00e3o encontrado.")));
                devolucaoCreditoDebito.setPagamentoDebito((PagamentoDebito)this.pagamentoDebitoRepository.findOne((Object)PagamentoDebitoId.of((Long)debitoDTO.getIdPagamentoBoleto(), (DebitoParcelaTributo)devolucaoCreditoDebito.getDebitoParcelaTributo())));
                devolucaoCreditoDebito.setPagamentoBoleto((PagamentoBoleto)this.pagamentoBoletoService.findOne((Serializable)debitoDTO.getIdPagamentoBoleto()));
                devolucaoCreditoDebitos.add(devolucaoCreditoDebito);
            });
            devolucaoCreditoItem.setDebitos(devolucaoCreditoDebitos);
            return devolucaoCreditoItem;
        }).collect(Collectors.toList());
        return devolucaoCreditoItems;
    }

    private PagamentoCredito getCreditoIfExists(Long idCredito) {
        if (Objects.isNull(idCredito)) {
            return null;
        }
        return (PagamentoCredito)this.pagamentoCreditoService.findById((Serializable)idCredito).orElseThrow(() -> new EloValidationException("N\u00e3o encontrado Cr\u00e9dito com ID " + idCredito));
    }

    private Pagamento getPagamentoIfExists(Long entidade, Long pagamento, Long exercicioPagamento) {
        if (Objects.isNull(pagamento) && Objects.isNull(exercicioPagamento)) {
            return null;
        }
        if (Objects.isNull(pagamento)) {
            throw new EloValidationException("Pagamento n\u00e3o informado!");
        }
        if (Objects.isNull(exercicioPagamento)) {
            throw new EloValidationException("Exerc\u00edcio n\u00e3o informado para pagamento: " + pagamento);
        }
        PagamentoId idPagamento = PagamentoId.of((Long)entidade, (Long)exercicioPagamento, (Long)pagamento);
        return (Pagamento)this.pagamentoService.findById((Serializable)idPagamento).orElseThrow(() -> new EloValidationException("N\u00e3o encontrado Pagamento: " + idPagamento.getPagamento() + " do Exerc\u00edcio: " + idPagamento.getExercicioPagamento()));
    }

    public DevolucaoCredito createDevolucaoCredito(DevolucaoCreditoRestituicaoResumoDTO devolucaoCreditoRestituicaoDTO, Long id) {
        DevolucaoCredito devolucaoCredito = new DevolucaoCredito();
        if (Objects.nonNull(id)) {
            devolucaoCredito = (DevolucaoCredito)this.devolucaoCreditoRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar devolu\u00e7\u00e3o cr\u00e9dito com id '%d'.", id)));
        }
        if (!SituacaoDevolucaoCredito.AGUARDANDO.getDescricao().equals(devolucaoCreditoRestituicaoDTO.getSituacao())) {
            throw new EloValidationException("Somente devolu\u00e7\u00f5es com a situa\u00e7\u00e3o aguardando podem ser confirmadas");
        }
        MotivoDeducao motivoDeducao = this.motivoDeducaoService.findByMotivoId(devolucaoCreditoRestituicaoDTO.getMotivoDesconto().getId());
        ContaBancaria contaBancaria = (ContaBancaria)this.contaBancariaService.findById((Serializable)devolucaoCreditoRestituicaoDTO.getContaBancaria().getId()).orElseThrow(() -> new EloValidationException("Conta Bancaria n\u00e3o encontrado."));
        Pessoa pessoa = (Pessoa)this.pessoaService.findById(devolucaoCreditoRestituicaoDTO.getPessoa().getId()).orElseThrow(() -> new EloValidationException("Pessoa n\u00e3o encontrado."));
        List itens = this.saveItens(devolucaoCreditoRestituicaoDTO, devolucaoCredito);
        BigDecimal valorDevolucao = devolucaoCreditoRestituicaoDTO.getValorDevolucao(devolucaoCreditoRestituicaoDTO);
        devolucaoCredito.setDataInclusao(devolucaoCreditoRestituicaoDTO.getDataInclusao());
        devolucaoCredito.setSituacao(SituacaoDevolucaoCredito.AGUARDANDO);
        devolucaoCredito.setData(devolucaoCreditoRestituicaoDTO.getData());
        devolucaoCredito.setContaBancaria(contaBancaria);
        devolucaoCredito.setMotivoDesconto(motivoDeducao);
        devolucaoCredito.setObservacao(devolucaoCreditoRestituicaoDTO.getObservacao());
        devolucaoCredito.setObsNotificacao(devolucaoCreditoRestituicaoDTO.getObsNotificacao());
        devolucaoCredito.setObsParecer(devolucaoCreditoRestituicaoDTO.getObsParecer());
        devolucaoCredito.setBancoCredito(devolucaoCreditoRestituicaoDTO.getBancoCredito());
        devolucaoCredito.setAgenciaCredito(devolucaoCreditoRestituicaoDTO.getAgenciaCredito());
        devolucaoCredito.setContaCredito(devolucaoCreditoRestituicaoDTO.getContaCredito());
        devolucaoCredito.setContaOperacao(devolucaoCreditoRestituicaoDTO.getContaOperacao());
        devolucaoCredito.setPessoaCredito(pessoa);
        devolucaoCredito.getItens().clear();
        devolucaoCredito.getItens().addAll(itens);
        devolucaoCredito.setValorDevolucao(valorDevolucao);
        devolucaoCredito.setEntidade(devolucaoCreditoRestituicaoDTO.getEntidade());
        devolucaoCredito.setExercicio(devolucaoCreditoRestituicaoDTO.getExercicio());
        devolucaoCredito.setTipo(devolucaoCreditoRestituicaoDTO.getTipo());
        devolucaoCredito.setProcessoSei(devolucaoCreditoRestituicaoDTO.getProcessoSei());
        return devolucaoCredito;
    }

    public DevolucaoCredito saveDevolucaoCredito(DevolucaoCreditoRestituicaoResumoDTO devolucaoCreditoRestituicaoDTO) {
        return (DevolucaoCredito)this.devolucaoCreditoRepository.save((Object)this.createDevolucaoCredito(devolucaoCreditoRestituicaoDTO, null));
    }

    public DevolucaoCredito updateDevolucaoCredito(DevolucaoCreditoRestituicaoResumoDTO devolucaoCreditoRestituicaoDTO, Long id) {
        return (DevolucaoCredito)this.devolucaoCreditoRepository.save((Object)this.createDevolucaoCredito(devolucaoCreditoRestituicaoDTO, id));
    }

    public DevolucaoCredito confirmDevolucao(Long id) {
        DevolucaoCredito devolucaoCredito = (DevolucaoCredito)this.devolucaoCreditoRepository.findById((Object)id).orElseThrow(() -> new EloValidationException("Devolu\u00e7\u00e3o cr\u00e9dito n\u00e3o encontrado."));
        if (Objects.isNull(devolucaoCredito.getData())) {
            throw new EloValidationException("\u00c9 preciso adicionar uma data para a restitui\u00e7\u00e3o!");
        }
        if (this.validateDataDevolucao(devolucaoCredito.getData()).booleanValue()) {
            throw new EloValidationException("A movimenta\u00e7\u00e3o j\u00e1 foi fechada para o dia informado!");
        }
        if (!devolucaoCredito.getSituacao().equals((Object)SituacaoDevolucaoCredito.AGUARDANDO)) {
            throw new EloValidationException("Somente devolu\u00e7\u00f5es com a situa\u00e7\u00e3o aguardando podem ser confirmadas");
        }
        devolucaoCredito.getItens().forEach(item -> {
            if (Objects.nonNull(item.getPagamentoCredito())) {
                this.updatePagamentoCredito(item);
            }
            item.getDebitos().forEach(debito -> {
                this.updateValorDevolvidoPagamentoDebito(debito);
                this.updateSituacaoParcela(debito);
            });
        });
        devolucaoCredito.setSituacao(SituacaoDevolucaoCredito.DEVOLVIDO);
        this.devolucaoCreditoRepository.save((Object)devolucaoCredito);
        return devolucaoCredito;
    }

    private void updatePagamentoCredito(DevolucaoCreditoItem devolucaoCreditoItem) {
        PagamentoCredito credito = devolucaoCreditoItem.getPagamentoCredito();
        credito.novaMovimentacao(devolucaoCreditoItem, SecurityUtils.getUserAise());
        this.pagamentoCreditoService.save(credito);
    }

    private Boolean validateDataDevolucao(LocalDate data) {
        MovimentacaoDiariaDTO dia = this.movimentacaoDiariaService.findSituacaoByDataMovimento(data.toString());
        return !SituacaoMovimentacaoDiaria.ABERTO.getCodigo().equals(dia.getCodigoSituacao());
    }

    private void updateSituacaoParcela(DevolucaoCreditoDebito debito) {
        Boolean deveAtualizarSituacao = this.verificarSeDeveAtualizarSituacao(debito);
        if (Boolean.TRUE.equals(deveAtualizarSituacao)) {
            this.atualizarSituacaoDebitoParcela(debito.getDebitoParcelaTributo().getDebitoParcela());
        }
    }

    private Boolean verificarSeDeveAtualizarSituacao(DevolucaoCreditoDebito debito) {
        if (Boolean.TRUE.equals(debito.getValorDevolvido().compareTo(debito.getValorOriginal()) == 0)) {
            return Boolean.TRUE;
        }
        BigDecimal valorTotalDevolvido = this.calcularValorTotalDevolvido(debito);
        return valorTotalDevolvido.compareTo(debito.getValorOriginal()) == 0;
    }

    private BigDecimal calcularValorTotalDevolvido(DevolucaoCreditoDebito debito) {
        BigDecimal valorTotalAnterior = this.devolucaoCreditoDebitoService.findAllValorDevolvido(debito.getDebitoParcelaTributo());
        return valorTotalAnterior.add(debito.getValorDevolvido());
    }

    private void atualizarSituacaoDebitoParcela(DebitoParcela debitoParcela) {
        debitoParcela.setSituacaoDebito(this.situacaoParcelaService.getNovaSituacaoParcela(TipoEventoSituacaoParcelaEnum.ESTORNO_PAGAMENTO, debitoParcela.getSituacaoDebito()));
        debitoParcela.setDataSituacao(LocalDate.now());
        this.debitoParcelaService.save((EloEntity)debitoParcela, null);
    }

    private void updateValorDevolvidoPagamentoDebito(DevolucaoCreditoDebito debito) {
        List pagamentosAtualizados = debito.getPagamentoBoleto().getPagamentosDebito().stream().filter(p -> p.getId().getDebitoParcelaTributo().equals((Object)debito.getDebitoParcelaTributo())).map(p -> this.atualizarPagamentoDebito(p, debito)).collect(Collectors.toList());
        this.pagamentoDebitoRepository.saveAll(pagamentosAtualizados);
    }

    private PagamentoDebito atualizarPagamentoDebito(PagamentoDebito pagamento, DevolucaoCreditoDebito debito) {
        BigDecimal valorDevolvido = debito.getValorDevolvido();
        BigDecimal novoValorDevolvido = pagamento.getValorDevolvido().add(valorDevolvido);
        pagamento.setValorDevolvido(novoValorDevolvido);
        if (novoValorDevolvido.compareTo(BigDecimal.ZERO) == 0) {
            pagamento.setSituacao(SituacaoPagamentoDebitoEnum.NORMAL);
        } else {
            boolean devolucaoParcial = novoValorDevolvido.compareTo(pagamento.getValorPago()) < 0;
            pagamento.setSituacao(devolucaoParcial ? SituacaoPagamentoDebitoEnum.DEVOLVIDOPARCIAL : SituacaoPagamentoDebitoEnum.DEVOLVIDO);
        }
        return pagamento;
    }

    private void validateSaldoItem(PagamentoDebitoPorTributoDTO item) {
        if (item.getSaldoADevolver().compareTo(item.getValorADevolver()) < 0) {
            String infoDebito = String.format("Cadastro: %d/%d, Exerc\u00edcio: %d, D\u00edvida: %d, Sub: %d, Parcela: %d, Tributo: %s", item.getTipoCadastro(), item.getCadastroGeral(), item.getExercicioDebito(), item.getDivida(), item.getSubDivida(), item.getParcela(), item.getTributo());
            throw new EloValidationException("O valor da devolu\u00e7\u00e3o n\u00e3o pode ser maior do que o valor do saldo. Referente ao d\u00e9bito com " + infoDebito);
        }
    }

    @Generated
    public DevolucaoCreditoService(MotivoDeducaoService motivoDeducaoService, PessoaService pessoaService, CadastroGeralService cadastroGeralService, DevolucaoCreditoRepository devolucaoCreditoRepository, ContaBancariaService contaBancariaService, DebitoParcelaTributoRepository debitoParcelaTributoRepository, DevolucaoCreditoDebitoService devolucaoCreditoDebitoService, PagamentoDebitoRepository pagamentoDebitoRepository, SituacaoParcelaService situacaoParcelaService, DebitoParcelaService debitoParcelaService, MovimentacaoDiariaService movimentacaoDiariaService, CreditoService pagamentoCreditoService, PagamentoBoletoService pagamentoBoletoService, PagamentoService pagamentoService) {
        this.motivoDeducaoService = motivoDeducaoService;
        this.pessoaService = pessoaService;
        this.cadastroGeralService = cadastroGeralService;
        this.devolucaoCreditoRepository = devolucaoCreditoRepository;
        this.contaBancariaService = contaBancariaService;
        this.debitoParcelaTributoRepository = debitoParcelaTributoRepository;
        this.devolucaoCreditoDebitoService = devolucaoCreditoDebitoService;
        this.pagamentoDebitoRepository = pagamentoDebitoRepository;
        this.situacaoParcelaService = situacaoParcelaService;
        this.debitoParcelaService = debitoParcelaService;
        this.movimentacaoDiariaService = movimentacaoDiariaService;
        this.pagamentoCreditoService = pagamentoCreditoService;
        this.pagamentoBoletoService = pagamentoBoletoService;
        this.pagamentoService = pagamentoService;
    }
}

