/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.arquivos.domain.response.ArquivoUrl;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Contencioso;
import br.com.elotech.tributos.domain.ContenciosoDebito;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.dto.contencioso.ContenciosoRecalculoDTO;
import br.com.elotech.tributos.dto.contencioso.ContenciosoRecalculoDebitoDTO;
import br.com.elotech.tributos.enums.SituacaoRecalculoContencioso;
import br.com.elotech.tributos.repository.ContenciosoDebitoRepository;
import br.com.elotech.tributos.repository.ContenciosoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.ExercicioService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.ModeloBoletoService;
import br.com.elotech.tributos.service.batch.ContenciosoRecalculoJobStarter;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.util.ByteMultipartFile;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.domain.TipoArquivoEnum;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.tomcat.util.http.fileupload.ByteArrayOutputStream;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@Service
public class ContenciosoRecalculoService {
    private static final String PATH_TRIBUTOS_S3 = "oxy_tributos/%s";
    private ContenciosoRepository contenciosoRepository;
    private ContenciosoDebitoRepository contenciosoDebitoRepository;
    private ExercicioService exercicioService;
    private ContenciosoRecalculoJobStarter contenciosoRecalculoJobStarter;
    private ModeloBoletoService modeloBoletoService;
    private GeraBoletoService geraBoletoService;
    private AisePdfService aisePdfService;
    private ArquivoStorageFeignClient arquivoStorageFeignClient;
    private DebitoService debitoService;

    public void recalcularContencioso(Long idContencioso, ContenciosoRecalculoDTO contenciosoRecalculoDTO) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JsonProcessingException, JobRestartException {
        Contencioso contencioso = (Contencioso)this.contenciosoRepository.findById((Object)idContencioso).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "Contencioso com id %d n\u00e3o foi localizado"));
        Long exercicioAtual = this.exercicioService.getExercicio();
        ArrayList debitosParaRecalculo = new ArrayList();
        contenciosoRecalculoDTO.getDebitos().forEach(cd -> contencioso.getDebitos().stream().filter(contenciosoDebito -> contenciosoDebito.getId().equals((Object)cd.getId()) && cd.isSelected() != false).findFirst().ifPresent(contenciosoDebito -> {
            ContenciosoRecalculoDebitoDTO dto = new ContenciosoRecalculoDebitoDTO();
            dto.setId(contenciosoDebito.getId());
            dto.setTipo(contenciosoRecalculoDTO.getTipo());
            dto.setDataPrimeiroVencimento(cd.getDataPrimeiroVencimento());
            debitosParaRecalculo.add(dto);
        }));
        this.contenciosoRecalculoJobStarter.startJob(idContencioso, exercicioAtual, contenciosoRecalculoDTO.getIdDivida(), debitosParaRecalculo);
    }

    public String gerarBoleto(Long idDebitoRecalculo) throws IOException {
        List bloquetos = this.createBoletos(idDebitoRecalculo, LocalDate.now());
        PDDocument pdf = new PDDocument();
        for (Bloqueto bloqueto : bloquetos) {
            this.mergePdfBoleto(pdf, bloqueto.getExercicioBloqueto(), bloqueto.getBloqueto());
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("idDebitoRecalculo", idDebitoRecalculo.toString());
        String nomeArquivo = String.format("boleto_contenciosodebito_%d_%s.pdf", idDebitoRecalculo, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmm")));
        return this.savePdfAndUploadArquivoS3(pdf, metadata, nomeArquivo);
    }

    public String gerarBoletos(Long idContencioso) throws IOException {
        Contencioso contencioso = (Contencioso)this.contenciosoRepository.findById((Object)idContencioso).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "Contencioso com id %d n\u00e3o foi localizado"));
        List debitos = contencioso.getDebitos().stream().filter(d -> SituacaoRecalculoContencioso.DEBITO_GERADO.equals((Object)d.getSituacaoRecalculo())).collect(Collectors.toList());
        PDDocument pdf = new PDDocument();
        for (ContenciosoDebito contenciosoDebito : debitos) {
            if (!Objects.nonNull(contenciosoDebito.getIdDebitoRecalculo())) continue;
            List bloquetos = this.createBoletos(contenciosoDebito.getIdDebitoRecalculo(), LocalDate.now());
            for (Bloqueto bloqueto : bloquetos) {
                this.mergePdfBoleto(pdf, bloqueto.getExercicioBloqueto(), bloqueto.getBloqueto());
            }
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("idContencioso", idContencioso.toString());
        String nomeArquivo = String.format("boletos_contencioso_%d_%s.pdf", idContencioso, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmm")));
        return this.savePdfAndUploadArquivoS3(pdf, metadata, nomeArquivo);
    }

    private List<Bloqueto> createBoletos(Long idDebito, LocalDate dataReferencia) {
        Debito debito = (Debito)this.debitoService.findOne((Serializable)idDebito);
        List parcelas = debito.getParcelas().stream().map(dp -> DebitoParcelaDTO.from((Long)debito.getId(), (Long)dp.getId().getParcela())).distinct().collect(Collectors.toList());
        ModeloBoleto modeloBoleto = this.modeloBoletoService.retornarConfiguracaoModeloBoletoSequencia();
        GeraBoletoDTO geraBoletoDTO = new GeraBoletoDTO();
        geraBoletoDTO.setDataReferencia(dataReferencia);
        geraBoletoDTO.setOrigemEmissao(OrigemEmissao.AISE_WEB);
        geraBoletoDTO.setTipoBoleto(TipoBloqueto.PARCELADO);
        geraBoletoDTO.setSomenteConstituidos(Boolean.TRUE);
        geraBoletoDTO.setDebitos(parcelas);
        geraBoletoDTO.setModeloBoleto(modeloBoleto);
        return this.geraBoletoService.geraBoleto(geraBoletoDTO);
    }

    private void mergePdfBoleto(PDDocument pdf, Long exercicioBoleto, Long boleto) throws IOException {
        byte[] infoBoleto;
        ImpressaoDTO impressaoDTO = ImpressaoDTO.from((String)this.aisePdfService.fetchBloquetoByExercicio(boleto, exercicioBoleto));
        try (InputStream inputBoletoDoTermo = new URL(impressaoDTO.getUrl()).openStream();){
            infoBoleto = inputBoletoDoTermo.readAllBytes();
        }
        this.mergeInfoToDocument(pdf, infoBoleto);
    }

    private void appendInfoToDocument(PDDocument document, PDFMergerUtility pdfMerge, byte[] info) throws IOException {
        PDDocument pdfDocument = PDDocument.load((byte[])info);
        pdfMerge.appendDocument(document, pdfDocument);
        pdfDocument.close();
    }

    private void mergeInfoToDocument(PDDocument document, byte[] infoToAppendDocumento) throws IOException {
        try {
            PDFMergerUtility pdfMerge = new PDFMergerUtility();
            this.appendInfoToDocument(document, pdfMerge, infoToAppendDocumento);
        }
        catch (Exception ex) {
            throw new IOException(String.format("Erro ao juntar documentos. %s", ex.getMessage()));
        }
    }

    private String savePdfAndUploadArquivoS3(PDDocument pdf, HashMap<String, String> metadata, String nomeArquivo) throws IOException {
        try (InputStream fileStream = this.saveDocument(pdf);){
            ByteMultipartFile byteMultipartFile = new ByteMultipartFile(fileStream.readAllBytes(), "application/pdf");
            ArquivoDTO arquivoDTO = new ArquivoDTO(null, nomeArquivo, SecurityUtils.getUserId(), TipoArquivoEnum.OUTROS, Modulo.OXY_TRIBUTOS, "/contencioso", LocalDate.now(), "application/pdf", null, null, metadata);
            ArquivoDTO storageResponse = this.arquivoStorageFeignClient.createWithFile(arquivoDTO, (MultipartFile)byteMultipartFile);
            ArquivoUrl arquivoUrl = this.arquivoStorageFeignClient.getUrlDownload(storageResponse.getFullPath(), storageResponse.getNome());
            String string = arquivoUrl.getUrlAssinada();
            return string;
        }
    }

    private InputStream saveDocument(PDDocument document) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            document.save((OutputStream)byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }
    }

    @Generated
    public ContenciosoRecalculoService(ContenciosoRepository contenciosoRepository, ContenciosoDebitoRepository contenciosoDebitoRepository, ExercicioService exercicioService, ContenciosoRecalculoJobStarter contenciosoRecalculoJobStarter, ModeloBoletoService modeloBoletoService, GeraBoletoService geraBoletoService, AisePdfService aisePdfService, ArquivoStorageFeignClient arquivoStorageFeignClient, DebitoService debitoService) {
        this.contenciosoRepository = contenciosoRepository;
        this.contenciosoDebitoRepository = contenciosoDebitoRepository;
        this.exercicioService = exercicioService;
        this.contenciosoRecalculoJobStarter = contenciosoRecalculoJobStarter;
        this.modeloBoletoService = modeloBoletoService;
        this.geraBoletoService = geraBoletoService;
        this.aisePdfService = aisePdfService;
        this.arquivoStorageFeignClient = arquivoStorageFeignClient;
        this.debitoService = debitoService;
    }
}

