/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.acrescimo.IndiceComposto;
import br.com.elotech.tributos.domain.acrescimo.IndiceCorrecao;
import br.com.elotech.tributos.domain.acrescimo.ValorIndice;
import br.com.elotech.tributos.domain.parcelamento.LoteParcelamentoReajusteItem;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamento;
import br.com.elotech.tributos.domain.parcelamento.Parcelamento;
import br.com.elotech.tributos.dto.parcelamento.SituacaoReajusteParcelamentoLoteItem;
import br.com.elotech.tributos.exception.DebitoParcelaTributoEmptyException;
import br.com.elotech.tributos.exception.FormaCorrecaoException;
import br.com.elotech.tributos.exception.ParametrosParcelamentoException;
import br.com.elotech.tributos.service.DebitoParcelaTributoService;
import br.com.elotech.tributos.service.acrescimo.calculo.correcao.CalculoCorrecaoException;
import br.com.elotech.tributos.service.acrescimo.calculo.correcao.CalculoCorrecaoUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Month;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AtualizacaoMonetariaAnualService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtualizacaoMonetariaAnualService.class);
    private final DebitoParcelaTributoService debitoParcelaTributoService;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public LoteParcelamentoReajusteItem atualizaMonetariamenteParcelamanto(LoteParcelamentoReajusteItem item) {
        try {
            Parcelamento parcelamento = item.getParcelamento();
            log.info("Iniciando atualizacao monetarioa do parcelamento {}", (Object)parcelamento.getId());
            LocalDate data = LocalDate.of(item.getAno().intValue(), Month.JANUARY, 1);
            List debitoParcelaTributos = this.debitoParcelaTributoService.findDebitoParcelaTributoAbertoByParcelamento(parcelamento.getId());
            if (debitoParcelaTributos.isEmpty()) {
                throw new DebitoParcelaTributoEmptyException(String.format("Nenhum d\u00e9bito parcela tribtuo em aberto foi encontrado para esse parcelamento: [Id:%d]", parcelamento.getId()));
            }
            log.info("{} DebitoParcelaTributos encontrados", (Object)debitoParcelaTributos.size());
            ParamParcelamento paramParcelamento = Optional.ofNullable(parcelamento.getParamParcelamento()).orElseThrow(() -> new ParametrosParcelamentoException(HttpStatus.NOT_FOUND, String.format("N\u00e3o encontrato Par\u00e2meto para o Parcelamento [Id: %d]", parcelamento.getId())));
            FormaCorrecao formaCorrecao = Optional.ofNullable(paramParcelamento.getFormaCorrecao()).orElseThrow(() -> FormaCorrecaoException.notFound((Long)parcelamento.getId()));
            IndiceComposto indiceComposto = CalculoCorrecaoUtils.getIndiceCompostoByData((FormaCorrecao)formaCorrecao, (LocalDate)data);
            IndiceCorrecao indiceCorrecao = indiceComposto.getIndiceCorrecao();
            ValorIndice valorIndice = Optional.ofNullable(indiceCorrecao.getValorIndiceByData(data)).orElseThrow(() -> CalculoCorrecaoException.valorIndiceNotDefined((LocalDate)data, (IndiceCorrecao)indiceComposto.getIndiceCorrecao()));
            BigDecimal valorIndiceValor = Optional.ofNullable(valorIndice.getValor()).orElse(BigDecimal.ZERO);
            BigDecimal fatorAjustado = BigDecimal.ONE.add(valorIndiceValor);
            debitoParcelaTributos.forEach(debito -> {
                BigDecimal valorDebito = debito.getValor();
                if (Objects.nonNull(valorDebito)) {
                    BigDecimal valorAjustado = valorDebito.multiply(fatorAjustado);
                    BigDecimal valorAjuste = valorDebito.multiply(valorIndiceValor);
                    debito.setValor(valorAjustado);
                    debito.setValorAtualizacao(valorAjuste);
                }
            });
            item.setValorPercentAplicado(valorIndiceValor);
            item.setSituacaoReajusteParcelamentoLote(SituacaoReajusteParcelamentoLoteItem.SUCCESS);
            item.setMensagem(String.format("Forma de Corre\u00e7\u00e3o [%s] - \u00cdndice de Corre\u00e7\u00e3o [%s] - Valor \u00edndice [%09.4f]: Aplicado ao parcelamento [id: %d] ", formaCorrecao.getDescricao(), indiceCorrecao.getDescricao(), valorIndiceValor, parcelamento.getId()));
            log.info("Finalizado atualizacao monetarioa do parcelamento {}", (Object)parcelamento.getId());
            return item;
        }
        catch (Exception e) {
            log.error("Nao foi possivel finalizar a atualizacao monet\u00e1ria", (Throwable)e);
            item.setSituacaoReajusteParcelamentoLote(SituacaoReajusteParcelamentoLoteItem.ERROR);
            item.setMensagem(e.getClass().getName() + ": " + e.getMessage());
            return item;
        }
    }

    @Generated
    public AtualizacaoMonetariaAnualService(DebitoParcelaTributoService debitoParcelaTributoService) {
        this.debitoParcelaTributoService = debitoParcelaTributoService;
    }
}

