/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.security;

import br.com.elotech.multitenant.client.TenantClient;
import br.com.elotech.multitenant.filter.TenantPreAuthFilter;
import br.com.elotech.multitenant.util.TenantUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreAuthOverwriteFilter
extends TenantPreAuthFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PreAuthOverwriteFilter.class);

    public PreAuthOverwriteFilter(TenantClient tenantClient, ObjectMapper objectMapper, List<String> whiteList) {
        super(tenantClient, objectMapper, whiteList);
    }

    protected String resolveTenantId(HttpServletRequest request) {
        String defaultTenantId = super.resolveTenantId(request);
        log.debug("Processando tenant para a uri {}", (Object)request.getRequestURI());
        if (!request.getRequestURI().matches(request.getContextPath() + "/api/integracao-boleto/\\d+/webhook.*")) {
            return defaultTenantId;
        }
        log.debug("Recebida requisi\u00e7\u00e3o de webhook Pix");
        String forwardedHeader = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{request.getHeader("X-FORWARDED-HOST"), "default"});
        String host = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{request.getHeader("host"), "default"});
        boolean shouldChangeHeaders = !forwardedHeader.contains(".elotech.com.br") && host.contains(".elotech.com.br");
        log.debug("Forwarded header: {}; Host: {}, shouldChangeHeaders: {}", new Object[]{forwardedHeader, host, shouldChangeHeaders});
        if (!shouldChangeHeaders) {
            return defaultTenantId;
        }
        String resolvedTenantId = TenantUtils.getTenantId((String)host, (String)host);
        log.debug("Tenant Resolvido: {}", (Object)resolvedTenantId);
        return resolvedTenantId;
    }
}

