/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.rocada;

import br.com.elotech.tributos.domain.rocada.TipoRocada;
import br.com.elotech.tributos.dto.rocada.TipoRocadaDTO;
import br.com.elotech.tributos.service.rocada.TipoRocadaService;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tipos-rocada"})
public class TipoRocadaResource {
    private final TipoRocadaService tipoRocadaService;

    @GetMapping(value={"/{id}"})
    public ResponseEntity<TipoRocadaDTO> findOne(@PathVariable Long id) {
        return ResponseEntity.ok((Object)TipoRocadaDTO.from((TipoRocada)this.tipoRocadaService.findByIdAndEntidadePrincipalAndExercicioAtual(id)));
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<TipoRocadaDTO>> search(@RequestParam String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.tipoRocadaService.search(search, pageable).map(TipoRocadaDTO::from));
    }

    @PostMapping
    public ResponseEntity<TipoRocadaDTO> save(@RequestBody @Valid TipoRocadaDTO tipoRocada) {
        return ResponseEntity.ok((Object)this.tipoRocadaService.save(tipoRocada));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> remove(@PathVariable Long id) {
        this.tipoRocadaService.deleteByIdAndEntidadePrincipalAndExercicioAtual(id);
        return ResponseEntity.ok().build();
    }

    @Generated
    public TipoRocadaResource(TipoRocadaService tipoRocadaService) {
        this.tipoRocadaService = tipoRocadaService;
    }
}

