/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.relatoriogerencialarrecadacao;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.relatoriogerencialarrecadacao.PrevisaoArrecadacao;
import br.com.elotech.tributos.domain.relatoriogerencialarrecadacao.PrevisaoArrecadacaoId;
import br.com.elotech.tributos.service.relatoriogerencial.lancamentoarrecadacao.PrevisaoArrecadacaoService;
import java.io.Serializable;
import java.util.Comparator;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/previsao-arrecadacao"})
@Transactional
public class PrevisaoArrecadacaoResource
extends CrudResource<PrevisaoArrecadacao, PrevisaoArrecadacaoId> {
    private final PrevisaoArrecadacaoService previsaoArrecadacaoService;

    public PrevisaoArrecadacaoResource(PrevisaoArrecadacaoService previsaoArrecadacaoService) {
        this.previsaoArrecadacaoService = previsaoArrecadacaoService;
    }

    @GetMapping(value={"/id/{entidade}/{exercicio}/{idPrevisaoArrecadacao}"})
    public ResponseEntity<PrevisaoArrecadacao> findOne(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long idPrevisaoArrecadacao) {
        PrevisaoArrecadacaoId id = PrevisaoArrecadacaoId.of((Long)entidade, (Long)exercicio, (Long)idPrevisaoArrecadacao);
        PrevisaoArrecadacao previsaoArrecadacao = (PrevisaoArrecadacao)this.previsaoArrecadacaoService.findOne((Serializable)id);
        previsaoArrecadacao.getPrevisaoArrecadacaoMes().sort(Comparator.comparing(m -> m.getId().getMes()));
        return ResponseEntity.ok((Object)previsaoArrecadacao);
    }

    @PutMapping(value={"/id/{entidade}/{exercicio}/{idPrevisaoArrecadacao}"})
    public ResponseEntity<PrevisaoArrecadacao> update(@RequestBody @Valid PrevisaoArrecadacao previsaoArrecadacao, @PathVariable(value="entidade") Long entidade, @PathVariable(value="exercicio") Long exercicio, @PathVariable(value="idPrevisaoArrecadacao") Long idPrevisaoArrecadacao, Authentication authentication) {
        PrevisaoArrecadacaoId id = PrevisaoArrecadacaoId.of((Long)entidade, (Long)exercicio, (Long)idPrevisaoArrecadacao);
        return this.update((EloEntity)previsaoArrecadacao, (Serializable)id, authentication);
    }

    @PostMapping
    public ResponseEntity<PrevisaoArrecadacao> save(@RequestBody @Valid PrevisaoArrecadacao previsaoArrecadacao, Authentication authentication) {
        PrevisaoArrecadacao previsaoArrecadacaoSaved = (PrevisaoArrecadacao)this.previsaoArrecadacaoService.save((EloEntity)previsaoArrecadacao, authentication);
        return ResponseEntity.ok((Object)previsaoArrecadacaoSaved);
    }
}

