/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.pagamentocredito;

import br.com.elotech.tributos.domain.PagamentoId;
import br.com.elotech.tributos.domain.pagamentocredito.PagamentoCredito;
import br.com.elotech.tributos.dto.pagamentocredito.PagamentoCreditoPageDTO;
import br.com.elotech.tributos.resource.pagamentocredito.PagamentoCreditoContextResource;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pagamento-credito"})
public class CreditoResource
extends PagamentoCreditoContextResource<PagamentoCredito, Long> {
    @GetMapping(path={"/por-pagamento/{entidade}/{exercicio}/{pagamento}"})
    public ResponseEntity<PagamentoCredito> getCadastrosByCnpjCpf(@PathVariable(value="entidade") Long idEntidade, @PathVariable(value="exercicio") Long exercicio, @PathVariable(value="pagamento") Long idPagamento) {
        PagamentoId pagamentoId = PagamentoId.of((Long)idEntidade, (Long)exercicio, (Long)idPagamento);
        return ResponseEntity.ok().body((Object)this.contextService.getCredito().findByPagamentoId(pagamentoId));
    }

    @GetMapping(value={"/listagem"})
    public ResponseEntity<PagamentoCreditoPageDTO> findAllDTO(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.contextService.getCredito().findByRsqlWithTotal(search, pageable));
    }
}

