/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaoelogeo;

import br.com.elotech.tributos.dto.integracaoelogeo.ModeloCampoElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.ModeloGrupoElogeoDTO;
import br.com.elotech.tributos.service.integracaoelogeo.GrupoElogeoService;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/modelo/grupo"})
public class ModeloGrupoElogeoResource {
    private final GrupoElogeoService grupoElogeoService;

    @Operation(summary="Retorna uma lista de grupos de modelos")
    @GetMapping
    public ResponseEntity<Page<ModeloGrupoElogeoDTO>> findAll(Pageable page) {
        return ResponseEntity.ok((Object)this.grupoElogeoService.findAllGrupo(page));
    }

    @Operation(summary="Retorna um modelogrupo em espec\u00edfico")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<ModeloGrupoElogeoDTO> findById(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.grupoElogeoService.findGrupoById(id));
    }

    @Operation(summary="Retorna os campos de um modelogrupo")
    @GetMapping(value={"/{id}/campos"})
    public ResponseEntity<List<ModeloCampoElogeoDTO>> findCamposByIdGrupo(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.grupoElogeoService.findCamposByIdGrupo(id));
    }

    @Generated
    public ModeloGrupoElogeoResource(GrupoElogeoService grupoElogeoService) {
        this.grupoElogeoService = grupoElogeoService;
    }
}

