/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaocontabil;

import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import br.com.elotech.tributos.dto.integracaocontabil.ArrecadacaoPorLoteDTO;
import br.com.elotech.tributos.dto.integracaocontabil.ArrecadacaoPorLotePrintDTO;
import br.com.elotech.tributos.dto.integracaocontabil.FiltroArrecadacaoPorLoteDTO;
import br.com.elotech.tributos.dto.integracaocontabil.ResumoArrecadacaoPorLoteDTO;
import br.com.elotech.tributos.service.integracaocontabil.ArrecadacaoPorLoteService;
import com.google.common.base.Stopwatch;
import java.util.List;
import javax.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/arrecadacao-por-lote"})
public class ArrecadacaoPorLoteResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArrecadacaoPorLoteResource.class);
    private final ArrecadacaoPorLoteService arrecadacaoPorLoteService;
    private final BaseExport baseExport;

    public ArrecadacaoPorLoteResource(ArrecadacaoPorLoteService arrecadacaoPorLoteService, BaseExport baseExport) {
        this.arrecadacaoPorLoteService = arrecadacaoPorLoteService;
        this.baseExport = baseExport;
    }

    @PostMapping(value={"/imprimir"})
    public ModelAndView imprimir(@RequestBody @Valid FiltroArrecadacaoPorLoteDTO filtro, @RequestParam(value="fields") String fields, @RequestParam(value="sumFields") String sumFields, Pageable pageable) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.debug("Imprimir - consulta arrecada\u00e7\u00e3o por lote.");
        List lotePrintDTOS = this.arrecadacaoPorLoteService.imprimir(filtro, pageable);
        log.debug("Imprimir - consulta arrecada\u00e7\u00e3o por lote levou {}", (Object)stopwatch.stop());
        ReportParam reportParam = ReportParam.builder().clazzDTO(ArrecadacaoPorLotePrintDTO.class).fields(fields).sumFields(sumFields).maxRecord(lotePrintDTOS.size()).page((Page)new PageImpl(lotePrintDTOS, pageable, (long)lotePrintDTOS.size())).reportTitle("Consulta Resumo de Arrecada\u00e7\u00e3o por Lote").searchFilter(filtro.getSearch()).build();
        return this.baseExport.toHTML(reportParam);
    }

    @PostMapping(value={"/resumo"})
    public ResponseEntity<ResumoArrecadacaoPorLoteDTO> consultaArrecadacaoPorLote(@RequestBody @Valid FiltroArrecadacaoPorLoteDTO filtro) {
        return ResponseEntity.ok((Object)this.arrecadacaoPorLoteService.resumo(filtro));
    }

    @PostMapping(value={"/consulta"})
    public ResponseEntity<Page<ArrecadacaoPorLoteDTO>> consulta(@RequestBody @Valid FiltroArrecadacaoPorLoteDTO filtro, Pageable pageable) {
        return ResponseEntity.ok((Object)this.arrecadacaoPorLoteService.consulta(filtro, pageable));
    }
}

