/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.CertificadoSantander;
import br.com.elotech.tributos.domain.ParametroPix;
import br.com.elotech.tributos.dto.ParametroPixDTO;
import br.com.elotech.tributos.service.ParametroPixService;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/parametros-pix"})
public class ParametroPixResource {
    private final ParametroPixService parametroPixService;

    @GetMapping(value={"/{entidade}"})
    public ResponseEntity<ParametroPix> findOne(@PathVariable(name="entidade") Long idEntidade) {
        return ResponseEntity.ok((Object)((ParametroPix)this.parametroPixService.findOne((Serializable)idEntidade)));
    }

    @PostMapping
    public ResponseEntity<ParametroPix> save(ParametroPixDTO parametroPixDTO, @RequestParam(required=false) MultipartFile certificadoItau, @RequestParam(required=false) MultipartFile certificadoBradesco, @RequestParam(required=false) MultipartFile certificadoSicoob, @RequestParam(required=false) MultipartFile certificadoSicredi, @RequestParam(required=false) MultipartFile arquivoCertSantander, @RequestParam(required=false) MultipartFile certificadoBancoBrasil, @RequestParam(required=false) MultipartFile certificadoDelBank) throws IOException {
        ParametroPix parametro = this.parametroPixService.findById((Serializable)parametroPixDTO.getEntidade()).orElse(new ParametroPix());
        parametro.setEntidade(parametroPixDTO.getEntidade());
        parametro.setSenhaCertificadoItau(parametroPixDTO.getSenhaCertificadoItau());
        parametro.setCertificadoItau(Objects.nonNull(certificadoItau) ? certificadoItau.getBytes() : null);
        parametro.setNomeArquivoCertificadoItau(Objects.nonNull(parametro.getCertificadoItau()) ? parametroPixDTO.getNomeArquivoCertificadoItau() : null);
        parametro.setCertificadoBradesco(Objects.nonNull(certificadoBradesco) ? certificadoBradesco.getBytes() : null);
        parametro.setSenhaCertificadoBradesco(parametroPixDTO.getSenhaCertificadoBradesco());
        parametro.setNomeArquivoCertificadoBradesco(Objects.nonNull(parametro.getCertificadoBradesco()) ? parametroPixDTO.getNomeArquivoCertificadoBradesco() : null);
        parametro.setSenhaCertificadoSicoob(parametroPixDTO.getSenhaCertificadoSicoob());
        parametro.setCertificadoSicoob(Objects.nonNull(certificadoSicoob) ? certificadoSicoob.getBytes() : null);
        parametro.setNomeArquivoCertificadoSicoob(Objects.nonNull(parametro.getCertificadoSicoob()) ? parametroPixDTO.getNomeArquivoCertificadoSicoob() : null);
        parametro.setSenhaCertificadoSicredi(parametroPixDTO.getSenhaCertificadoSicredi());
        parametro.setCertificadoSicredi(Objects.nonNull(certificadoSicredi) ? certificadoSicredi.getBytes() : null);
        parametro.setNomeArquivoCertificadoSicredi(Objects.nonNull(parametro.getCertificadoSicredi()) ? parametroPixDTO.getNomeArquivoCertificadoSicredi() : null);
        parametro.setSenhaCertificadoBancoBrasil(parametroPixDTO.getSenhaCertificadoBancoBrasil());
        parametro.setCertificadoBancoBrasil(Objects.nonNull(certificadoBancoBrasil) ? certificadoBancoBrasil.getBytes() : null);
        parametro.setNomeArquivoCertificadoBancoBrasil(Objects.nonNull(parametro.getCertificadoBancoBrasil()) ? parametroPixDTO.getNomeArquivoCertificadoBancoBrasil() : null);
        parametro.setSenhaCertificadoDelBank(parametroPixDTO.getSenhaCertificadoDelBank());
        parametro.setCertificadoDelBank(Objects.nonNull(certificadoDelBank) ? certificadoDelBank.getBytes() : null);
        parametro.setNomeArquivoCertificadoDelBank(Objects.nonNull(parametro.getCertificadoDelBank()) ? parametroPixDTO.getNomeArquivoCertificadoDelBank() : null);
        if (Objects.nonNull(parametroPixDTO.getCertificadoSantander())) {
            CertificadoSantander santander = new CertificadoSantander();
            santander.setCertificado(Objects.nonNull(arquivoCertSantander) ? arquivoCertSantander.getBytes() : this.parametroPixService.getSavedSantanderCertificado(parametro));
            santander.setSenhaCertificadoSantander(this.parametroPixService.sanitizeString(parametroPixDTO.getCertificadoSantander().getSenhaCertificadoSantander()));
            santander.setNomeArquivoCertificadoSantander(this.parametroPixService.sanitizeString(parametroPixDTO.getCertificadoSantander().getNomeArquivoCertificadoSantander()));
            if (Objects.nonNull(santander.getCertificado())) {
                parametro.setCertificadoSantander(santander);
            }
        }
        return ResponseEntity.ok((Object)this.parametroPixService.save(parametro));
    }

    @Generated
    public ParametroPixResource(ParametroPixService parametroPixService) {
        this.parametroPixService = parametroPixService;
    }
}

