/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoUsuario;
import br.com.elotech.tributos.repository.projections.ParamParcelamentoUsuarioProjection;
import br.com.elotech.tributos.service.ParamParcelamentoUsuarioService;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/paramparcelamento-usuario"})
public class ParamParcelamentoUsuarioResource {
    private final ParamParcelamentoUsuarioService paramUsuarioService;

    public ParamParcelamentoUsuarioResource(ParamParcelamentoUsuarioService paramUsuarioService) {
        this.paramUsuarioService = paramUsuarioService;
    }

    @DeleteMapping(value={"/{idParametroParcelamento}/{usuario}"})
    public ResponseEntity<Void> delete(@PathVariable Long idParametroParcelamento, @PathVariable String usuario) {
        this.paramUsuarioService.delete(idParametroParcelamento, usuario);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/{idParametroParcelamento}/{usuario}"})
    public ResponseEntity<ParamParcelamentoUsuario> save(@PathVariable Long idParametroParcelamento, @PathVariable String usuario) {
        return ResponseEntity.ok((Object)this.paramUsuarioService.save(idParametroParcelamento, usuario));
    }

    @GetMapping(value={"/{usuario}"})
    public ResponseEntity<List<ParamParcelamentoUsuarioProjection>> getAllByUsuario(@PathVariable String usuario) {
        return ResponseEntity.ok((Object)this.paramUsuarioService.getAllByUsuario(usuario));
    }

    @PostMapping(value={"/copy/{usuarioASerCopiado}/{usuarioAReceber}"})
    public ResponseEntity<List<ParamParcelamentoUsuario>> copy(@PathVariable String usuarioASerCopiado, @PathVariable String usuarioAReceber) {
        return ResponseEntity.ok((Object)this.paramUsuarioService.copy(usuarioASerCopiado, usuarioAReceber));
    }
}

