/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.dto.ValueBlockDashDTO;
import br.com.elotech.tributos.dto.atendimento.AtendimentoChartDTO;
import br.com.elotech.tributos.service.AtendimentoService;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.ParcelamentoService;
import java.time.LocalDate;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/dashboard"})
public class DashboardResource {
    private final AtendimentoService atendimentoService;
    private final ParcelamentoService parcelamentoService;
    private final BloquetoService bloquetoService;

    public DashboardResource(AtendimentoService atendimentoService, ParcelamentoService parcelamentoService, BloquetoService bloquetoService) {
        this.atendimentoService = atendimentoService;
        this.parcelamentoService = parcelamentoService;
        this.bloquetoService = bloquetoService;
    }

    @GetMapping(value={"/atendimentos/ultimos-dias"})
    public ResponseEntity<List<AtendimentoChartDTO>> loadAtendimentosNosUltimosDias() {
        return ResponseEntity.ok((Object)this.atendimentoService.findAtendimentosNosUltimosDias());
    }

    @GetMapping(value={"/atendimentos/tempo-medio"})
    public ResponseEntity<ValueBlockDashDTO> tempoMedioAtendimento() {
        return ResponseEntity.ok((Object)this.atendimentoService.getTempoMedioAtendimento());
    }

    @GetMapping(value={"/boletos/gerados-no-dia"})
    public ResponseEntity<ValueBlockDashDTO> quantidadeBoletosDoDia() {
        return ResponseEntity.ok((Object)this.bloquetoService.getQuantidadeBoletosGerados(LocalDate.now()));
    }

    @GetMapping(value={"/contrato-parcelamentos/gerados-no-dia"})
    public ResponseEntity<ValueBlockDashDTO> quantidadeParcelamentos() {
        return ResponseEntity.ok((Object)this.parcelamentoService.getQuantidadeContratosGerados(LocalDate.now()));
    }
}

