/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.tributos.domain.parcelamento.AtualizacaoMonetaria;
import br.com.elotech.tributos.domain.parcelamento.LoteParcelamentoReajuste;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.atualizacaomonetariaparcelamento.AtualizacaoMonetariaItemDTO;
import br.com.elotech.tributos.dto.atualizacaomonetariaparcelamento.AtualizacaoMonetariaParcelamentoParams;
import br.com.elotech.tributos.dto.atualizacaomonetariaparcelamento.EstornoAtualizacaoMonetariaParcelamentoParams;
import br.com.elotech.tributos.dto.atualizacaomonetariaparcelamento.FiltroItensAtualizacaoMonetariaDTO;
import br.com.elotech.tributos.dto.atualizacaomonetariaparcelamento.TotalizadorAtualizacaoMonetariaDTO;
import br.com.elotech.tributos.dto.parcelamento.AtualizacaoMonetariaDTO;
import br.com.elotech.tributos.exception.LoteParcelamentoReajusteNotFoundException;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.AtualizacaoMonetariaService;
import br.com.elotech.tributos.service.LoteParcelamentoReajusteService;
import br.com.elotech.tributos.service.batch.atualizacaomonetariaparcelamento.AtualizacaoMonetariaParcelamentoJobStarter;
import br.com.elotech.tributos.service.batch.atualizacaomonetariaparcelamento.EstornoAtualizacaoMonetariaParcelamentoJobStarter;
import br.com.elotech.tributos.service.parcelametoreajuste.LoteReajusteParcelamentoJobStarter;
import java.io.Serializable;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/atualizacao-monetaria"})
public class AtualizacaoMonetariaResource
extends ReadOnlyResource<AtualizacaoMonetaria, Long> {
    private final LoteParcelamentoReajusteService loteParcelamentoReajusteService;
    private final LoteReajusteParcelamentoJobStarter loteReajusteParcelamentoJobStarter;
    private final AtualizacaoMonetariaParcelamentoJobStarter atualizacaoMonetariaParcelamentoJobStarter;
    private final EstornoAtualizacaoMonetariaParcelamentoJobStarter estornoAtualizacaoMonetariaParcelamentoJobStarter;
    private final AtualizacaoMonetariaService atualizacaoMonetariaService;

    @PostMapping(path={"/atualizar/loteReajuste"})
    public ResponseEntity<Void> reajustarParcelamentoLote(@RequestBody AtualizacaoMonetariaDTO request) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        UserSecurityDTO user = SecurityUtils.getUserSecurityDTO();
        LoteParcelamentoReajuste parcelamentoReajuste = this.loteParcelamentoReajusteService.createLoteParcelamentoReajuste(request, user.getPreferredUsername());
        this.loteReajusteParcelamentoJobStarter.startJob(parcelamentoReajuste);
        return ResponseEntity.accepted().build();
    }

    @PostMapping(value={"/reprocessar-parcelamento/{loteParcelamentoReajusteId}"})
    public ResponseEntity<Void> reprocessarAjusteMonetarioParcelamento(@PathVariable Long loteParcelamentoReajusteId) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        LoteParcelamentoReajuste loteParcelamentoReajuste = (LoteParcelamentoReajuste)this.loteParcelamentoReajusteService.findById((Serializable)loteParcelamentoReajusteId).orElseThrow(() -> new LoteParcelamentoReajusteNotFoundException(loteParcelamentoReajusteId));
        this.loteReajusteParcelamentoJobStarter.startJob(loteParcelamentoReajuste);
        return ResponseEntity.accepted().build();
    }

    @PostMapping(value={"/mensal"})
    public ResponseEntity<Void> startAtualizacaoMensalJob(@RequestBody @Valid AtualizacaoMonetariaParcelamentoParams params) throws Exception {
        this.atualizacaoMonetariaParcelamentoJobStarter.startJob(params);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/estornar"})
    public ResponseEntity<Void> startEstornoAtualizacaoMensalJob(@RequestBody @Valid EstornoAtualizacaoMonetariaParcelamentoParams params) throws Exception {
        this.estornoAtualizacaoMonetariaParcelamentoJobStarter.startJob(params);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/{id}/itens"})
    public ResponseEntity<Page<AtualizacaoMonetariaItemDTO>> searchItensById(@PathVariable(value="id") Long id, @RequestParam(name="agrupadoPorDebito", required=false, defaultValue="true") Boolean agrupadoPorDebito, FiltroItensAtualizacaoMonetariaDTO params, Pageable pageable) {
        return ResponseEntity.ok((Object)this.atualizacaoMonetariaService.searchItensById(id, params, agrupadoPorDebito, pageable));
    }

    @GetMapping(value={"/{id}/totalizadores"})
    public ResponseEntity<TotalizadorAtualizacaoMonetariaDTO> getTotalizadorAtualizacaoMonetaria(@PathVariable(value="id") Long id, FiltroItensAtualizacaoMonetariaDTO filtros) {
        return ResponseEntity.ok((Object)this.atualizacaoMonetariaService.getTotalizadorAtualizacaoMonetaria(id, filtros));
    }

    @Generated
    public AtualizacaoMonetariaResource(LoteParcelamentoReajusteService loteParcelamentoReajusteService, LoteReajusteParcelamentoJobStarter loteReajusteParcelamentoJobStarter, AtualizacaoMonetariaParcelamentoJobStarter atualizacaoMonetariaParcelamentoJobStarter, EstornoAtualizacaoMonetariaParcelamentoJobStarter estornoAtualizacaoMonetariaParcelamentoJobStarter, AtualizacaoMonetariaService atualizacaoMonetariaService) {
        this.loteParcelamentoReajusteService = loteParcelamentoReajusteService;
        this.loteReajusteParcelamentoJobStarter = loteReajusteParcelamentoJobStarter;
        this.atualizacaoMonetariaParcelamentoJobStarter = atualizacaoMonetariaParcelamentoJobStarter;
        this.estornoAtualizacaoMonetariaParcelamentoJobStarter = estornoAtualizacaoMonetariaParcelamentoJobStarter;
        this.atualizacaoMonetariaService = atualizacaoMonetariaService;
    }
}

