/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.impl;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.util.DebitoParcelaRowMapper;
import br.com.elotech.tributos.util.SqlUtils;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

/*
 * Exception performing whole class analysis ignored.
 */
@Repository
public class DebitoParcelaRepositoryImpl {
    private static final String TIPO_CADASTRO = "tipoCadastro";
    private static final String CADASTRO_GERAL = "cadastroGeral";
    private static final String SITUACAO_LEGAL = "situacaoLegal";
    private static final String LIMIT = "limit";
    private static final String OFF_SET = "offset";
    private static final String DIVIDA_ASC = "divida ASC";
    private static final String GUIARECOLHIMENTO_ASC = "guiarecolhimento ASC";
    private static final String REFERENCIA = "TD.";
    private static final String SQL_FIND_DEBITO_PARCELA = "br/com/elotech/tributos/repository/find-debito-parcela-by-cadastro-and-tipocadastro.sql";
    private static final String SQL_NOTEXISTS_FROM_CDA = "br/com/elotech/tributos/repository/notexists-from-cda-by-debito-parcela.sql";
    private static final String AND = " AND ";
    private static final String ORDERBY = " ORDER BY ";
    private static final String LIMIT_AND_OFF = " LIMIT :limit OFFSET :offset";
    private static final Integer SITUACAO_LEGAL_EM_DIVIDA_ATIVA = 1;
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public DebitoParcelaRepositoryImpl(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public Page<DebitoParcela> findDebitosSemVinculoCda(Long tipoCadastro, Long cadastroGeral, String search, Pageable pageable) {
        String baseSql = DebitoParcelaRepositoryImpl.getBaseSql((String)search);
        String orderByString = SqlUtils.convertSortToString((Sort)pageable.getSort());
        String orderByWithPrefix = this.addDpPrefixToOrderBy(orderByString);
        String paginatedSql = baseSql + orderByWithPrefix + " LIMIT :limit OFFSET :offset";
        MapSqlParameterSource parameters = new MapSqlParameterSource().addValue("tipoCadastro", (Object)tipoCadastro).addValue("cadastroGeral", (Object)cadastroGeral).addValue("situacaoLegal", (Object)SITUACAO_LEGAL_EM_DIVIDA_ATIVA).addValue("limit", (Object)pageable.getPageSize()).addValue("offset", (Object)pageable.getOffset());
        List debitos = this.jdbcTemplate.query(paginatedSql, (SqlParameterSource)parameters, (RowMapper)new DebitoParcelaRowMapper(this.jdbcTemplate));
        String countSql = "SELECT COUNT(*) FROM (" + baseSql + ") AS total";
        Integer total = (Integer)this.jdbcTemplate.queryForObject(countSql, (SqlParameterSource)parameters, Integer.class);
        int totalCount = total != null ? total : 0;
        return new PageImpl(debitos, pageable, (long)totalCount);
    }

    private String addDpPrefixToOrderBy(String orderByString) {
        StringBuilder orderByClause = new StringBuilder(" ORDER BY ");
        String[] fields = orderByString.split(",");
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i].trim();
            if ("divida ASC".equalsIgnoreCase(field)) {
                field = "guiarecolhimento ASC";
            }
            if (i > 0) {
                orderByClause.append(", ");
            }
            orderByClause.append("TD.").append(field);
        }
        return orderByClause.toString();
    }

    private static String getBaseSql(String search) {
        String translatedSearch = DebitoParcelaRepositoryImpl.translateSearch((String)search);
        Object baseSql = FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/find-debito-parcela-by-cadastro-and-tipocadastro.sql");
        String notExists = FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/notexists-from-cda-by-debito-parcela.sql");
        if (!translatedSearch.isEmpty()) {
            baseSql = (String)baseSql + " AND " + translatedSearch + " ";
        }
        baseSql = (String)baseSql + notExists + " ";
        return baseSql;
    }

    private static String translateSearch(String search) {
        if (search == null || search.isEmpty()) {
            return "";
        }
        return search.replace("==", "=").replace("!=", "<>").replace("=CIN=", "IN").replace("=COUT=", "NOT IN");
    }
}

