/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.rsql.sql.SqlWhere;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.debitoautomatico.ConsultaDebitoAutomaticoDTO;
import br.com.elotech.tributos.dto.debitoautomatico.ConsultaDebitoAutomaticoDetalheDTO;
import br.com.elotech.tributos.repository.DebitoAutomaticoOpcaoCustom;
import br.com.elotech.tributos.util.SqlUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DebitoAutomaticoOpcaoRepositoryImpl
implements DebitoAutomaticoOpcaoCustom {
    private static final String CONSULTA_DEBITOS_AUTOMATICOS_REMESSA = "br/com/elotech/tributos/repository/find-debito-automatico-remessa.sql";
    private static final String CONSULTA_DEBITOS_AUTOMATICOS_REMESSA_DETALHE = "br/com/elotech/tributos/repository/find-debito-automatico-remessa-detalhe.sql";
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public DebitoAutomaticoOpcaoRepositoryImpl(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    private Optional<SqlWhere> getFitrosSemFiltroComplexo(String search) {
        if (StringUtils.isNotBlank((CharSequence)search)) {
            String searchFinal = Arrays.stream(search.split(" and ")).collect(Collectors.joining(" and "));
            return StringUtils.isNotBlank((CharSequence)searchFinal) ? Optional.of(RsqlUtils.transformToSql((String)searchFinal, ConsultaDebitoAutomaticoDTO.class)) : Optional.empty();
        }
        return Optional.empty();
    }

    public Page<ConsultaDebitoAutomaticoDTO> consultaDebitosAutomaticos(String search, Pageable pageable) {
        String sql = FileUtils.readResourceAsString((String)CONSULTA_DEBITOS_AUTOMATICOS_REMESSA);
        Optional fitrosSemFiltroComplexo = this.getFitrosSemFiltroComplexo(search);
        StringBuilder stringBuilder = new StringBuilder();
        fitrosSemFiltroComplexo.ifPresent(sqlWhere -> stringBuilder.append(String.format(" and %s ", sqlWhere.getWhere()).replace("and banco", "and bc.banco").replace("and convenio", "and tdao.convenio")));
        String finalSql = sql.replace("$[FILTROS]", stringBuilder.toString());
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        if (fitrosSemFiltroComplexo.isPresent()) {
            parameters = new MapSqlParameterSource(((SqlWhere)fitrosSemFiltroComplexo.get()).getParams());
        }
        String sqlContagem = String.format("select count(*) as total from (%s) count_query", finalSql);
        Long numeroTotal = (Long)this.jdbcTemplate.queryForObject(sqlContagem, (SqlParameterSource)parameters, (rs, rowNum) -> rs.getLong("total"));
        String sqlComPaginacao = SqlUtils.withPagination((String)finalSql, (Pageable)pageable, (DataSource)this.jdbcTemplate.getJdbcTemplate().getDataSource());
        List lista = this.jdbcTemplate.query(sqlComPaginacao, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ConsultaDebitoAutomaticoDTO.class));
        return new PageImpl(lista, pageable, numeroTotal.longValue());
    }

    public List<ConsultaDebitoAutomaticoDetalheDTO> consultaDetalhesDaRemessaById(Long id) {
        String sql = FileUtils.readResourceAsString((String)CONSULTA_DEBITOS_AUTOMATICOS_REMESSA_DETALHE);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("idRemessa", (Object)id);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ConsultaDebitoAutomaticoDetalheDTO.class));
    }
}

