/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.rsql.sql.SqlWhere;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.CadastroGeralResponsavelDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoCadastroDTO;
import br.com.elotech.tributos.repository.CadastroGeralCustomRepository;
import br.com.elotech.tributos.util.SqlUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CadastroGeralRepositoryImpl
implements CadastroGeralCustomRepository {
    private static final String CADASTRO_GERAL_RESPONSAVEL = "br/com/elotech/tributos/repository/find-cadastro-geral-responsavel.sql";
    private static final String CADASTRO_GERAL_SOCIO_RESPONSAVEL = "br/com/elotech/tributos/repository/find-cadastro-geral-socio-responsavel.sql";
    private static final String CADASTRO_GERAL_POR_CPF_CNPJ = "br/com/elotech/tributos/repository/find-cadastro-por-cpf-cnpj.sql";
    private static final String EXCLUSAO_LOGICA_CADASTRO_GERAL_POR_ID = "br/com/elotech/tributos/repository/find-exclusao-logica-cadastro-geral-por-id.sql";
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public CadastroGeralRepositoryImpl(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<CadastroGeralResponsavelDTO> findSocioMobiliario(Long tipoCadastro, Long cadastroGeral) {
        String sql = FileUtils.readResourceAsString((String)CADASTRO_GERAL_SOCIO_RESPONSAVEL);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("tipoCadastro", (Object)tipoCadastro);
        parameters.addValue("cadastroGeral", (Object)cadastroGeral);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(CadastroGeralResponsavelDTO.class));
    }

    public List<CadastroGeralResponsavelDTO> findProprietario(Long tipoCadastro, Long cadastroGeral) {
        String sql = FileUtils.readResourceAsString((String)CADASTRO_GERAL_RESPONSAVEL);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("tipoCadastro", (Object)tipoCadastro);
        parameters.addValue("cadastroGeral", (Object)cadastroGeral);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(CadastroGeralResponsavelDTO.class));
    }

    public Page<ParcelamentoCadastroDTO> getCadastrosByCpfCnpj(String cpfCnpj, Optional<String> search, Pageable page) {
        String sql = FileUtils.readResourceAsString((String)CADASTRO_GERAL_POR_CPF_CNPJ);
        String finalSql = sql.replace("$[FILTROS]", this.addFilterCadastros(cpfCnpj, search));
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        Optional fitrosSemFiltroComplexo = this.getFitrosSemFiltroComplexo(search);
        if (fitrosSemFiltroComplexo.isPresent()) {
            parameters = new MapSqlParameterSource(((SqlWhere)fitrosSemFiltroComplexo.get()).getParams());
        }
        parameters.addValue("cpfCnpj", (Object)cpfCnpj);
        return this.getConsultaPaginada(finalSql, parameters, page);
    }

    private StringBuilder addFilterCadastros(String cpfCnpj, Optional<String> search) {
        StringBuilder stringBuilder = new StringBuilder();
        if (search.isPresent()) {
            String filtro = search.get();
            if (filtro.contains("vencido==true") || filtro.contains("vencido==false")) {
                stringBuilder.append(String.format(" AND %s (select 1                   from tribcadastrogeral geral                  where geral.tipocadastro = ende.tipocadastro                    and geral.cadastrogeral = ende.cadastrogeral                    and exists (select 1                                  from tribdebito deb                                 inner join tribcadastrogeral cg on deb.cadastrogeral = cg.cadastrogeral                                 inner join tribdebitoparcela par on deb.entidade = par.entidade                                                          and deb.exercicio = par.exercicio                                                          and deb.tipocadastro = par.tipocadastro                                                          and deb.cadastrogeral = par.cadastrogeral                                                          and deb.guiarecolhimento = par.guiarecolhimento                                                          and deb.subdivida = par.subdivida                                 inner join tribsituacaoparcela sit on par.situacaodebito = sit.situacaoparcela                                 inner join tribtiposituacaoparcela tip on sit.situacaoparcela = tip.tiposituacaoparcela                                 where deb.tipocadastro = geral.tipocadastro                                   and deb.cadastrogeral = geral.cadastrogeral                                   and deb.constituido = 'S'                                   and tip.tiposituacaoparcela = 1                                   and par.datavencimento < current_date)) ", filtro.contains("vencido==true") ? "exists" : "not exists"));
            }
            if (filtro.contains("tipoVinculo==PRINCIPAL") || filtro.contains("tipoVinculo!=CORESPONSAVEL")) {
                stringBuilder.append(" and (exists (select 1 from tribproprietario p2         join pessoa ps on p2.pessoa = ps.pessoa          where p2.tipocadastro = p.tipocadastro           and p2.cadastrogeral = p.cadastrogeral           and ps.cnpj_cpf = :cpfCnpj           and p2.coresponsavelprincipal = 'S')  or (not exists (select 1 from tribproprietario p2                       join pessoa ps on p2.pessoa = ps.pessoa                     where p2.tipocadastro = p.tipocadastro                           and p2.cadastrogeral = p.cadastrogeral                      and p2.coresponsavelprincipal = 'S'                      and ps.cnpj_cpf <> :cpfCnpj ))) ");
            }
            if (filtro.contains("tipoVinculo==CORESPONSAVEL") || filtro.contains("tipoVinculo!=PRINCIPAL")) {
                stringBuilder.append(" and exists (select 1 from tribproprietario p2            join pessoa ps on p2.pessoa = ps.pessoa         where p2.tipocadastro = p.tipocadastro               and p2.cadastrogeral = p.cadastrogeral          and p2.coresponsavelprincipal = 'S'          and ps.cnpj_cpf <> :cpfCnpj ) ");
            }
            Optional fitrosSemFiltroComplexo = this.getFitrosSemFiltroComplexo(search);
            fitrosSemFiltroComplexo.ifPresent(sqlWhere -> stringBuilder.append(String.format(" and %s ", sqlWhere.getWhere()).replace("and tipoCadastro", "and ende.tipoCadastro").replace("and cadastroGeral", "and ende.cadastroGeral").replace("and pessoaNome", "and ende.pessoaNome")));
        }
        if (cpfCnpj.length() == 14) {
            stringBuilder.append(" and pessoaCadastro.cnpj_cpf = :cpfCnpj ");
            return stringBuilder;
        }
        stringBuilder.append(" and (pessoaCadastro.cnpj_cpf = :cpfCnpj or (pessoaProprietario.cnpj_cpf = :cpfCnpj and cg.tipocadastro in (1, 9))) ");
        return stringBuilder;
    }

    private Optional<SqlWhere> getFitrosSemFiltroComplexo(Optional<String> search) {
        if (search.isPresent()) {
            String searchFinal = Arrays.stream(search.get().split(" and ")).filter(filtro -> !filtro.contains("vencido") && !filtro.contains("tipoVinculo")).collect(Collectors.joining(" and "));
            return StringUtils.isNotBlank((CharSequence)searchFinal) ? Optional.of(RsqlUtils.transformToSql((String)searchFinal, ParcelamentoCadastroDTO.class)) : Optional.empty();
        }
        return Optional.empty();
    }

    private Page<ParcelamentoCadastroDTO> getConsultaPaginada(String finalSql, MapSqlParameterSource parameters, Pageable page) {
        String sqlContagem = String.format("select count(*) as total from (%s) count_query", finalSql);
        Long numeroTotal = (Long)this.jdbcTemplate.queryForObject(sqlContagem, (SqlParameterSource)parameters, (rs, rowNum) -> rs.getLong("total"));
        String sqlComPaginacao = SqlUtils.withPagination((String)finalSql, (Pageable)page, (DataSource)this.jdbcTemplate.getJdbcTemplate().getDataSource());
        List lista = this.jdbcTemplate.query(sqlComPaginacao, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ParcelamentoCadastroDTO.class));
        return new PageImpl(lista, page, numeroTotal.longValue());
    }
}

