/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.documento.cda;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.tributos.domain.documento.cda.LoteCda;
import br.com.elotech.tributos.dto.documento.cda.LoteCdaResumoDTO;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface LoteCdaRepository
extends CrudRepository<LoteCda, Long> {
    @Query(value="SELECT new br.com.elotech.tributos.dto.documento.cda.LoteCdaResumoDTO( TL.id, TL.dataSimulacao, TL.dataGeracao, TL.usuario, TL.usuarioGeracao, TL.situacao, TL.filtro, TL.dataImpressao, TL.idArquivoImpressao, TL.usuarioImpressao, COUNT(DISTINCT TLI.id) AS totalCdas, SUM(TLID.valor + TLID.valorJuros + TLID.valorMulta + TLID.valorCorrecao) AS valorTotal, TJE.id AS idJobSimulacao, TJE.exitMessage AS mensagemErro) FROM LoteCda TL LEFT OUTER JOIN TL.batchJobExecutionSimulacao TJE LEFT OUTER JOIN TL.itens TLI LEFT OUTER JOIN TLI.itemDetalhes TLID WHERE TL.id = :id GROUP BY TL.id, TL.dataGeracao, TL.dataSimulacao, TL.usuario, TL.usuarioGeracao, TL.situacao, TL.filtro, TL.dataImpressao, TL.idArquivoImpressao, TL.usuarioImpressao, TJE.id")
    public Optional<LoteCdaResumoDTO> getResumo(@Param(value="id") Long var1);

    @Query(value="SELECT DISTINCT TLID.IDDEBITOPARCELARECEITA FROM TRIBLOTECDA TL INNER JOIN TRIBLOTECDAITEM TLI ON TL.ID = TLI.IDLOTECDA INNER JOIN TRIBLOTECDAITEMDETALHE TLID ON TLI.ID = TLID.IDLOTECDAITEM INNER JOIN TRIBDEBITOPARCELARECEITA TDPR ON TLID.IDDEBITOPARCELARECEITA = TDPR.IDDEBITOPARCELARECEITA INNER JOIN TRIBDEBITOPARCELA TDP ON TDPR.ENTIDADE = TDP.ENTIDADE AND TDPR.EXERCICIO = TDP.EXERCICIO AND TDPR.TIPOCADASTRO = TDP.TIPOCADASTRO AND TDPR.CADASTROGERAL = TDP.CADASTROGERAL AND TDPR.GUIARECOLHIMENTO = TDP.GUIARECOLHIMENTO AND TDPR.SUBDIVIDA = TDP.SUBDIVIDA AND TDPR.PARCELA = TDP.PARCELA INNER JOIN TRIBSITUACAOPARCELA TSP ON TDP.SITUACAODEBITO = TSP.SITUACAOPARCELA INNER JOIN TRIBTIPOSITUACAOPARCELA TTSP ON TSP.TIPOSITUACAOPARCELA = TTSP.TIPOSITUACAOPARCELA WHERE TL.ID = :id AND (TTSP.TIPO = 'B'   or exists(     select 1 from tribdocumentoitemdividaativa tdida              inner join tribdocumento td                on tdida.ENTIDADE = td.ENTIDADE                     and tdida.EXERCICIO = td.EXERCICIO                     and tdida.TIPODOCUMENTO = td.TIPODOCUMENTO                     and tdida.DOCUMENTO = td.DOCUMENTO                    where tdida.entidade = tdpr.entidade                      and tdida.exerciciodebito = tdpr.exercicio                      and tdida.tipocadastro = tdpr.tipocadastro                      and tdida.cadastrogeral = tdpr.cadastrogeral                      and tdida.guiarecolhimento = tdpr.guiarecolhimento                      and tdida.subdivida = tdpr.subdivida                      and tdida.parcela = tdpr.parcela                      and tdida.receita = tdpr.receita                      and td.CANCELADO  = 'N'           ))", nativeQuery=true)
    public List<BigDecimal> findDebitoParcelaTributoInvalidoFromLoteCda(@Param(value="id") Long var1);

    @Query(value="SELECT DISTINCT TLID.IDDEBITOPARCELARECEITA FROM TRIBLOTECDA TL INNER JOIN TRIBLOTECDAITEM TLI ON TL.ID = TLI.IDLOTECDA INNER JOIN TRIBLOTECDAITEMDETALHE TLID ON TLI.ID = TLID.IDLOTECDAITEM INNER JOIN TRIBDEBITOPARCELARECEITA TDPR ON TLID.IDDEBITOPARCELARECEITA = TDPR.IDDEBITOPARCELARECEITA INNER JOIN TRIBDEBITOPARCELA TDP ON TDPR.ENTIDADE = TDP.ENTIDADE AND TDPR.EXERCICIO = TDP.EXERCICIO AND TDPR.TIPOCADASTRO = TDP.TIPOCADASTRO AND TDPR.CADASTROGERAL = TDP.CADASTROGERAL AND TDPR.GUIARECOLHIMENTO = TDP.GUIARECOLHIMENTO AND TDPR.SUBDIVIDA = TDP.SUBDIVIDA AND TDPR.PARCELA = TDP.PARCELA INNER JOIN TRIBSITUACAOPARCELA TSP ON TDP.SITUACAODEBITO = TSP.SITUACAOPARCELA INNER JOIN TRIBTIPOSITUACAOPARCELA TTSP ON TSP.TIPOSITUACAOPARCELA = TTSP.TIPOSITUACAOPARCELA WHERE TL.ID = :id AND (TTSP.TIPO = 'B')", nativeQuery=true)
    public List<BigDecimal> findDebitoParcelaTributoInvalidoFromLoteCdaPermiteMaisDeUmaCDA(@Param(value="id") Long var1);
}

