/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.atualizacaomonetaria;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.atualizacaomonetariaparcelamento.AtualizacaoMonetariaItemDTO;
import br.com.elotech.tributos.dto.atualizacaomonetariaparcelamento.AtualizacaoMonetariaParcelamentoParams;
import br.com.elotech.tributos.dto.atualizacaomonetariaparcelamento.FiltroItensAtualizacaoMonetariaDTO;
import br.com.elotech.tributos.dto.atualizacaomonetariaparcelamento.TotalizadorAtualizacaoMonetariaDTO;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.util.SqlUtils;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class AtualizacaoMonetariaParcelamentoRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtualizacaoMonetariaParcelamentoRepository.class);
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public String buildSql(AtualizacaoMonetariaParcelamentoParams params) {
        return this.buildSql(params, Boolean.valueOf(false));
    }

    private String buildSql(AtualizacaoMonetariaParcelamentoParams params, Boolean existsQuery) {
        String sql = FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/atualizacao-monetaria-parcelamentos/get-debitos-atualizacao-parcelamento-mensal.sql").replace(":ENTIDADE", params.getEntidade().toString()).replace(":MES", params.getMes().toString()).replace(":DATALANCAMENTO", StringUtils.quote((String)DateUtils.localDateToString((LocalDate)params.getDataLancamento()))).replace(":DATAVENCIMENTO", StringUtils.quote((String)DateUtils.localDateToString((LocalDate)params.getDataVencimento()))).replace(":DATAREAJUSTE", StringUtils.quote((String)DateUtils.localDateToString((LocalDate)params.getDataReajuste()))).replace(":filtroIdParcelamento", this.buildFiltroIdParcelamento(params.getIdsParcelamento(), params.getIdsParamParcelamento())).replace(":filtroParamPermiteAtualizacaoMensal", this.buildFiltroParamPermiteAtualizacaoMensal(params));
        String template = existsQuery != false ? "SELECT 1 %s" : "SELECT TD.IDDEBITO, MIN(PARCELA) AS MINPARCELA %n %s %n GROUP BY TD.IDDEBITO";
        return String.format(template, sql);
    }

    private String buildFiltroParamPermiteAtualizacaoMensal(AtualizacaoMonetariaParcelamentoParams params) {
        if (!params.getPermiteAtualizacaoMensal().booleanValue()) {
            return "";
        }
        return String.format("AND NOT EXISTS ( SELECT 1                    FROM TRIBDEBITO DEB                             JOIN TRIBDEBITOPARCELARECEITA DPR ON                        ( DPR.ENTIDADE = DEB.ENTIDADE                            AND DPR.EXERCICIO = DEB.EXERCICIO                            AND DPR.TIPOCADASTRO = DEB.TIPOCADASTRO                            AND DPR.CADASTROGERAL = DEB.CADASTROGERAL                            AND DPR.GUIARECOLHIMENTO = DEB.GUIARECOLHIMENTO                            AND DPR.SUBDIVIDA = DEB.SUBDIVIDA )                             JOIN TRIBDEBITOPARCELARECREAJUSTE DRR ON                        ( DRR.IDDEBITOPARCELARECEITA = DPR.IDDEBITOPARCELARECEITA )                             JOIN TRIBREAJUSTE REA ON                        ( REA.ID = DRR.IDREAJUSTE )                    WHERE DEB.IDDEBITO = TD.IDDEBITO                      AND DPR.PARCELA = TDP.PARCELA                      AND REA.ENTIDADE = %d                      AND REA.ANO = %d                      AND REA.MES = %d                      AND REA.TIPO = %d                      AND REA.ESTORNADO = 'N')", params.getEntidade(), params.getExercicio(), params.getMes(), params.getTipo().getValue());
    }

    private String buildFiltroIdParcelamento(List<Long> idsParcelamento, List<Long> idsParamParcelamento) {
        StringBuilder filtros = new StringBuilder();
        if (!idsParcelamento.isEmpty()) {
            filtros.append(" and TPD.IDPARCELAMENTO in (");
            filtros.append(idsParcelamento.stream().map(Object::toString).collect(Collectors.joining(", ")));
            filtros.append(") ");
        }
        if (!idsParamParcelamento.isEmpty()) {
            filtros.append(" and TP.IDPARAMETROPARCELAMENTO in (");
            filtros.append(idsParamParcelamento.stream().map(Object::toString).collect(Collectors.joining(", ")));
            filtros.append(") ");
        }
        return filtros.toString();
    }

    public boolean existsByFiltro(AtualizacaoMonetariaParcelamentoParams params) {
        String existsQuery = String.format("SELECT EXISTS(%s) as ex ", this.buildSql(params, Boolean.valueOf(true)));
        return (Boolean)this.jdbcTemplate.queryForObject(existsQuery, (SqlParameterSource)new MapSqlParameterSource(), (rs, rowNum) -> rs.getBoolean("ex"));
    }

    public Page<AtualizacaoMonetariaItemDTO> searchItens(Long id, FiltroItensAtualizacaoMonetariaDTO params, Boolean agrupadoPorDebito, Pageable pageable) {
        String filtros = params.buildFilter();
        String agrupamentoTributo = agrupadoPorDebito != false ? "" : ",tdpr.receita";
        String sqlBase = FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/atualizacao-monetaria-parcelamentos/search-itens-atualizacao-monetaria.sql").replaceAll("\\$AGRUPAMENTO_TRIBUTO", agrupamentoTributo).replace("$FILTRO_RSQL", (CharSequence)(filtros.isBlank() ? "" : " and " + filtros));
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("id", (Object)id);
        String sqlContagem = String.format("select count(*) as total from (%s) count_query", sqlBase);
        Long numeroTotal = (Long)this.jdbcTemplate.queryForObject(sqlContagem, (SqlParameterSource)parameters, (rs, rowNum) -> rs.getLong("total"));
        List pagedRows = this.jdbcTemplate.query(sqlBase, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(AtualizacaoMonetariaItemDTO.class)).stream().sorted(SqlUtils.toComparator((Sort)pageable.getSort())).skip(pageable.getOffset()).limit(pageable.getPageSize()).collect(Collectors.toList());
        return new PageImpl(pagedRows, pageable, Optional.ofNullable(numeroTotal).orElse(0L).longValue());
    }

    public TotalizadorAtualizacaoMonetariaDTO getTotalizador(Long id, FiltroItensAtualizacaoMonetariaDTO filtro) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("id", (Object)id);
        String filtrosTela = filtro.buildFilter();
        String sql = FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/atualizacao-monetaria-parcelamentos/totalizadores-atualizacao-monetaria.sql").replace(":filtrosTela", filtrosTela.isBlank() ? "" : String.format(" and %s", filtrosTela));
        return (TotalizadorAtualizacaoMonetariaDTO)this.jdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(TotalizadorAtualizacaoMonetariaDTO.class));
    }

    @Generated
    public AtualizacaoMonetariaParcelamentoRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

