/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.MovimentacaoTributoDTO;
import br.com.elotech.tributos.dto.ResumoMovimentacaoTributoDTO;
import br.com.elotech.tributos.dto.TotalResumoMovimentacaoTributoDTO;
import br.com.elotech.tributos.params.MovimentacaoTributoParams;
import br.com.elotech.tributos.util.AmbienteUtils;
import br.com.elotech.tributos.util.SqlUtils;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class MovimentacaoTributoCustomRepository {
    private static final String CAMPOS = " classtipo.classificacaoreceitatipo || '-' || classtipo.descricao as classificacaotributo, \n md.motivodesconto || '-' || md.descricao as justificativa, \n cgt.numeroato || '/' || cgt.anoato || '-' || cgt.descricao as fundamentacao, \n tipoded.tipotce || '-' || tipoded.descricao as tpdeducao, \n";
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final ConfigurableEnvironment configurableEnvironment;

    public Page<MovimentacaoTributoDTO> findMovimentacoes(MovimentacaoTributoParams params, Pageable pageable, String pathSql) {
        MapSqlParameterSource parameters = this.getMapSqlParameterSource(params);
        String sql = String.format(FileUtils.readResourceAsString((String)pathSql), params.montaFiltro());
        Long numeroTotal = this.getTotal(sql, parameters);
        String sqlComPaginacao = this.getSqlComPaginacao(pageable, sql);
        List pagedRows = this.jdbcTemplate.query(sqlComPaginacao, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(MovimentacaoTributoDTO.class));
        return new PageImpl(pagedRows, pageable, Optional.ofNullable(numeroTotal).orElse(0L).longValue());
    }

    public Page<ResumoMovimentacaoTributoDTO> getResumos(MovimentacaoTributoParams params, Pageable pageable, String pathSql) {
        MapSqlParameterSource parameters = this.getMapSqlParameterSource(params);
        String groupBy = " group by \n classtipo.classificacaoreceitatipo || '-' || classtipo.descricao, \n md.motivodesconto || '-' || md.descricao, \n cgt.numeroato || '/' || cgt.anoato || '-' || cgt.descricao, \n tipoded.tipotce || '-' || tipoded.descricao";
        if (AmbienteUtils.getAmbiente((ConfigurableEnvironment)this.configurableEnvironment).equals("test")) {
            groupBy = " group by 1, 2, 3, 4";
        }
        String sql = String.format(FileUtils.readResourceAsString((String)pathSql), CAMPOS, params.montaFiltro().concat(groupBy));
        Long numeroTotal = this.getTotal(sql, parameters);
        String sqlComPaginacao = this.getSqlComPaginacao(pageable, sql);
        List pagedRows = this.jdbcTemplate.query(sqlComPaginacao, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ResumoMovimentacaoTributoDTO.class));
        return new PageImpl(pagedRows, pageable, Optional.ofNullable(numeroTotal).orElse(0L).longValue());
    }

    public TotalResumoMovimentacaoTributoDTO getTotalResumo(MovimentacaoTributoParams params, String pathSql) {
        MapSqlParameterSource parameters = this.getMapSqlParameterSource(params);
        String sql = String.format(FileUtils.readResourceAsString((String)pathSql), "", params.montaFiltro());
        BigDecimal total = (BigDecimal)this.jdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (rs, rowNum) -> rs.getBigDecimal("valortotal"));
        return new TotalResumoMovimentacaoTributoDTO(Optional.ofNullable(total).orElse(BigDecimal.ZERO));
    }

    private String getSqlComPaginacao(Pageable pageable, String sql) {
        String finalSort = SqlUtils.getFinalSort((Pageable)pageable);
        return SqlUtils.withPagination((String)sql.concat(finalSort), (Pageable)pageable, (DataSource)this.jdbcTemplate.getJdbcTemplate().getDataSource());
    }

    private Long getTotal(String sql, MapSqlParameterSource parameters) {
        String sqlContagem = String.format("select count(*) as total from (%s) count_query", sql);
        return (Long)this.jdbcTemplate.queryForObject(sqlContagem, (SqlParameterSource)parameters, (rs, rowNum) -> rs.getLong("total"));
    }

    private MapSqlParameterSource getMapSqlParameterSource(MovimentacaoTributoParams params) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("tipoMovimento", (Object)params.getTipoMovimentacaoTributo().getCodigo());
        parameters.addValue("dataInicial", (Object)Date.from(params.getDataInicial().atStartOfDay(ZoneId.systemDefault()).toInstant()));
        parameters.addValue("dataFinal", (Object)Date.from(params.getDataFinal().atStartOfDay(ZoneId.systemDefault()).toInstant()));
        return parameters;
    }

    @Generated
    public MovimentacaoTributoCustomRepository(NamedParameterJdbcTemplate jdbcTemplate, ConfigurableEnvironment configurableEnvironment) {
        this.jdbcTemplate = jdbcTemplate;
        this.configurableEnvironment = configurableEnvironment;
    }
}

