/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.report.loader;

import br.com.elotech.fluent.dataset.ReportDatasets;
import br.com.elotech.fluent.param.Param;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.repository.EntidadeRepository;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class RastreamentoCadastralParamLoader
implements ParamLoader {
    public static final String PARAM_NOME_ENTIDADE = "PNomeEntidade";
    public static final String PARAM_CNPJ = "PCNPJ";
    public static final String PARAM_ENDERECO = "PEndereco";
    public static final String PARAM_BRASAO = "PBrasao";
    private final EntidadeRepository entidadeRepository;

    public RastreamentoCadastralParamLoader(EntidadeRepository entidadeRepository) {
        this.entidadeRepository = entidadeRepository;
    }

    public Set<Param> load(ReportDatasets datasets) {
        HashSet params = Sets.newHashSet();
        Entidade entidadePrincipal = this.entidadeRepository.findByEntidadeprincipal();
        String enderecoEntidadePrincipal = this.entidadeRepository.findEnderecoEntidadePrincipal();
        params.add(Param.of((String)PARAM_NOME_ENTIDADE, (Object)entidadePrincipal.getNome()));
        params.add(Param.of((String)PARAM_ENDERECO, (Object)enderecoEntidadePrincipal));
        params.add(Param.of((String)PARAM_CNPJ, (Object)entidadePrincipal.getCnpj()));
        if (Objects.nonNull(entidadePrincipal.getBrasao()) && entidadePrincipal.getBrasao().length > 0) {
            params.add(Param.of((String)PARAM_BRASAO, (Object)new ByteArrayInputStream(entidadePrincipal.getBrasao())));
        }
        return params;
    }
}

