/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.rocada;

import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.Distrito;
import br.com.elotech.tributos.domain.Setor;
import br.com.elotech.tributos.domain.SetorQuadra;
import br.com.elotech.tributos.domain.rocada.RocadaCadastro;
import br.com.elotech.tributos.domain.rocada.RocadaCadastroId;
import br.com.elotech.tributos.domain.rocada.TipoRocada;
import br.com.elotech.tributos.dto.CadastroGeralResponseDTO;
import br.com.elotech.tributos.dto.rocada.RocadaCadastroTipoDTO;
import br.com.elotech.tributos.dto.rocada.TipoRocadaDTO;
import br.com.elotech.tributos.enums.rocada.TipoTerrenoRocada;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class RocadaCadastroDTO {
    private Long rocada;
    private Long entidade;
    private Long exercicio;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private BigDecimal areaLote;
    private BigDecimal areaRocada;
    private LocalDate dataRocada;
    private TipoTerrenoRocada tipoTerreno;
    private Long tipoDocumento;
    private Long documento;
    private BigDecimal areaPasseio;
    private BigDecimal quantidadeTipoRocada;
    private CadastroGeralResponseDTO cadastro;
    private Distrito distrito;
    private Setor zona;
    private SetorQuadra quadra;
    private String lote;
    private TipoRocadaDTO tipoRocada;
    private BigDecimal valorTotal;
    @Nullable
    private Map<String, Object> debito;
    @Nullable
    private Map<String, Object> boleto;

    public static RocadaCadastroDTO from(RocadaCadastro rocadaCadastro) {
        RocadaCadastroDTO dto = new RocadaCadastroDTO();
        if (rocadaCadastro.getId() != null) {
            Optional.ofNullable(rocadaCadastro.getId().getRocada()).ifPresent(arg_0 -> dto.setRocada(arg_0));
            Optional.ofNullable(rocadaCadastro.getId().getEntidade()).ifPresent(arg_0 -> dto.setEntidade(arg_0));
            Optional.ofNullable(rocadaCadastro.getId().getExercicio()).ifPresent(arg_0 -> dto.setExercicio(arg_0));
            Optional.ofNullable(rocadaCadastro.getId().getTipoCadastro()).ifPresent(arg_0 -> dto.setTipoCadastro(arg_0));
            Optional.ofNullable(rocadaCadastro.getId().getCadastroGeral()).ifPresent(arg_0 -> dto.setCadastroGeral(arg_0));
        }
        dto.setAreaLote(rocadaCadastro.getAreaLote());
        dto.setAreaRocada(rocadaCadastro.getAreaRocada());
        dto.setDataRocada(rocadaCadastro.getDataRocada());
        dto.setTipoTerreno(rocadaCadastro.getTipoTerreno());
        dto.setTipoDocumento(rocadaCadastro.getTipoDocumento());
        dto.setDocumento(rocadaCadastro.getDocumento());
        dto.setAreaPasseio(rocadaCadastro.getAreaPasseio());
        dto.setDebito(RocadaCadastroDTO.createDebito((Debito)rocadaCadastro.getDebito()));
        dto.setBoleto(RocadaCadastroDTO.createBoleto((Bloqueto)rocadaCadastro.getBoleto()));
        Optional.ofNullable(rocadaCadastro.getDebito()).ifPresent(debito -> dto.setValorTotal(debito.getValorTotalDebito()));
        if (rocadaCadastro.getTipo() != null) {
            dto.setQuantidadeTipoRocada(rocadaCadastro.getTipo().getQuantidade());
            Optional.ofNullable(rocadaCadastro.getTipo().getTipoRocada()).ifPresent(tipoRocada -> dto.setTipoRocada(TipoRocadaDTO.from((TipoRocada)tipoRocada)));
        }
        dto.setCadastro(CadastroGeralResponseDTO.from((CadastroGeral)rocadaCadastro.getCadastro()));
        return dto;
    }

    public RocadaCadastro toEntity() {
        RocadaCadastroId rocadaCadastroId = new RocadaCadastroId();
        rocadaCadastroId.setRocada(this.rocada);
        rocadaCadastroId.setEntidade(this.entidade);
        rocadaCadastroId.setExercicio(this.exercicio);
        rocadaCadastroId.setTipoCadastro(this.tipoCadastro);
        rocadaCadastroId.setCadastroGeral(this.cadastroGeral);
        RocadaCadastro entity = new RocadaCadastro();
        entity.setId(rocadaCadastroId);
        entity.setAreaLote(this.areaLote);
        entity.setAreaRocada(this.areaRocada);
        entity.setDataRocada(this.dataRocada);
        entity.setTipoTerreno(this.tipoTerreno);
        entity.setTipoDocumento(this.tipoDocumento);
        entity.setDocumento(this.documento);
        entity.setAreaPasseio(this.areaPasseio);
        entity.setTipo(new RocadaCadastroTipoDTO(this.rocada, this.entidade, this.exercicio, this.tipoCadastro, this.cadastroGeral, Objects.nonNull(this.tipoRocada) ? this.tipoRocada.getId() : null, this.quantidadeTipoRocada).toEntity());
        return entity;
    }

    private static Map<String, Object> createDebito(Debito entity) {
        if (entity == null) {
            return null;
        }
        return Map.of("id", entity.getId(), "exercicio", entity.getExercicio(), "guiaRecolhimento", entity.getGuiaRecolhimento(), "subDivida", entity.getSubDivida());
    }

    private static Map<String, Object> createBoleto(Bloqueto entity) {
        if (entity == null) {
            return null;
        }
        return Map.of("id", entity.getId(), "bloqueto", entity.getBloqueto(), "exercicio", entity.getExercicioBloqueto());
    }

    @Generated
    public RocadaCadastroDTO() {
    }

    @Generated
    public Long getRocada() {
        return this.rocada;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public BigDecimal getAreaLote() {
        return this.areaLote;
    }

    @Generated
    public BigDecimal getAreaRocada() {
        return this.areaRocada;
    }

    @Generated
    public LocalDate getDataRocada() {
        return this.dataRocada;
    }

    @Generated
    public TipoTerrenoRocada getTipoTerreno() {
        return this.tipoTerreno;
    }

    @Generated
    public Long getTipoDocumento() {
        return this.tipoDocumento;
    }

    @Generated
    public Long getDocumento() {
        return this.documento;
    }

    @Generated
    public BigDecimal getAreaPasseio() {
        return this.areaPasseio;
    }

    @Generated
    public BigDecimal getQuantidadeTipoRocada() {
        return this.quantidadeTipoRocada;
    }

    @Generated
    public CadastroGeralResponseDTO getCadastro() {
        return this.cadastro;
    }

    @Generated
    public Distrito getDistrito() {
        return this.distrito;
    }

    @Generated
    public Setor getZona() {
        return this.zona;
    }

    @Generated
    public SetorQuadra getQuadra() {
        return this.quadra;
    }

    @Generated
    public String getLote() {
        return this.lote;
    }

    @Generated
    public TipoRocadaDTO getTipoRocada() {
        return this.tipoRocada;
    }

    @Generated
    public BigDecimal getValorTotal() {
        return this.valorTotal;
    }

    @Nullable
    @Generated
    public Map<String, Object> getDebito() {
        return this.debito;
    }

    @Nullable
    @Generated
    public Map<String, Object> getBoleto() {
        return this.boleto;
    }

    @Generated
    public void setRocada(Long rocada) {
        this.rocada = rocada;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setAreaLote(BigDecimal areaLote) {
        this.areaLote = areaLote;
    }

    @Generated
    public void setAreaRocada(BigDecimal areaRocada) {
        this.areaRocada = areaRocada;
    }

    @Generated
    public void setDataRocada(LocalDate dataRocada) {
        this.dataRocada = dataRocada;
    }

    @Generated
    public void setTipoTerreno(TipoTerrenoRocada tipoTerreno) {
        this.tipoTerreno = tipoTerreno;
    }

    @Generated
    public void setTipoDocumento(Long tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
    }

    @Generated
    public void setDocumento(Long documento) {
        this.documento = documento;
    }

    @Generated
    public void setAreaPasseio(BigDecimal areaPasseio) {
        this.areaPasseio = areaPasseio;
    }

    @Generated
    public void setQuantidadeTipoRocada(BigDecimal quantidadeTipoRocada) {
        this.quantidadeTipoRocada = quantidadeTipoRocada;
    }

    @Generated
    public void setCadastro(CadastroGeralResponseDTO cadastro) {
        this.cadastro = cadastro;
    }

    @Generated
    public void setDistrito(Distrito distrito) {
        this.distrito = distrito;
    }

    @Generated
    public void setZona(Setor zona) {
        this.zona = zona;
    }

    @Generated
    public void setQuadra(SetorQuadra quadra) {
        this.quadra = quadra;
    }

    @Generated
    public void setLote(String lote) {
        this.lote = lote;
    }

    @Generated
    public void setTipoRocada(TipoRocadaDTO tipoRocada) {
        this.tipoRocada = tipoRocada;
    }

    @Generated
    public void setValorTotal(BigDecimal valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Generated
    public void setDebito(@Nullable Map<String, Object> debito) {
        this.debito = debito;
    }

    @Generated
    public void setBoleto(@Nullable Map<String, Object> boleto) {
        this.boleto = boleto;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RocadaCadastroDTO)) {
            return false;
        }
        RocadaCadastroDTO other = (RocadaCadastroDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$rocada = this.getRocada();
        Long other$rocada = other.getRocada();
        if (this$rocada == null ? other$rocada != null : !((Object)this$rocada).equals(other$rocada)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$tipoDocumento = this.getTipoDocumento();
        Long other$tipoDocumento = other.getTipoDocumento();
        if (this$tipoDocumento == null ? other$tipoDocumento != null : !((Object)this$tipoDocumento).equals(other$tipoDocumento)) {
            return false;
        }
        Long this$documento = this.getDocumento();
        Long other$documento = other.getDocumento();
        if (this$documento == null ? other$documento != null : !((Object)this$documento).equals(other$documento)) {
            return false;
        }
        BigDecimal this$areaLote = this.getAreaLote();
        BigDecimal other$areaLote = other.getAreaLote();
        if (this$areaLote == null ? other$areaLote != null : !((Object)this$areaLote).equals(other$areaLote)) {
            return false;
        }
        BigDecimal this$areaRocada = this.getAreaRocada();
        BigDecimal other$areaRocada = other.getAreaRocada();
        if (this$areaRocada == null ? other$areaRocada != null : !((Object)this$areaRocada).equals(other$areaRocada)) {
            return false;
        }
        LocalDate this$dataRocada = this.getDataRocada();
        LocalDate other$dataRocada = other.getDataRocada();
        if (this$dataRocada == null ? other$dataRocada != null : !((Object)this$dataRocada).equals(other$dataRocada)) {
            return false;
        }
        TipoTerrenoRocada this$tipoTerreno = this.getTipoTerreno();
        TipoTerrenoRocada other$tipoTerreno = other.getTipoTerreno();
        if (this$tipoTerreno == null ? other$tipoTerreno != null : !this$tipoTerreno.equals(other$tipoTerreno)) {
            return false;
        }
        BigDecimal this$areaPasseio = this.getAreaPasseio();
        BigDecimal other$areaPasseio = other.getAreaPasseio();
        if (this$areaPasseio == null ? other$areaPasseio != null : !((Object)this$areaPasseio).equals(other$areaPasseio)) {
            return false;
        }
        BigDecimal this$quantidadeTipoRocada = this.getQuantidadeTipoRocada();
        BigDecimal other$quantidadeTipoRocada = other.getQuantidadeTipoRocada();
        if (this$quantidadeTipoRocada == null ? other$quantidadeTipoRocada != null : !((Object)this$quantidadeTipoRocada).equals(other$quantidadeTipoRocada)) {
            return false;
        }
        CadastroGeralResponseDTO this$cadastro = this.getCadastro();
        CadastroGeralResponseDTO other$cadastro = other.getCadastro();
        if (this$cadastro == null ? other$cadastro != null : !this$cadastro.equals(other$cadastro)) {
            return false;
        }
        Distrito this$distrito = this.getDistrito();
        Distrito other$distrito = other.getDistrito();
        if (this$distrito == null ? other$distrito != null : !this$distrito.equals(other$distrito)) {
            return false;
        }
        Setor this$zona = this.getZona();
        Setor other$zona = other.getZona();
        if (this$zona == null ? other$zona != null : !this$zona.equals(other$zona)) {
            return false;
        }
        SetorQuadra this$quadra = this.getQuadra();
        SetorQuadra other$quadra = other.getQuadra();
        if (this$quadra == null ? other$quadra != null : !this$quadra.equals(other$quadra)) {
            return false;
        }
        String this$lote = this.getLote();
        String other$lote = other.getLote();
        if (this$lote == null ? other$lote != null : !this$lote.equals(other$lote)) {
            return false;
        }
        TipoRocadaDTO this$tipoRocada = this.getTipoRocada();
        TipoRocadaDTO other$tipoRocada = other.getTipoRocada();
        if (this$tipoRocada == null ? other$tipoRocada != null : !this$tipoRocada.equals(other$tipoRocada)) {
            return false;
        }
        BigDecimal this$valorTotal = this.getValorTotal();
        BigDecimal other$valorTotal = other.getValorTotal();
        if (this$valorTotal == null ? other$valorTotal != null : !((Object)this$valorTotal).equals(other$valorTotal)) {
            return false;
        }
        Map this$debito = this.getDebito();
        Map other$debito = other.getDebito();
        if (this$debito == null ? other$debito != null : !((Object)this$debito).equals(other$debito)) {
            return false;
        }
        Map this$boleto = this.getBoleto();
        Map other$boleto = other.getBoleto();
        return !(this$boleto == null ? other$boleto != null : !((Object)this$boleto).equals(other$boleto));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RocadaCadastroDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $rocada = this.getRocada();
        result = result * 59 + ($rocada == null ? 43 : ((Object)$rocada).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $tipoDocumento = this.getTipoDocumento();
        result = result * 59 + ($tipoDocumento == null ? 43 : ((Object)$tipoDocumento).hashCode());
        Long $documento = this.getDocumento();
        result = result * 59 + ($documento == null ? 43 : ((Object)$documento).hashCode());
        BigDecimal $areaLote = this.getAreaLote();
        result = result * 59 + ($areaLote == null ? 43 : ((Object)$areaLote).hashCode());
        BigDecimal $areaRocada = this.getAreaRocada();
        result = result * 59 + ($areaRocada == null ? 43 : ((Object)$areaRocada).hashCode());
        LocalDate $dataRocada = this.getDataRocada();
        result = result * 59 + ($dataRocada == null ? 43 : ((Object)$dataRocada).hashCode());
        TipoTerrenoRocada $tipoTerreno = this.getTipoTerreno();
        result = result * 59 + ($tipoTerreno == null ? 43 : $tipoTerreno.hashCode());
        BigDecimal $areaPasseio = this.getAreaPasseio();
        result = result * 59 + ($areaPasseio == null ? 43 : ((Object)$areaPasseio).hashCode());
        BigDecimal $quantidadeTipoRocada = this.getQuantidadeTipoRocada();
        result = result * 59 + ($quantidadeTipoRocada == null ? 43 : ((Object)$quantidadeTipoRocada).hashCode());
        CadastroGeralResponseDTO $cadastro = this.getCadastro();
        result = result * 59 + ($cadastro == null ? 43 : $cadastro.hashCode());
        Distrito $distrito = this.getDistrito();
        result = result * 59 + ($distrito == null ? 43 : $distrito.hashCode());
        Setor $zona = this.getZona();
        result = result * 59 + ($zona == null ? 43 : $zona.hashCode());
        SetorQuadra $quadra = this.getQuadra();
        result = result * 59 + ($quadra == null ? 43 : $quadra.hashCode());
        String $lote = this.getLote();
        result = result * 59 + ($lote == null ? 43 : $lote.hashCode());
        TipoRocadaDTO $tipoRocada = this.getTipoRocada();
        result = result * 59 + ($tipoRocada == null ? 43 : $tipoRocada.hashCode());
        BigDecimal $valorTotal = this.getValorTotal();
        result = result * 59 + ($valorTotal == null ? 43 : ((Object)$valorTotal).hashCode());
        Map $debito = this.getDebito();
        result = result * 59 + ($debito == null ? 43 : ((Object)$debito).hashCode());
        Map $boleto = this.getBoleto();
        result = result * 59 + ($boleto == null ? 43 : ((Object)$boleto).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RocadaCadastroDTO(rocada=" + this.getRocada() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", areaLote=" + this.getAreaLote() + ", areaRocada=" + this.getAreaRocada() + ", dataRocada=" + this.getDataRocada() + ", tipoTerreno=" + this.getTipoTerreno() + ", tipoDocumento=" + this.getTipoDocumento() + ", documento=" + this.getDocumento() + ", areaPasseio=" + this.getAreaPasseio() + ", quantidadeTipoRocada=" + this.getQuantidadeTipoRocada() + ", cadastro=" + this.getCadastro() + ", distrito=" + this.getDistrito() + ", zona=" + this.getZona() + ", quadra=" + this.getQuadra() + ", lote=" + this.getLote() + ", tipoRocada=" + this.getTipoRocada() + ", valorTotal=" + this.getValorTotal() + ", debito=" + this.getDebito() + ", boleto=" + this.getBoleto() + ")";
    }
}

