/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoboleto.sicoob.boletoregistrado;

import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoCarteira;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoEspecieTitulo;
import br.com.elotech.tributos.domain.cnab240.CNAB240EmissaoBloqueto;
import br.com.elotech.tributos.domain.cnab240.CNAB240EntregaBloqueto;
import br.com.elotech.tributos.domain.cnab240.ParametroCNAB240;
import br.com.elotech.tributos.dto.integracaoboleto.sicoob.boletoregistrado.PagadorBoletoRegistradoSicoobDTO;
import br.com.elotech.tributos.enums.cnab240.EspecieDocumento;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BoletoRegistradoSicoobDTO {
    private static final Long COM_PIX = 1L;
    private static final Long SEM_PIX = 2L;
    private static final Long SEM_DESCONTO = 0L;
    private static final Long ISENTO_MULTA = 0L;
    private static final Long ISENTO_JUROS = 3L;
    private static final Long NAO_PROTESTAR = 3L;
    private static final Long NAO_NEGATIVAR = 3L;
    private static final String FORMATO_DATAHORA_V2 = "yyyy-MM-dd'T'HH:mm:ssXXX";
    private static final String FORMATO_DATAHORA_V3 = "yyyy-MM-dd";
    private static final String API_V2 = "v2";
    private static final String API_V3 = "v3";
    private static final String ZONE_ID = "America/Sao_Paulo";
    private Long numeroContrato;
    private Long numeroCliente;
    private Long modalidade;
    private Long codigoModalidade;
    private Long numeroContaCorrente;
    private String especieDocumento;
    private String codigoEspecieDocumento;
    private String dataEmissao;
    private Long nossoNumero;
    private String seuNumero;
    private String identificacaoBoletoEmpresa;
    private Long identificacaoEmissaoBoleto;
    private Long identificacaoDistribuicaoBoleto;
    private BigDecimal valor = BigDecimal.ZERO;
    private String dataVencimento;
    private String dataLimitePagamento;
    private Long tipoDesconto;
    private String dataPrimeiroDesconto;
    private BigDecimal valorPrimeiroDesconto = BigDecimal.ZERO;
    private String dataSegundoDesconto;
    private BigDecimal valorSegundoDesconto = BigDecimal.ZERO;
    private String dataTerceiroDesconto;
    private BigDecimal valorTerceiroDesconto = BigDecimal.ZERO;
    private Long tipoMulta;
    private String dataMulta;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private Long tipoJurosMora;
    private String dataJurosMora;
    private BigDecimal valorJurosMora = BigDecimal.ZERO;
    private Long numeroParcela;
    private Long codigoNegativacao;
    private Long numeroDiasNegativacao;
    private Long codigoProtesto;
    private Long numeroDiasProtesto;
    private PagadorBoletoRegistradoSicoobDTO pagador;
    private Boolean gerarPdf;
    private Long codigoCadastrarPIX;
    private String qrCode;
    private String linhaDigitavel;
    private String codigoBarras;

    public static BoletoRegistradoSicoobDTO from(Bloqueto boleto, ParametroCNAB240 parametroCNAB240, boolean isApiV2) {
        BoletoRegistradoSicoobDTO dto = new BoletoRegistradoSicoobDTO();
        BoletoRegistradoSicoobDTO.setCamposVersaoApi((BoletoRegistradoSicoobDTO)dto, (Bloqueto)boleto, (ParametroCNAB240)parametroCNAB240, (boolean)isApiV2);
        dto.setNumeroContaCorrente(Long.valueOf(boleto.getModeloBloqueto().getConvenio().getContaBancaria().getConta().trim()));
        dto.setDataEmissao(BoletoRegistradoSicoobDTO.getDataHoraFormatado((LocalDate)LocalDate.now(), (boolean)isApiV2));
        dto.setNossoNumero(Long.valueOf(boleto.getNossoNumero().concat(boleto.getDvNossoNumero().trim())));
        dto.setSeuNumero(boleto.getNossoNumero());
        dto.setIdentificacaoBoletoEmpresa(boleto.getNossoNumero());
        Optional.ofNullable(parametroCNAB240.getCodigoEmissaoBloqueto()).map(CNAB240EmissaoBloqueto::getCodigo).ifPresent(arg_0 -> dto.setIdentificacaoEmissaoBoleto(arg_0));
        Optional.ofNullable(parametroCNAB240.getCodigoEntregaBloqueto()).map(CNAB240EntregaBloqueto::getCodigo).ifPresent(arg_0 -> dto.setIdentificacaoDistribuicaoBoleto(arg_0));
        dto.setValor(boleto.getValorBloqueto());
        dto.setDataVencimento(BoletoRegistradoSicoobDTO.getDataHoraFormatado((LocalDate)boleto.getDataVencimento(), (boolean)isApiV2));
        dto.setDataLimitePagamento(BoletoRegistradoSicoobDTO.getDataHoraFormatado((LocalDate)boleto.getDataLimitePagamento(), (boolean)isApiV2));
        dto.setNumeroParcela(Long.valueOf(1L));
        dto.setGerarPdf(Boolean.FALSE);
        dto.setCodigoCadastrarPIX(boleto.getModeloBloqueto().getConvenio().getUtilizaPix() != false ? COM_PIX : SEM_PIX);
        dto.setPagador(PagadorBoletoRegistradoSicoobDTO.from((Bloqueto)boleto));
        dto.setTipoDesconto(SEM_DESCONTO);
        if (Objects.nonNull(parametroCNAB240.getCodigoDesconto()) && !SEM_DESCONTO.equals(parametroCNAB240.getCodigoDesconto().getCodigo())) {
            dto.setTipoDesconto(parametroCNAB240.getCodigoDesconto().getCodigo());
            dto.setDataPrimeiroDesconto(BoletoRegistradoSicoobDTO.getDataHoraFormatado((LocalDate)boleto.getDataVencimento(), (boolean)isApiV2));
            dto.setValorPrimeiroDesconto(parametroCNAB240.getValorPercentualDesconto());
        }
        if (Objects.nonNull(parametroCNAB240.getCodigoDesconto2()) && !SEM_DESCONTO.equals(parametroCNAB240.getCodigoDesconto2().getCodigo())) {
            dto.setTipoDesconto(parametroCNAB240.getCodigoDesconto2().getCodigo());
            dto.setDataSegundoDesconto(BoletoRegistradoSicoobDTO.getDataHoraFormatado((LocalDate)boleto.getDataVencimento(), (boolean)isApiV2));
            dto.setValorSegundoDesconto(parametroCNAB240.getValorPercentualDesconto2());
        }
        if (Objects.nonNull(parametroCNAB240.getCodigoDesconto3()) && !SEM_DESCONTO.equals(parametroCNAB240.getCodigoDesconto3().getCodigo())) {
            dto.setTipoDesconto(parametroCNAB240.getCodigoDesconto3().getCodigo());
            dto.setDataTerceiroDesconto(BoletoRegistradoSicoobDTO.getDataHoraFormatado((LocalDate)boleto.getDataVencimento(), (boolean)isApiV2));
            dto.setValorTerceiroDesconto(parametroCNAB240.getValorPercentualDesconto3());
        }
        dto.setTipoMulta(ISENTO_MULTA);
        if (Objects.nonNull(parametroCNAB240.getCodigoMulta()) && !ISENTO_MULTA.equals(parametroCNAB240.getCodigoMulta().getId())) {
            dto.setTipoMulta(parametroCNAB240.getCodigoMulta().getId());
            dto.setValorMulta(parametroCNAB240.getValorPercentualMulta());
            dto.setDataMulta(BoletoRegistradoSicoobDTO.getDataHoraFormatado((LocalDate)boleto.getDataVencimento(), (boolean)isApiV2));
        }
        dto.setTipoJurosMora(ISENTO_JUROS);
        if (Objects.nonNull(parametroCNAB240.getCodigoJuros()) && !ISENTO_JUROS.equals(parametroCNAB240.getCodigoJuros().getId())) {
            dto.setTipoJurosMora(parametroCNAB240.getCodigoJuros().getId());
            dto.setValorJurosMora(parametroCNAB240.getValorJurosDiaTaxa());
            dto.setDataJurosMora(BoletoRegistradoSicoobDTO.getDataHoraFormatado((LocalDate)boleto.getDataVencimento(), (boolean)isApiV2));
        }
        dto.setCodigoProtesto(NAO_PROTESTAR);
        dto.setCodigoNegativacao(NAO_NEGATIVAR);
        if (Objects.nonNull(parametroCNAB240.getCodigoProtesto()) && !NAO_PROTESTAR.equals(parametroCNAB240.getCodigoProtesto().getCodigo())) {
            dto.setCodigoProtesto(parametroCNAB240.getCodigoProtesto().getCodigo());
            dto.setCodigoNegativacao(parametroCNAB240.getCodigoProtesto().getCodigo());
            dto.setNumeroDiasNegativacao(parametroCNAB240.getDiasProtesto());
            dto.setNumeroDiasProtesto(parametroCNAB240.getDiasProtesto());
        }
        return dto;
    }

    public static String getDataHoraFormatado(LocalDate dataHora, boolean isApiV2) {
        return dataHora.atStartOfDay().atZone(ZoneId.of("America/Sao_Paulo")).format(isApiV2 ? DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXX") : DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    public static void setCamposVersaoApi(BoletoRegistradoSicoobDTO dto, Bloqueto boleto, ParametroCNAB240 parametroCNAB240, boolean isApiV2) {
        BoletoRegistradoSicoobDTO.builderCedente((BoletoRegistradoSicoobDTO)dto, (Bloqueto)boleto, (boolean)isApiV2);
        BoletoRegistradoSicoobDTO.builderEspecieDocumento((BoletoRegistradoSicoobDTO)dto, (ParametroCNAB240)parametroCNAB240, (boolean)isApiV2);
        BoletoRegistradoSicoobDTO.builderCarteira((BoletoRegistradoSicoobDTO)dto, (ParametroCNAB240)parametroCNAB240, (boolean)isApiV2);
    }

    private static void builderCedente(BoletoRegistradoSicoobDTO dto, Bloqueto boleto, boolean isApiV2) {
        Long codigoCedente = Long.valueOf(boleto.getModeloBloqueto().getConvenio().getCodigoCedente().trim());
        if (isApiV2) {
            dto.setNumeroContrato(codigoCedente);
        } else {
            dto.setNumeroCliente(codigoCedente);
        }
    }

    private static void builderEspecieDocumento(BoletoRegistradoSicoobDTO dto, ParametroCNAB240 parametroCNAB240, boolean isApiV2) {
        Optional.ofNullable(parametroCNAB240.getIdEspecieTitulo()).map(CNAB240CodigoEspecieTitulo::getIdEspecie).map(EspecieDocumento::fromValues).map(EspecieDocumento::getCodigoCnab).ifPresent(codigo -> {
            if (isApiV2) {
                dto.setEspecieDocumento(codigo);
            } else {
                dto.setCodigoEspecieDocumento(codigo);
            }
        });
    }

    private static void builderCarteira(BoletoRegistradoSicoobDTO dto, ParametroCNAB240 parametroCNAB240, boolean isApiV2) {
        Optional.ofNullable(parametroCNAB240.getCodigoCarteira()).map(CNAB240CodigoCarteira::getCodigo).ifPresent(carteira -> {
            if (isApiV2) {
                dto.setModalidade(carteira);
            } else {
                dto.setCodigoModalidade(carteira);
            }
        });
    }

    @Generated
    public BoletoRegistradoSicoobDTO() {
    }

    @Generated
    public Long getNumeroContrato() {
        return this.numeroContrato;
    }

    @Generated
    public Long getNumeroCliente() {
        return this.numeroCliente;
    }

    @Generated
    public Long getModalidade() {
        return this.modalidade;
    }

    @Generated
    public Long getCodigoModalidade() {
        return this.codigoModalidade;
    }

    @Generated
    public Long getNumeroContaCorrente() {
        return this.numeroContaCorrente;
    }

    @Generated
    public String getEspecieDocumento() {
        return this.especieDocumento;
    }

    @Generated
    public String getCodigoEspecieDocumento() {
        return this.codigoEspecieDocumento;
    }

    @Generated
    public String getDataEmissao() {
        return this.dataEmissao;
    }

    @Generated
    public Long getNossoNumero() {
        return this.nossoNumero;
    }

    @Generated
    public String getSeuNumero() {
        return this.seuNumero;
    }

    @Generated
    public String getIdentificacaoBoletoEmpresa() {
        return this.identificacaoBoletoEmpresa;
    }

    @Generated
    public Long getIdentificacaoEmissaoBoleto() {
        return this.identificacaoEmissaoBoleto;
    }

    @Generated
    public Long getIdentificacaoDistribuicaoBoleto() {
        return this.identificacaoDistribuicaoBoleto;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public String getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public String getDataLimitePagamento() {
        return this.dataLimitePagamento;
    }

    @Generated
    public Long getTipoDesconto() {
        return this.tipoDesconto;
    }

    @Generated
    public String getDataPrimeiroDesconto() {
        return this.dataPrimeiroDesconto;
    }

    @Generated
    public BigDecimal getValorPrimeiroDesconto() {
        return this.valorPrimeiroDesconto;
    }

    @Generated
    public String getDataSegundoDesconto() {
        return this.dataSegundoDesconto;
    }

    @Generated
    public BigDecimal getValorSegundoDesconto() {
        return this.valorSegundoDesconto;
    }

    @Generated
    public String getDataTerceiroDesconto() {
        return this.dataTerceiroDesconto;
    }

    @Generated
    public BigDecimal getValorTerceiroDesconto() {
        return this.valorTerceiroDesconto;
    }

    @Generated
    public Long getTipoMulta() {
        return this.tipoMulta;
    }

    @Generated
    public String getDataMulta() {
        return this.dataMulta;
    }

    @Generated
    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public Long getTipoJurosMora() {
        return this.tipoJurosMora;
    }

    @Generated
    public String getDataJurosMora() {
        return this.dataJurosMora;
    }

    @Generated
    public BigDecimal getValorJurosMora() {
        return this.valorJurosMora;
    }

    @Generated
    public Long getNumeroParcela() {
        return this.numeroParcela;
    }

    @Generated
    public Long getCodigoNegativacao() {
        return this.codigoNegativacao;
    }

    @Generated
    public Long getNumeroDiasNegativacao() {
        return this.numeroDiasNegativacao;
    }

    @Generated
    public Long getCodigoProtesto() {
        return this.codigoProtesto;
    }

    @Generated
    public Long getNumeroDiasProtesto() {
        return this.numeroDiasProtesto;
    }

    @Generated
    public PagadorBoletoRegistradoSicoobDTO getPagador() {
        return this.pagador;
    }

    @Generated
    public Boolean getGerarPdf() {
        return this.gerarPdf;
    }

    @Generated
    public Long getCodigoCadastrarPIX() {
        return this.codigoCadastrarPIX;
    }

    @Generated
    public String getQrCode() {
        return this.qrCode;
    }

    @Generated
    public String getLinhaDigitavel() {
        return this.linhaDigitavel;
    }

    @Generated
    public String getCodigoBarras() {
        return this.codigoBarras;
    }

    @Generated
    public void setNumeroContrato(Long numeroContrato) {
        this.numeroContrato = numeroContrato;
    }

    @Generated
    public void setNumeroCliente(Long numeroCliente) {
        this.numeroCliente = numeroCliente;
    }

    @Generated
    public void setModalidade(Long modalidade) {
        this.modalidade = modalidade;
    }

    @Generated
    public void setCodigoModalidade(Long codigoModalidade) {
        this.codigoModalidade = codigoModalidade;
    }

    @Generated
    public void setNumeroContaCorrente(Long numeroContaCorrente) {
        this.numeroContaCorrente = numeroContaCorrente;
    }

    @Generated
    public void setEspecieDocumento(String especieDocumento) {
        this.especieDocumento = especieDocumento;
    }

    @Generated
    public void setCodigoEspecieDocumento(String codigoEspecieDocumento) {
        this.codigoEspecieDocumento = codigoEspecieDocumento;
    }

    @Generated
    public void setDataEmissao(String dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Generated
    public void setNossoNumero(Long nossoNumero) {
        this.nossoNumero = nossoNumero;
    }

    @Generated
    public void setSeuNumero(String seuNumero) {
        this.seuNumero = seuNumero;
    }

    @Generated
    public void setIdentificacaoBoletoEmpresa(String identificacaoBoletoEmpresa) {
        this.identificacaoBoletoEmpresa = identificacaoBoletoEmpresa;
    }

    @Generated
    public void setIdentificacaoEmissaoBoleto(Long identificacaoEmissaoBoleto) {
        this.identificacaoEmissaoBoleto = identificacaoEmissaoBoleto;
    }

    @Generated
    public void setIdentificacaoDistribuicaoBoleto(Long identificacaoDistribuicaoBoleto) {
        this.identificacaoDistribuicaoBoleto = identificacaoDistribuicaoBoleto;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setDataVencimento(String dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setDataLimitePagamento(String dataLimitePagamento) {
        this.dataLimitePagamento = dataLimitePagamento;
    }

    @Generated
    public void setTipoDesconto(Long tipoDesconto) {
        this.tipoDesconto = tipoDesconto;
    }

    @Generated
    public void setDataPrimeiroDesconto(String dataPrimeiroDesconto) {
        this.dataPrimeiroDesconto = dataPrimeiroDesconto;
    }

    @Generated
    public void setValorPrimeiroDesconto(BigDecimal valorPrimeiroDesconto) {
        this.valorPrimeiroDesconto = valorPrimeiroDesconto;
    }

    @Generated
    public void setDataSegundoDesconto(String dataSegundoDesconto) {
        this.dataSegundoDesconto = dataSegundoDesconto;
    }

    @Generated
    public void setValorSegundoDesconto(BigDecimal valorSegundoDesconto) {
        this.valorSegundoDesconto = valorSegundoDesconto;
    }

    @Generated
    public void setDataTerceiroDesconto(String dataTerceiroDesconto) {
        this.dataTerceiroDesconto = dataTerceiroDesconto;
    }

    @Generated
    public void setValorTerceiroDesconto(BigDecimal valorTerceiroDesconto) {
        this.valorTerceiroDesconto = valorTerceiroDesconto;
    }

    @Generated
    public void setTipoMulta(Long tipoMulta) {
        this.tipoMulta = tipoMulta;
    }

    @Generated
    public void setDataMulta(String dataMulta) {
        this.dataMulta = dataMulta;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public void setTipoJurosMora(Long tipoJurosMora) {
        this.tipoJurosMora = tipoJurosMora;
    }

    @Generated
    public void setDataJurosMora(String dataJurosMora) {
        this.dataJurosMora = dataJurosMora;
    }

    @Generated
    public void setValorJurosMora(BigDecimal valorJurosMora) {
        this.valorJurosMora = valorJurosMora;
    }

    @Generated
    public void setNumeroParcela(Long numeroParcela) {
        this.numeroParcela = numeroParcela;
    }

    @Generated
    public void setCodigoNegativacao(Long codigoNegativacao) {
        this.codigoNegativacao = codigoNegativacao;
    }

    @Generated
    public void setNumeroDiasNegativacao(Long numeroDiasNegativacao) {
        this.numeroDiasNegativacao = numeroDiasNegativacao;
    }

    @Generated
    public void setCodigoProtesto(Long codigoProtesto) {
        this.codigoProtesto = codigoProtesto;
    }

    @Generated
    public void setNumeroDiasProtesto(Long numeroDiasProtesto) {
        this.numeroDiasProtesto = numeroDiasProtesto;
    }

    @Generated
    public void setPagador(PagadorBoletoRegistradoSicoobDTO pagador) {
        this.pagador = pagador;
    }

    @Generated
    public void setGerarPdf(Boolean gerarPdf) {
        this.gerarPdf = gerarPdf;
    }

    @Generated
    public void setCodigoCadastrarPIX(Long codigoCadastrarPIX) {
        this.codigoCadastrarPIX = codigoCadastrarPIX;
    }

    @Generated
    public void setQrCode(String qrCode) {
        this.qrCode = qrCode;
    }

    @Generated
    public void setLinhaDigitavel(String linhaDigitavel) {
        this.linhaDigitavel = linhaDigitavel;
    }

    @Generated
    public void setCodigoBarras(String codigoBarras) {
        this.codigoBarras = codigoBarras;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoletoRegistradoSicoobDTO)) {
            return false;
        }
        BoletoRegistradoSicoobDTO other = (BoletoRegistradoSicoobDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$numeroContrato = this.getNumeroContrato();
        Long other$numeroContrato = other.getNumeroContrato();
        if (this$numeroContrato == null ? other$numeroContrato != null : !((Object)this$numeroContrato).equals(other$numeroContrato)) {
            return false;
        }
        Long this$numeroCliente = this.getNumeroCliente();
        Long other$numeroCliente = other.getNumeroCliente();
        if (this$numeroCliente == null ? other$numeroCliente != null : !((Object)this$numeroCliente).equals(other$numeroCliente)) {
            return false;
        }
        Long this$modalidade = this.getModalidade();
        Long other$modalidade = other.getModalidade();
        if (this$modalidade == null ? other$modalidade != null : !((Object)this$modalidade).equals(other$modalidade)) {
            return false;
        }
        Long this$codigoModalidade = this.getCodigoModalidade();
        Long other$codigoModalidade = other.getCodigoModalidade();
        if (this$codigoModalidade == null ? other$codigoModalidade != null : !((Object)this$codigoModalidade).equals(other$codigoModalidade)) {
            return false;
        }
        Long this$numeroContaCorrente = this.getNumeroContaCorrente();
        Long other$numeroContaCorrente = other.getNumeroContaCorrente();
        if (this$numeroContaCorrente == null ? other$numeroContaCorrente != null : !((Object)this$numeroContaCorrente).equals(other$numeroContaCorrente)) {
            return false;
        }
        Long this$nossoNumero = this.getNossoNumero();
        Long other$nossoNumero = other.getNossoNumero();
        if (this$nossoNumero == null ? other$nossoNumero != null : !((Object)this$nossoNumero).equals(other$nossoNumero)) {
            return false;
        }
        Long this$identificacaoEmissaoBoleto = this.getIdentificacaoEmissaoBoleto();
        Long other$identificacaoEmissaoBoleto = other.getIdentificacaoEmissaoBoleto();
        if (this$identificacaoEmissaoBoleto == null ? other$identificacaoEmissaoBoleto != null : !((Object)this$identificacaoEmissaoBoleto).equals(other$identificacaoEmissaoBoleto)) {
            return false;
        }
        Long this$identificacaoDistribuicaoBoleto = this.getIdentificacaoDistribuicaoBoleto();
        Long other$identificacaoDistribuicaoBoleto = other.getIdentificacaoDistribuicaoBoleto();
        if (this$identificacaoDistribuicaoBoleto == null ? other$identificacaoDistribuicaoBoleto != null : !((Object)this$identificacaoDistribuicaoBoleto).equals(other$identificacaoDistribuicaoBoleto)) {
            return false;
        }
        Long this$tipoDesconto = this.getTipoDesconto();
        Long other$tipoDesconto = other.getTipoDesconto();
        if (this$tipoDesconto == null ? other$tipoDesconto != null : !((Object)this$tipoDesconto).equals(other$tipoDesconto)) {
            return false;
        }
        Long this$tipoMulta = this.getTipoMulta();
        Long other$tipoMulta = other.getTipoMulta();
        if (this$tipoMulta == null ? other$tipoMulta != null : !((Object)this$tipoMulta).equals(other$tipoMulta)) {
            return false;
        }
        Long this$tipoJurosMora = this.getTipoJurosMora();
        Long other$tipoJurosMora = other.getTipoJurosMora();
        if (this$tipoJurosMora == null ? other$tipoJurosMora != null : !((Object)this$tipoJurosMora).equals(other$tipoJurosMora)) {
            return false;
        }
        Long this$numeroParcela = this.getNumeroParcela();
        Long other$numeroParcela = other.getNumeroParcela();
        if (this$numeroParcela == null ? other$numeroParcela != null : !((Object)this$numeroParcela).equals(other$numeroParcela)) {
            return false;
        }
        Long this$codigoNegativacao = this.getCodigoNegativacao();
        Long other$codigoNegativacao = other.getCodigoNegativacao();
        if (this$codigoNegativacao == null ? other$codigoNegativacao != null : !((Object)this$codigoNegativacao).equals(other$codigoNegativacao)) {
            return false;
        }
        Long this$numeroDiasNegativacao = this.getNumeroDiasNegativacao();
        Long other$numeroDiasNegativacao = other.getNumeroDiasNegativacao();
        if (this$numeroDiasNegativacao == null ? other$numeroDiasNegativacao != null : !((Object)this$numeroDiasNegativacao).equals(other$numeroDiasNegativacao)) {
            return false;
        }
        Long this$codigoProtesto = this.getCodigoProtesto();
        Long other$codigoProtesto = other.getCodigoProtesto();
        if (this$codigoProtesto == null ? other$codigoProtesto != null : !((Object)this$codigoProtesto).equals(other$codigoProtesto)) {
            return false;
        }
        Long this$numeroDiasProtesto = this.getNumeroDiasProtesto();
        Long other$numeroDiasProtesto = other.getNumeroDiasProtesto();
        if (this$numeroDiasProtesto == null ? other$numeroDiasProtesto != null : !((Object)this$numeroDiasProtesto).equals(other$numeroDiasProtesto)) {
            return false;
        }
        Boolean this$gerarPdf = this.getGerarPdf();
        Boolean other$gerarPdf = other.getGerarPdf();
        if (this$gerarPdf == null ? other$gerarPdf != null : !((Object)this$gerarPdf).equals(other$gerarPdf)) {
            return false;
        }
        Long this$codigoCadastrarPIX = this.getCodigoCadastrarPIX();
        Long other$codigoCadastrarPIX = other.getCodigoCadastrarPIX();
        if (this$codigoCadastrarPIX == null ? other$codigoCadastrarPIX != null : !((Object)this$codigoCadastrarPIX).equals(other$codigoCadastrarPIX)) {
            return false;
        }
        String this$especieDocumento = this.getEspecieDocumento();
        String other$especieDocumento = other.getEspecieDocumento();
        if (this$especieDocumento == null ? other$especieDocumento != null : !this$especieDocumento.equals(other$especieDocumento)) {
            return false;
        }
        String this$codigoEspecieDocumento = this.getCodigoEspecieDocumento();
        String other$codigoEspecieDocumento = other.getCodigoEspecieDocumento();
        if (this$codigoEspecieDocumento == null ? other$codigoEspecieDocumento != null : !this$codigoEspecieDocumento.equals(other$codigoEspecieDocumento)) {
            return false;
        }
        String this$dataEmissao = this.getDataEmissao();
        String other$dataEmissao = other.getDataEmissao();
        if (this$dataEmissao == null ? other$dataEmissao != null : !this$dataEmissao.equals(other$dataEmissao)) {
            return false;
        }
        String this$seuNumero = this.getSeuNumero();
        String other$seuNumero = other.getSeuNumero();
        if (this$seuNumero == null ? other$seuNumero != null : !this$seuNumero.equals(other$seuNumero)) {
            return false;
        }
        String this$identificacaoBoletoEmpresa = this.getIdentificacaoBoletoEmpresa();
        String other$identificacaoBoletoEmpresa = other.getIdentificacaoBoletoEmpresa();
        if (this$identificacaoBoletoEmpresa == null ? other$identificacaoBoletoEmpresa != null : !this$identificacaoBoletoEmpresa.equals(other$identificacaoBoletoEmpresa)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        String this$dataVencimento = this.getDataVencimento();
        String other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !this$dataVencimento.equals(other$dataVencimento)) {
            return false;
        }
        String this$dataLimitePagamento = this.getDataLimitePagamento();
        String other$dataLimitePagamento = other.getDataLimitePagamento();
        if (this$dataLimitePagamento == null ? other$dataLimitePagamento != null : !this$dataLimitePagamento.equals(other$dataLimitePagamento)) {
            return false;
        }
        String this$dataPrimeiroDesconto = this.getDataPrimeiroDesconto();
        String other$dataPrimeiroDesconto = other.getDataPrimeiroDesconto();
        if (this$dataPrimeiroDesconto == null ? other$dataPrimeiroDesconto != null : !this$dataPrimeiroDesconto.equals(other$dataPrimeiroDesconto)) {
            return false;
        }
        BigDecimal this$valorPrimeiroDesconto = this.getValorPrimeiroDesconto();
        BigDecimal other$valorPrimeiroDesconto = other.getValorPrimeiroDesconto();
        if (this$valorPrimeiroDesconto == null ? other$valorPrimeiroDesconto != null : !((Object)this$valorPrimeiroDesconto).equals(other$valorPrimeiroDesconto)) {
            return false;
        }
        String this$dataSegundoDesconto = this.getDataSegundoDesconto();
        String other$dataSegundoDesconto = other.getDataSegundoDesconto();
        if (this$dataSegundoDesconto == null ? other$dataSegundoDesconto != null : !this$dataSegundoDesconto.equals(other$dataSegundoDesconto)) {
            return false;
        }
        BigDecimal this$valorSegundoDesconto = this.getValorSegundoDesconto();
        BigDecimal other$valorSegundoDesconto = other.getValorSegundoDesconto();
        if (this$valorSegundoDesconto == null ? other$valorSegundoDesconto != null : !((Object)this$valorSegundoDesconto).equals(other$valorSegundoDesconto)) {
            return false;
        }
        String this$dataTerceiroDesconto = this.getDataTerceiroDesconto();
        String other$dataTerceiroDesconto = other.getDataTerceiroDesconto();
        if (this$dataTerceiroDesconto == null ? other$dataTerceiroDesconto != null : !this$dataTerceiroDesconto.equals(other$dataTerceiroDesconto)) {
            return false;
        }
        BigDecimal this$valorTerceiroDesconto = this.getValorTerceiroDesconto();
        BigDecimal other$valorTerceiroDesconto = other.getValorTerceiroDesconto();
        if (this$valorTerceiroDesconto == null ? other$valorTerceiroDesconto != null : !((Object)this$valorTerceiroDesconto).equals(other$valorTerceiroDesconto)) {
            return false;
        }
        String this$dataMulta = this.getDataMulta();
        String other$dataMulta = other.getDataMulta();
        if (this$dataMulta == null ? other$dataMulta != null : !this$dataMulta.equals(other$dataMulta)) {
            return false;
        }
        BigDecimal this$valorMulta = this.getValorMulta();
        BigDecimal other$valorMulta = other.getValorMulta();
        if (this$valorMulta == null ? other$valorMulta != null : !((Object)this$valorMulta).equals(other$valorMulta)) {
            return false;
        }
        String this$dataJurosMora = this.getDataJurosMora();
        String other$dataJurosMora = other.getDataJurosMora();
        if (this$dataJurosMora == null ? other$dataJurosMora != null : !this$dataJurosMora.equals(other$dataJurosMora)) {
            return false;
        }
        BigDecimal this$valorJurosMora = this.getValorJurosMora();
        BigDecimal other$valorJurosMora = other.getValorJurosMora();
        if (this$valorJurosMora == null ? other$valorJurosMora != null : !((Object)this$valorJurosMora).equals(other$valorJurosMora)) {
            return false;
        }
        PagadorBoletoRegistradoSicoobDTO this$pagador = this.getPagador();
        PagadorBoletoRegistradoSicoobDTO other$pagador = other.getPagador();
        if (this$pagador == null ? other$pagador != null : !this$pagador.equals(other$pagador)) {
            return false;
        }
        String this$qrCode = this.getQrCode();
        String other$qrCode = other.getQrCode();
        if (this$qrCode == null ? other$qrCode != null : !this$qrCode.equals(other$qrCode)) {
            return false;
        }
        String this$linhaDigitavel = this.getLinhaDigitavel();
        String other$linhaDigitavel = other.getLinhaDigitavel();
        if (this$linhaDigitavel == null ? other$linhaDigitavel != null : !this$linhaDigitavel.equals(other$linhaDigitavel)) {
            return false;
        }
        String this$codigoBarras = this.getCodigoBarras();
        String other$codigoBarras = other.getCodigoBarras();
        return !(this$codigoBarras == null ? other$codigoBarras != null : !this$codigoBarras.equals(other$codigoBarras));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BoletoRegistradoSicoobDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $numeroContrato = this.getNumeroContrato();
        result = result * 59 + ($numeroContrato == null ? 43 : ((Object)$numeroContrato).hashCode());
        Long $numeroCliente = this.getNumeroCliente();
        result = result * 59 + ($numeroCliente == null ? 43 : ((Object)$numeroCliente).hashCode());
        Long $modalidade = this.getModalidade();
        result = result * 59 + ($modalidade == null ? 43 : ((Object)$modalidade).hashCode());
        Long $codigoModalidade = this.getCodigoModalidade();
        result = result * 59 + ($codigoModalidade == null ? 43 : ((Object)$codigoModalidade).hashCode());
        Long $numeroContaCorrente = this.getNumeroContaCorrente();
        result = result * 59 + ($numeroContaCorrente == null ? 43 : ((Object)$numeroContaCorrente).hashCode());
        Long $nossoNumero = this.getNossoNumero();
        result = result * 59 + ($nossoNumero == null ? 43 : ((Object)$nossoNumero).hashCode());
        Long $identificacaoEmissaoBoleto = this.getIdentificacaoEmissaoBoleto();
        result = result * 59 + ($identificacaoEmissaoBoleto == null ? 43 : ((Object)$identificacaoEmissaoBoleto).hashCode());
        Long $identificacaoDistribuicaoBoleto = this.getIdentificacaoDistribuicaoBoleto();
        result = result * 59 + ($identificacaoDistribuicaoBoleto == null ? 43 : ((Object)$identificacaoDistribuicaoBoleto).hashCode());
        Long $tipoDesconto = this.getTipoDesconto();
        result = result * 59 + ($tipoDesconto == null ? 43 : ((Object)$tipoDesconto).hashCode());
        Long $tipoMulta = this.getTipoMulta();
        result = result * 59 + ($tipoMulta == null ? 43 : ((Object)$tipoMulta).hashCode());
        Long $tipoJurosMora = this.getTipoJurosMora();
        result = result * 59 + ($tipoJurosMora == null ? 43 : ((Object)$tipoJurosMora).hashCode());
        Long $numeroParcela = this.getNumeroParcela();
        result = result * 59 + ($numeroParcela == null ? 43 : ((Object)$numeroParcela).hashCode());
        Long $codigoNegativacao = this.getCodigoNegativacao();
        result = result * 59 + ($codigoNegativacao == null ? 43 : ((Object)$codigoNegativacao).hashCode());
        Long $numeroDiasNegativacao = this.getNumeroDiasNegativacao();
        result = result * 59 + ($numeroDiasNegativacao == null ? 43 : ((Object)$numeroDiasNegativacao).hashCode());
        Long $codigoProtesto = this.getCodigoProtesto();
        result = result * 59 + ($codigoProtesto == null ? 43 : ((Object)$codigoProtesto).hashCode());
        Long $numeroDiasProtesto = this.getNumeroDiasProtesto();
        result = result * 59 + ($numeroDiasProtesto == null ? 43 : ((Object)$numeroDiasProtesto).hashCode());
        Boolean $gerarPdf = this.getGerarPdf();
        result = result * 59 + ($gerarPdf == null ? 43 : ((Object)$gerarPdf).hashCode());
        Long $codigoCadastrarPIX = this.getCodigoCadastrarPIX();
        result = result * 59 + ($codigoCadastrarPIX == null ? 43 : ((Object)$codigoCadastrarPIX).hashCode());
        String $especieDocumento = this.getEspecieDocumento();
        result = result * 59 + ($especieDocumento == null ? 43 : $especieDocumento.hashCode());
        String $codigoEspecieDocumento = this.getCodigoEspecieDocumento();
        result = result * 59 + ($codigoEspecieDocumento == null ? 43 : $codigoEspecieDocumento.hashCode());
        String $dataEmissao = this.getDataEmissao();
        result = result * 59 + ($dataEmissao == null ? 43 : $dataEmissao.hashCode());
        String $seuNumero = this.getSeuNumero();
        result = result * 59 + ($seuNumero == null ? 43 : $seuNumero.hashCode());
        String $identificacaoBoletoEmpresa = this.getIdentificacaoBoletoEmpresa();
        result = result * 59 + ($identificacaoBoletoEmpresa == null ? 43 : $identificacaoBoletoEmpresa.hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        String $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : $dataVencimento.hashCode());
        String $dataLimitePagamento = this.getDataLimitePagamento();
        result = result * 59 + ($dataLimitePagamento == null ? 43 : $dataLimitePagamento.hashCode());
        String $dataPrimeiroDesconto = this.getDataPrimeiroDesconto();
        result = result * 59 + ($dataPrimeiroDesconto == null ? 43 : $dataPrimeiroDesconto.hashCode());
        BigDecimal $valorPrimeiroDesconto = this.getValorPrimeiroDesconto();
        result = result * 59 + ($valorPrimeiroDesconto == null ? 43 : ((Object)$valorPrimeiroDesconto).hashCode());
        String $dataSegundoDesconto = this.getDataSegundoDesconto();
        result = result * 59 + ($dataSegundoDesconto == null ? 43 : $dataSegundoDesconto.hashCode());
        BigDecimal $valorSegundoDesconto = this.getValorSegundoDesconto();
        result = result * 59 + ($valorSegundoDesconto == null ? 43 : ((Object)$valorSegundoDesconto).hashCode());
        String $dataTerceiroDesconto = this.getDataTerceiroDesconto();
        result = result * 59 + ($dataTerceiroDesconto == null ? 43 : $dataTerceiroDesconto.hashCode());
        BigDecimal $valorTerceiroDesconto = this.getValorTerceiroDesconto();
        result = result * 59 + ($valorTerceiroDesconto == null ? 43 : ((Object)$valorTerceiroDesconto).hashCode());
        String $dataMulta = this.getDataMulta();
        result = result * 59 + ($dataMulta == null ? 43 : $dataMulta.hashCode());
        BigDecimal $valorMulta = this.getValorMulta();
        result = result * 59 + ($valorMulta == null ? 43 : ((Object)$valorMulta).hashCode());
        String $dataJurosMora = this.getDataJurosMora();
        result = result * 59 + ($dataJurosMora == null ? 43 : $dataJurosMora.hashCode());
        BigDecimal $valorJurosMora = this.getValorJurosMora();
        result = result * 59 + ($valorJurosMora == null ? 43 : ((Object)$valorJurosMora).hashCode());
        PagadorBoletoRegistradoSicoobDTO $pagador = this.getPagador();
        result = result * 59 + ($pagador == null ? 43 : $pagador.hashCode());
        String $qrCode = this.getQrCode();
        result = result * 59 + ($qrCode == null ? 43 : $qrCode.hashCode());
        String $linhaDigitavel = this.getLinhaDigitavel();
        result = result * 59 + ($linhaDigitavel == null ? 43 : $linhaDigitavel.hashCode());
        String $codigoBarras = this.getCodigoBarras();
        result = result * 59 + ($codigoBarras == null ? 43 : $codigoBarras.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BoletoRegistradoSicoobDTO(numeroContrato=" + this.getNumeroContrato() + ", numeroCliente=" + this.getNumeroCliente() + ", modalidade=" + this.getModalidade() + ", codigoModalidade=" + this.getCodigoModalidade() + ", numeroContaCorrente=" + this.getNumeroContaCorrente() + ", especieDocumento=" + this.getEspecieDocumento() + ", codigoEspecieDocumento=" + this.getCodigoEspecieDocumento() + ", dataEmissao=" + this.getDataEmissao() + ", nossoNumero=" + this.getNossoNumero() + ", seuNumero=" + this.getSeuNumero() + ", identificacaoBoletoEmpresa=" + this.getIdentificacaoBoletoEmpresa() + ", identificacaoEmissaoBoleto=" + this.getIdentificacaoEmissaoBoleto() + ", identificacaoDistribuicaoBoleto=" + this.getIdentificacaoDistribuicaoBoleto() + ", valor=" + this.getValor() + ", dataVencimento=" + this.getDataVencimento() + ", dataLimitePagamento=" + this.getDataLimitePagamento() + ", tipoDesconto=" + this.getTipoDesconto() + ", dataPrimeiroDesconto=" + this.getDataPrimeiroDesconto() + ", valorPrimeiroDesconto=" + this.getValorPrimeiroDesconto() + ", dataSegundoDesconto=" + this.getDataSegundoDesconto() + ", valorSegundoDesconto=" + this.getValorSegundoDesconto() + ", dataTerceiroDesconto=" + this.getDataTerceiroDesconto() + ", valorTerceiroDesconto=" + this.getValorTerceiroDesconto() + ", tipoMulta=" + this.getTipoMulta() + ", dataMulta=" + this.getDataMulta() + ", valorMulta=" + this.getValorMulta() + ", tipoJurosMora=" + this.getTipoJurosMora() + ", dataJurosMora=" + this.getDataJurosMora() + ", valorJurosMora=" + this.getValorJurosMora() + ", numeroParcela=" + this.getNumeroParcela() + ", codigoNegativacao=" + this.getCodigoNegativacao() + ", numeroDiasNegativacao=" + this.getNumeroDiasNegativacao() + ", codigoProtesto=" + this.getCodigoProtesto() + ", numeroDiasProtesto=" + this.getNumeroDiasProtesto() + ", pagador=" + this.getPagador() + ", gerarPdf=" + this.getGerarPdf() + ", codigoCadastrarPIX=" + this.getCodigoCadastrarPIX() + ", qrCode=" + this.getQrCode() + ", linhaDigitavel=" + this.getLinhaDigitavel() + ", codigoBarras=" + this.getCodigoBarras() + ")";
    }
}

