/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.contencioso;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.util.MultiValueFilter;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

public class FiltroDebitosContenciosoDTO {
    private Long entidade;
    private Long tipoCadastro;
    @Length(max=100, message="Permitido no m\u00e1ximo 100 caracteres para o cadastro geral.")
    private @Length(max=100, message="Permitido no m\u00e1ximo 100 caracteres para o cadastro geral.") String cadastroGeral;
    @Length(max=100, message="Permitido no m\u00e1ximo 100 caracteres para o ano d\u00e9bito.")
    private @Length(max=100, message="Permitido no m\u00e1ximo 100 caracteres para o ano d\u00e9bito.") String exercicioDebito;
    @Length(max=100, message="Permitido no m\u00e1ximo 100 caracteres para a d\u00edvida.")
    private @Length(max=100, message="Permitido no m\u00e1ximo 100 caracteres para a d\u00edvida.") String divida;
    private String subDivida;
    private Boolean porParcelamento = Boolean.FALSE;
    private Long numeroContrato;
    private Long anoContrato;

    private String addAND(String clausula) {
        return " and " + clausula;
    }

    private void validaFiltro() {
        if (Objects.isNull(this.entidade) && Objects.isNull(this.tipoCadastro) && StringUtils.isBlank((CharSequence)this.cadastroGeral) && StringUtils.isBlank((CharSequence)this.exercicioDebito) && StringUtils.isBlank((CharSequence)this.divida) && StringUtils.isBlank((CharSequence)this.subDivida) && Objects.isNull(this.numeroContrato) && Objects.isNull(this.anoContrato)) {
            throw new EloValidationException("\u00c9 necess\u00e1rio informar ao menos um filtro.");
        }
    }

    public String getFiltro() {
        this.validaFiltro();
        StringBuilder filtro = new StringBuilder();
        if (Objects.nonNull(this.tipoCadastro)) {
            filtro.append(MultiValueFilter.generateFiltersRsql((String)String.valueOf(this.tipoCadastro), (String)"tipoCadastro"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.cadastroGeral)) {
            filtro.append(this.addAND(MultiValueFilter.generateFiltersRsql((String)this.cadastroGeral, (String)"cadastroGeralId")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.exercicioDebito)) {
            filtro.append(this.addAND(MultiValueFilter.generateFiltersRsql((String)this.exercicioDebito, (String)"exercicio")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.divida)) {
            filtro.append(this.addAND(MultiValueFilter.generateFiltersRsql((String)this.divida, (String)"guiaRecolhimento")));
        }
        if (StringUtils.isNotBlank((CharSequence)this.subDivida)) {
            filtro.append(this.addAND(MultiValueFilter.generateFiltersRsql((String)this.subDivida, (String)"subDivida")));
        }
        filtro.append(this.addAND("(parcelado == false and reparcelado == false)"));
        return filtro.toString();
    }

    @Generated
    public FiltroDebitosContenciosoDTO() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getExercicioDebito() {
        return this.exercicioDebito;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public String getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public Boolean getPorParcelamento() {
        return this.porParcelamento;
    }

    @Generated
    public Long getNumeroContrato() {
        return this.numeroContrato;
    }

    @Generated
    public Long getAnoContrato() {
        return this.anoContrato;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setExercicioDebito(String exercicioDebito) {
        this.exercicioDebito = exercicioDebito;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(String subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setPorParcelamento(Boolean porParcelamento) {
        this.porParcelamento = porParcelamento;
    }

    @Generated
    public void setNumeroContrato(Long numeroContrato) {
        this.numeroContrato = numeroContrato;
    }

    @Generated
    public void setAnoContrato(Long anoContrato) {
        this.anoContrato = anoContrato;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroDebitosContenciosoDTO)) {
            return false;
        }
        FiltroDebitosContenciosoDTO other = (FiltroDebitosContenciosoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Boolean this$porParcelamento = this.getPorParcelamento();
        Boolean other$porParcelamento = other.getPorParcelamento();
        if (this$porParcelamento == null ? other$porParcelamento != null : !((Object)this$porParcelamento).equals(other$porParcelamento)) {
            return false;
        }
        Long this$numeroContrato = this.getNumeroContrato();
        Long other$numeroContrato = other.getNumeroContrato();
        if (this$numeroContrato == null ? other$numeroContrato != null : !((Object)this$numeroContrato).equals(other$numeroContrato)) {
            return false;
        }
        Long this$anoContrato = this.getAnoContrato();
        Long other$anoContrato = other.getAnoContrato();
        if (this$anoContrato == null ? other$anoContrato != null : !((Object)this$anoContrato).equals(other$anoContrato)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        String this$exercicioDebito = this.getExercicioDebito();
        String other$exercicioDebito = other.getExercicioDebito();
        if (this$exercicioDebito == null ? other$exercicioDebito != null : !this$exercicioDebito.equals(other$exercicioDebito)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$subDivida = this.getSubDivida();
        String other$subDivida = other.getSubDivida();
        return !(this$subDivida == null ? other$subDivida != null : !this$subDivida.equals(other$subDivida));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroDebitosContenciosoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Boolean $porParcelamento = this.getPorParcelamento();
        result = result * 59 + ($porParcelamento == null ? 43 : ((Object)$porParcelamento).hashCode());
        Long $numeroContrato = this.getNumeroContrato();
        result = result * 59 + ($numeroContrato == null ? 43 : ((Object)$numeroContrato).hashCode());
        Long $anoContrato = this.getAnoContrato();
        result = result * 59 + ($anoContrato == null ? 43 : ((Object)$anoContrato).hashCode());
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        String $exercicioDebito = this.getExercicioDebito();
        result = result * 59 + ($exercicioDebito == null ? 43 : $exercicioDebito.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : $subDivida.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroDebitosContenciosoDTO(entidade=" + this.getEntidade() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", exercicioDebito=" + this.getExercicioDebito() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", porParcelamento=" + this.getPorParcelamento() + ", numeroContrato=" + this.getNumeroContrato() + ", anoContrato=" + this.getAnoContrato() + ")";
    }
}

