/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.atualizacaomonetariaparcelamento;

import br.com.elotech.tributos.util.MultiValueFilter;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class FiltroItensAtualizacaoMonetariaDTO {
    private String tipoCadastro;
    private String cadastroGeral;
    private String exercicio;
    private String divida;
    private String subdivida;
    private String tributo;
    private Boolean somenteAtualizados = Boolean.TRUE;

    public String buildFilter() {
        ArrayList<String> filters = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)this.tipoCadastro)) {
            filters.add(MultiValueFilter.generateFilters((String)this.tipoCadastro, (String)"tdpr.tipocadastro"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.cadastroGeral)) {
            filters.add(MultiValueFilter.generateFilters((String)this.cadastroGeral, (String)"tdpr.cadastrogeral"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.exercicio)) {
            filters.add(MultiValueFilter.generateFilters((String)this.exercicio, (String)"tdpr.exercicio"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.divida)) {
            filters.add(MultiValueFilter.generateFilters((String)this.divida, (String)"tdpr.guiarecolhimento"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.subdivida)) {
            filters.add(MultiValueFilter.generateFilters((String)this.subdivida, (String)"tdpr.subdivida"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.tributo)) {
            String itens = Stream.of(this.tributo.split(",")).filter(StringUtils::isNotEmpty).map(tributo -> String.format("'%s'", tributo.trim())).collect(Collectors.joining(","));
            filters.add(String.format("tdpr.receita in (%s)", itens));
        }
        if (Boolean.TRUE.equals(this.somenteAtualizados)) {
            filters.add("(tdprea.valoratualizacao > 0)");
        }
        return String.join((CharSequence)" and ", filters);
    }

    @Generated
    public String getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getExercicio() {
        return this.exercicio;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public String getSubdivida() {
        return this.subdivida;
    }

    @Generated
    public String getTributo() {
        return this.tributo;
    }

    @Generated
    public Boolean getSomenteAtualizados() {
        return this.somenteAtualizados;
    }

    @Generated
    public void setTipoCadastro(String tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setExercicio(String exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubdivida(String subdivida) {
        this.subdivida = subdivida;
    }

    @Generated
    public void setTributo(String tributo) {
        this.tributo = tributo;
    }

    @Generated
    public void setSomenteAtualizados(Boolean somenteAtualizados) {
        this.somenteAtualizados = somenteAtualizados;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroItensAtualizacaoMonetariaDTO)) {
            return false;
        }
        FiltroItensAtualizacaoMonetariaDTO other = (FiltroItensAtualizacaoMonetariaDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$somenteAtualizados = this.getSomenteAtualizados();
        Boolean other$somenteAtualizados = other.getSomenteAtualizados();
        if (this$somenteAtualizados == null ? other$somenteAtualizados != null : !((Object)this$somenteAtualizados).equals(other$somenteAtualizados)) {
            return false;
        }
        String this$tipoCadastro = this.getTipoCadastro();
        String other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        String this$exercicio = this.getExercicio();
        String other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !this$exercicio.equals(other$exercicio)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$subdivida = this.getSubdivida();
        String other$subdivida = other.getSubdivida();
        if (this$subdivida == null ? other$subdivida != null : !this$subdivida.equals(other$subdivida)) {
            return false;
        }
        String this$tributo = this.getTributo();
        String other$tributo = other.getTributo();
        return !(this$tributo == null ? other$tributo != null : !this$tributo.equals(other$tributo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroItensAtualizacaoMonetariaDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $somenteAtualizados = this.getSomenteAtualizados();
        result = result * 59 + ($somenteAtualizados == null ? 43 : ((Object)$somenteAtualizados).hashCode());
        String $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        String $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : $exercicio.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $subdivida = this.getSubdivida();
        result = result * 59 + ($subdivida == null ? 43 : $subdivida.hashCode());
        String $tributo = this.getTributo();
        result = result * 59 + ($tributo == null ? 43 : $tributo.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroItensAtualizacaoMonetariaDTO(tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", exercicio=" + this.getExercicio() + ", divida=" + this.getDivida() + ", subdivida=" + this.getSubdivida() + ", tributo=" + this.getTributo() + ", somenteAtualizados=" + this.getSomenteAtualizados() + ")";
    }

    @Generated
    public FiltroItensAtualizacaoMonetariaDTO() {
    }

    @Generated
    public FiltroItensAtualizacaoMonetariaDTO(String tipoCadastro, String cadastroGeral, String exercicio, String divida, String subdivida, String tributo, Boolean somenteAtualizados) {
        this.tipoCadastro = tipoCadastro;
        this.cadastroGeral = cadastroGeral;
        this.exercicio = exercicio;
        this.divida = divida;
        this.subdivida = subdivida;
        this.tributo = tributo;
        this.somenteAtualizados = somenteAtualizados;
    }
}

