/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.memoria;

import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.CalculatedModel;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.Condominio;
import br.com.elotech.tributos.domain.Distrito;
import br.com.elotech.tributos.domain.Imobiliaria;
import br.com.elotech.tributos.domain.Loteamento;
import br.com.elotech.tributos.domain.Quadricula;
import br.com.elotech.tributos.domain.Setor;
import br.com.elotech.tributos.domain.SetorQuadra;
import br.com.elotech.tributos.domain.TipoImovel;
import br.com.elotech.tributos.domain.TipoLote;
import br.com.elotech.tributos.domain.camposdinamicos.DynamicValidation;
import br.com.elotech.tributos.domain.camposdinamicos.Resposta;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioProfundidade;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSituacao;
import br.com.elotech.tributos.domain.memoria.CadastroGeralIsencaoMemoria;
import br.com.elotech.tributos.domain.memoria.CadastroGeralMemoria;
import br.com.elotech.tributos.domain.memoria.CadastroGeralMemoriaId;
import br.com.elotech.tributos.domain.memoria.ImobiliarioAreaVerdeMemoria;
import br.com.elotech.tributos.domain.memoria.ImobiliarioSegmentoMemoria;
import br.com.elotech.tributos.domain.memoria.ImobiliarioSegmentoMemoriaId;
import br.com.elotech.tributos.domain.memoria.ImobiliarioTestadaGenericaMemoria;
import br.com.elotech.tributos.domain.memoria.ImobiliarioTestadaMemoria;
import br.com.elotech.tributos.domain.memoria.MemoriaCadastro;
import br.com.elotech.tributos.domain.memoria.RespostaTerrenoMemoria;
import br.com.elotech.tributos.dto.camposdinamicos.GrupoRespostasDTO;
import br.com.elotech.tributos.util.ListUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.validation.constraints.DecimalMin;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.springframework.util.Assert;

@Entity
@Table(name="tribcadastroimobiliariomemoria")
public class CadastroImobiliarioMemoria
implements EloEntity<CadastroGeralMemoriaId>,
Serializable {
    @EmbeddedId
    private CadastroGeralMemoriaId id;
    @Column(length=40)
    @Caption(value="Inscri\u00e7\u00e3o Cadastral")
    private String inscricaoCadastral;
    @Column(length=50)
    @Caption(value="Inscri\u00e7\u00e3o Cadastral Anterior")
    private String inscricaoCadastralAnterior;
    @Column(name="TRECHO_INSCRICAOCADASTRAL")
    @Caption(value="Trecho Inscri\u00e7\u00e3o Cadastral")
    private Long trechoInscricaoCadastral;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="distrito_inscricaocadastral", referencedColumnName="distrito", insertable=false, updatable=false), @JoinColumn(name="setor_inscricaocadastral", referencedColumnName="setor", insertable=false, updatable=false)})
    private Setor setorLocalizacao;
    @Column(name="setor_inscricaocadastral")
    private String setorInscricaocadastral;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="distrito_inscricaocadastral", referencedColumnName="distrito", insertable=false, updatable=false), @JoinColumn(name="setor_inscricaocadastral", referencedColumnName="setor", insertable=false, updatable=false), @JoinColumn(name="quadra_inscricaocadastral", referencedColumnName="quadra", insertable=false, updatable=false)})
    private SetorQuadra quadraLocalizacao;
    @Column(name="quadra_inscricaocadastral")
    private String quadraInscricaocadastral;
    @Column(length=20, name="LOTE_INSCRICAOCADASTRAL")
    @Caption(value="Lote Inscri\u00e7\u00e3o Cadastral")
    private String loteLocalizacao;
    @ManyToOne
    @JoinColumn(name="DISTRITO_INSCRICAOCADASTRAL", referencedColumnName="DISTRITO")
    @Caption(value="Distrito Inscri\u00e7\u00e3o Cadastral")
    private Distrito distritoLocalizacao;
    @Column(length=15, name="UNIDADE_INSCRICAOCADASTRAL")
    @Caption(value="Unidade Inscri\u00e7\u00e3o Cadastral")
    private String unidadeLocalizacao;
    @Column(length=15, name="DISTRITO_DESCR")
    @Caption(value="Descri\u00e7\u00e3o Distrito")
    private String distritoFiscalizacao;
    @Column(length=15, name="SETOR_DESCR")
    @Caption(value="Descri\u00e7\u00e3o Setor")
    private String setorFiscalizacao;
    @Column(length=15, name="TRECHO_DESCR")
    @Caption(value="Descri\u00e7\u00e3o Trecho")
    private String trechoDescr;
    @Column(length=15, name="QUADRA_DESCR")
    @Caption(value="Quadra Setor")
    private String quadraFiscalizacao;
    @Column(length=50, name="LOTE_DESCR")
    @Caption(value="Lote Setor")
    private String loteFiscalizacao;
    @Column(length=15, name="UNIDADE_DESCR")
    @Caption(value="Unidade Inscri\u00e7\u00e3o Cadastral")
    private String unidadeFiscalizacao;
    @ManyToOne
    @Caption(value="Imobili\u00e1ria")
    private Imobiliaria imobiliaria;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="distrito_inscricaocadastral", referencedColumnName="distrito", insertable=false, updatable=false), @JoinColumn(name="setor_inscricaocadastral", referencedColumnName="setor", insertable=false, updatable=false), @JoinColumn(name="condominio", referencedColumnName="condominio", insertable=false, updatable=false)})
    private Condominio condominio;
    @Column(name="condominio")
    private Long condominioCodigo;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="distrito_inscricaocadastral", referencedColumnName="distrito", insertable=false, updatable=false), @JoinColumn(name="setor_inscricaocadastral", referencedColumnName="setor", insertable=false, updatable=false), @JoinColumn(name="loteamento", referencedColumnName="loteamento", insertable=false, updatable=false)})
    private Loteamento loteamento;
    @Column(name="loteamento")
    private Long loteamentoCodigo;
    @Caption(value="Ano Al\u00edquota Progressiva")
    private Long anoAliquotaProgressiva;
    @DecimalMin(value="0", inclusive=false)
    @Caption(value="\u00c1rea do Lote")
    private @DecimalMin(value="0", inclusive=false) BigDecimal areaLote = BigDecimal.ZERO;
    @Caption(value="Profundidade M\u00e9dia")
    private BigDecimal profundidadeMedia = BigDecimal.ZERO;
    @Caption(value="\u00c1rea Total Constru\u00edda")
    private BigDecimal areaTotalConstruida = BigDecimal.ZERO;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Limita Cerca Muro")
    private Boolean limitaCercaMuro = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Im\u00f3vel Pr\u00f3prio")
    private Boolean imovelProprio = Boolean.FALSE;
    @Column(length=15)
    @Caption(value="Matr\u00edcula")
    private String matricula;
    @Column(length=60)
    @Caption(value="Cart\u00f3rio")
    private String cartorio;
    @Column
    @Caption(value="Data da Matr\u00edcula")
    private LocalDate dataMatricula;
    @Column(length=15)
    @Caption(value="Livro")
    private String livro;
    @Column(length=15)
    @Caption(value="Folha")
    private String folha;
    @Column(length=15)
    @Caption(value="Face Quadra")
    private String faceQuadra;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Caucionado")
    private Boolean caucionado = Boolean.FALSE;
    @Column(length=60)
    @Caption(value="Latitude")
    private String latitude;
    @Column(length=60)
    @Caption(value="Longitude")
    private String longitude;
    @Caption(value="\u00c1rea Constru\u00edda")
    private BigDecimal areaUnidadeConstruida = BigDecimal.ZERO;
    @Caption(value="\u00c1rea \u00datil do Lote")
    private BigDecimal areaUtilLote = BigDecimal.ZERO;
    @Caption(value="\u00c1rea Privativa")
    private BigDecimal areaPrivativa = BigDecimal.ZERO;
    @Caption(value="\u00c1rea Comum")
    private BigDecimal areaComum = BigDecimal.ZERO;
    @Column(length=1000)
    @Caption(value="Complemento Lote")
    private String complementoLote;
    @Caption(value="Tipo do Im\u00f3vel")
    private TipoImovel tipoImovel = TipoImovel.TERRITORIAL;
    @Caption(value="Notifica\u00e7\u00e3o de Al\u00edquota Progressiva")
    private Long notificacaoAliquotaProgressiva;
    @Caption(value="Data Of\u00edcio Al\u00edquota Progressiva")
    private LocalDate dataOficioAliquotaProgressiva;
    @DynamicValidation(label="Tipo de Lote")
    @Caption(value="Tipo de Lote")
    private TipoLote tipoLote;
    @ManyToOne
    @JoinColumn(name="QUADRICULA_INSCRICAOCADASTRAL", referencedColumnName="QUADRICULA")
    @Caption(value="Quadr\u00edcula Inscri\u00e7\u00e3o Cadastral")
    private Quadricula quadriculaLocalizacao;
    @Column(length=20)
    @Caption(value="N\u00famero Incra")
    private String numeroIncra;
    @Column(name="AREATOTALINSCRICAO")
    @Caption(value="\u00c1rea Total N\u00e3o Lan\u00e7ada")
    private BigDecimal areaTotalInscricao = BigDecimal.ZERO;
    @Caption(value="Tipo de Cadastro")
    @Column(name="tipocadastro", insertable=false, updatable=false)
    private Long tipoCadastro;
    @Caption(value="C\u00f3digo do Cadastro")
    @Column(name="cadastrogeral", insertable=false, updatable=false)
    private Long cadastroGeral;
    @Length(max=1)
    @Caption(value="Situa\u00e7\u00e3o Desapropriado")
    private @Length(max=1) String situacaoDesapropriado;
    @Column(name="QUADRICULA_DESCRI", length=15)
    @Caption(value="Descri\u00e7\u00e3o Quadr\u00edcula")
    private String quadriculaFiscalizacao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idmemoriacadastro", insertable=false, updatable=false)
    private MemoriaCadastro memoriaCadastro;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="cadastroImobiliarioMemoria")
    private List<ImobiliarioTestadaMemoria> testadas = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="cadastroImobiliarioMemoria")
    private List<ImobiliarioTestadaGenericaMemoria> testadasGenericas = new ArrayList();
    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumns(value={@JoinColumn(name="idmemoriacadastro", referencedColumnName="idmemoriacadastro", updatable=false), @JoinColumn(name="tipocadastro", referencedColumnName="tipocadastro", updatable=false), @JoinColumn(name="cadastrogeral", referencedColumnName="cadastrogeral", updatable=false)})
    private CadastroGeralMemoria cadastroGeralMemoria;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="idmemoriacadastro", referencedColumnName="idmemoriacadastro", updatable=false), @JoinColumn(name="tipocadastro", referencedColumnName="tipocadastro", updatable=false), @JoinColumn(name="cadastrogeral", referencedColumnName="cadastrogeral", updatable=false)})
    private List<ImobiliarioAreaVerdeMemoria> areasVerde = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @OrderBy(value="sequencia")
    @JoinColumns(value={@JoinColumn(name="idmemoriacadastro", referencedColumnName="idmemoriacadastro", insertable=false, updatable=false), @JoinColumn(name="tipocadastro", referencedColumnName="tipocadastro", insertable=false, updatable=false), @JoinColumn(name="cadastrogeral", referencedColumnName="cadastrogeral", insertable=false, updatable=false)})
    private List<ImobiliarioSegmentoMemoria> segmentos = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="tipocadastro", referencedColumnName="tipocadastro", updatable=false), @JoinColumn(name="cadastrogeral", referencedColumnName="cadastrogeral", updatable=false)})
    @OrderBy(value="sequencia")
    private final List<CadastroImobiliarioProfundidade> profundidades = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="tipocadastro", referencedColumnName="tipocadastro", updatable=false), @JoinColumn(name="cadastrogeral", referencedColumnName="cadastrogeral", updatable=false)})
    @Caption(value="Situa\u00e7\u00f5es")
    private final List<CadastroImobiliarioSituacao> situacoes = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="idmemoriacadastro", referencedColumnName="idmemoriacadastro", updatable=false), @JoinColumn(name="tipocadastro", referencedColumnName="tipocadastro", updatable=false), @JoinColumn(name="cadastrogeral", referencedColumnName="cadastrogeral", updatable=false)})
    @Caption(value="Isen\u00e7\u00f5es")
    private List<CadastroGeralIsencaoMemoria> isencoes = new ArrayList();

    @JsonIgnore
    public BigDecimal getAreaTotalSegmentos(Boolean somenteLancaImposto) {
        return this.segmentos.stream().filter(segmento -> somenteLancaImposto == false || segmento.lancaImposto() != false).reduce(BigDecimal.ZERO, (acc, curr) -> acc.add(curr.getAreaConstruida()), BigDecimal::add);
    }

    @CalculatedModel(fieldPath="situacaoAtual", caption="Situa\u00e7\u00e3o Atual")
    public CadastroImobiliarioSituacao getSituacaoAtual() {
        for (CadastroImobiliarioSituacao situacao : this.situacoes) {
            if (!Boolean.TRUE.equals(situacao.getAtual())) continue;
            return situacao;
        }
        return null;
    }

    public CadastroImobiliarioMemoria merge(CadastroImobiliarioMemoria cadastroImobiliarioToMerge, List<GrupoRespostasDTO> respostasTerreno) {
        Assert.isTrue((boolean)cadastroImobiliarioToMerge.getId().equals((Object)this.getId()), (String)"Para fazer o merge, os cadastros devem ter o mesmo id");
        this.setTipoImovel(cadastroImobiliarioToMerge.getTipoImovel());
        this.setTipoLote(cadastroImobiliarioToMerge.getTipoLote());
        this.setQuadriculaLocalizacao(cadastroImobiliarioToMerge.getQuadriculaLocalizacao());
        this.setDistritoLocalizacao(cadastroImobiliarioToMerge.getDistritoLocalizacao());
        this.setSetorLocalizacao(cadastroImobiliarioToMerge.getSetorLocalizacao());
        this.setQuadraLocalizacao(cadastroImobiliarioToMerge.getQuadraLocalizacao());
        this.setLoteLocalizacao(cadastroImobiliarioToMerge.getLoteLocalizacao());
        this.setUnidadeLocalizacao(cadastroImobiliarioToMerge.getUnidadeLocalizacao());
        this.setInscricaoCadastral(cadastroImobiliarioToMerge.getInscricaoCadastral());
        this.setInscricaoCadastralAnterior(cadastroImobiliarioToMerge.getInscricaoCadastralAnterior());
        this.setLoteamento(cadastroImobiliarioToMerge.getLoteamento());
        this.setFaceQuadra(cadastroImobiliarioToMerge.getFaceQuadra());
        this.setCondominio(cadastroImobiliarioToMerge.getCondominio());
        this.setFaceQuadra(cadastroImobiliarioToMerge.getFaceQuadra());
        this.setDataMatricula(cadastroImobiliarioToMerge.getDataMatricula());
        this.setCartorio(cadastroImobiliarioToMerge.getCartorio());
        this.setLivro(cadastroImobiliarioToMerge.getLivro());
        this.setFolha(cadastroImobiliarioToMerge.getFolha());
        this.setQuadraFiscalizacao(cadastroImobiliarioToMerge.getQuadraFiscalizacao());
        this.setLoteFiscalizacao(cadastroImobiliarioToMerge.getLoteFiscalizacao());
        this.setComplementoLote(cadastroImobiliarioToMerge.getComplementoLote());
        this.setMatricula(cadastroImobiliarioToMerge.getMatricula());
        this.setSetorInscricaocadastral((String)Optional.ofNullable(cadastroImobiliarioToMerge.getSetorLocalizacao()).map(Setor::getSetor).orElse(null));
        this.setQuadraInscricaocadastral((String)Optional.ofNullable(cadastroImobiliarioToMerge.getQuadraLocalizacao()).map(SetorQuadra::getQuadra).orElse(null));
        this.setLoteamentoCodigo((Long)Optional.ofNullable(cadastroImobiliarioToMerge.getLoteamento()).map(Loteamento::getLoteamento).orElse(null));
        this.setCondominioCodigo((Long)Optional.ofNullable(cadastroImobiliarioToMerge.getCondominio()).map(Condominio::getCondominio).orElse(null));
        this.setAreaLote(cadastroImobiliarioToMerge.getAreaLote());
        this.setAreaUtilLote(cadastroImobiliarioToMerge.getAreaUtilLote());
        this.setAreaComum(cadastroImobiliarioToMerge.getAreaComum());
        this.setAreaPrivativa(cadastroImobiliarioToMerge.getAreaPrivativa());
        this.setAreaTotalConstruida(cadastroImobiliarioToMerge.getAreaTotalConstruida());
        this.setAreaTotalInscricao(cadastroImobiliarioToMerge.getAreaTotalInscricao());
        this.setAreaUnidadeConstruida(cadastroImobiliarioToMerge.getAreaUnidadeConstruida());
        this.mergeProfundidades(cadastroImobiliarioToMerge.getProfundidades());
        this.mergeTestadas(cadastroImobiliarioToMerge.getTestadas());
        this.mergeTestadasGenericas(cadastroImobiliarioToMerge.getTestadasGenericas());
        this.mergeSegmentos(cadastroImobiliarioToMerge.getSegmentos());
        this.mergeRespostasTerreno(respostasTerreno);
        this.mergeAreasVerde(cadastroImobiliarioToMerge.getAreasVerde());
        this.mergeIsencoes(cadastroImobiliarioToMerge.getIsencoes());
        this.atualizaReferenciaCamposDinamicos();
        return this;
    }

    private void mergeProfundidades(List<CadastroImobiliarioProfundidade> novasProfundidades) {
        List merged = ListUtils.merge((List)this.getProfundidades(), novasProfundidades, CadastroImobiliarioProfundidade::getSequencia, CadastroImobiliarioProfundidade::merge);
        this.getProfundidades().clear();
        this.getProfundidades().addAll(merged);
    }

    private void mergeTestadas(List<ImobiliarioTestadaMemoria> novasTestadas) {
        List merged = ListUtils.merge((List)this.getTestadas(), novasTestadas, ImobiliarioTestadaMemoria::getId, ImobiliarioTestadaMemoria::merge);
        this.getTestadas().clear();
        this.getTestadas().addAll(merged);
    }

    private void mergeTestadasGenericas(List<ImobiliarioTestadaGenericaMemoria> novasTestadasGenericas) {
        List merged = ListUtils.merge((List)this.getTestadasGenericas(), novasTestadasGenericas, ImobiliarioTestadaGenericaMemoria::getId, ImobiliarioTestadaGenericaMemoria::merge);
        this.getTestadasGenericas().clear();
        this.getTestadasGenericas().addAll(merged);
    }

    private void mergeSegmentos(List<ImobiliarioSegmentoMemoria> novosSegmentos) {
        List merged = ListUtils.merge((List)this.getSegmentos(), novosSegmentos, ImobiliarioSegmentoMemoria::getId, ImobiliarioSegmentoMemoria::merge);
        this.getSegmentos().clear();
        this.getSegmentos().addAll(merged);
    }

    private void mergeRespostasTerreno(List<GrupoRespostasDTO> respostasTerreno) {
        List currentRespostas = this.getCadastroGeralMemoria().getRespostasTerrenoMemoria();
        ArrayList newRespostas = new ArrayList();
        respostasTerreno.forEach(grupoRespostasDTO -> grupoRespostasDTO.getRespostasPreenchidas().forEach(resposta -> {
            RespostaTerrenoMemoria novaResposta = (RespostaTerrenoMemoria)resposta.copyTo((Resposta)new RespostaTerrenoMemoria());
            novaResposta.setCadastroGeral(this.getCadastroGeralMemoria());
            newRespostas.add(novaResposta);
        }));
        List merged = ListUtils.merge((List)currentRespostas, newRespostas, Resposta::getId, RespostaTerrenoMemoria::merge);
        currentRespostas.clear();
        currentRespostas.addAll(merged);
    }

    private void mergeAreasVerde(List<ImobiliarioAreaVerdeMemoria> novasAreasVerde) {
        List merged = ListUtils.merge((List)this.getAreasVerde(), novasAreasVerde, ImobiliarioAreaVerdeMemoria::getId, ImobiliarioAreaVerdeMemoria::merge);
        this.getAreasVerde().clear();
        this.getAreasVerde().addAll(merged);
    }

    private void mergeIsencoes(List<CadastroGeralIsencaoMemoria> novasIsencoes) {
        List merged = ListUtils.merge((List)this.getIsencoes(), novasIsencoes, CadastroGeralIsencaoMemoria::getId, CadastroGeralIsencaoMemoria::merge);
        this.getIsencoes().clear();
        this.getIsencoes().addAll(merged);
    }

    public void atualizaReferenciaCamposDinamicos() {
        this.atualizaReferenciaRespostaTerreno();
        this.atualizaReferenciaRespostaSegmento();
    }

    private void atualizaReferenciaRespostaTerreno() {
        this.cadastroGeralMemoria.getRespostasTerrenoMemoria().forEach(respostaTerreno -> {
            if (Objects.isNull(respostaTerreno.getCadastroGeral())) {
                respostaTerreno.setCadastroGeral(this.cadastroGeralMemoria);
            }
        });
    }

    private void atualizaReferenciaRespostaSegmento() {
        this.segmentos.forEach(segmento -> {
            if (Objects.isNull(segmento.getId())) {
                ImobiliarioSegmentoMemoriaId imobiliarioSegmentoMemoriaId = new ImobiliarioSegmentoMemoriaId();
                segmento.setId(imobiliarioSegmentoMemoriaId);
            }
            if (Objects.isNull(segmento.getId().getIdMemoriaCadastro())) {
                segmento.getId().setIdMemoriaCadastro(this.getId().getIdMemoriaCadastro());
            }
            segmento.setTipoCadastro(this.getId().getTipoCadastro());
            segmento.setCadastroGeral(this.getId().getCadastroGeral());
            segmento.getRespostasSegmento().forEach(respostaSegmento -> {
                if (Objects.isNull(respostaSegmento.getSegmento())) {
                    respostaSegmento.setSegmento(segmento);
                }
            });
        });
    }

    @Generated
    public CadastroImobiliarioMemoria() {
    }

    @Generated
    public CadastroGeralMemoriaId getId() {
        return this.id;
    }

    @Generated
    public String getInscricaoCadastral() {
        return this.inscricaoCadastral;
    }

    @Generated
    public String getInscricaoCadastralAnterior() {
        return this.inscricaoCadastralAnterior;
    }

    @Generated
    public Long getTrechoInscricaoCadastral() {
        return this.trechoInscricaoCadastral;
    }

    @Generated
    public Setor getSetorLocalizacao() {
        return this.setorLocalizacao;
    }

    @Generated
    public String getSetorInscricaocadastral() {
        return this.setorInscricaocadastral;
    }

    @Generated
    public SetorQuadra getQuadraLocalizacao() {
        return this.quadraLocalizacao;
    }

    @Generated
    public String getQuadraInscricaocadastral() {
        return this.quadraInscricaocadastral;
    }

    @Generated
    public String getLoteLocalizacao() {
        return this.loteLocalizacao;
    }

    @Generated
    public Distrito getDistritoLocalizacao() {
        return this.distritoLocalizacao;
    }

    @Generated
    public String getUnidadeLocalizacao() {
        return this.unidadeLocalizacao;
    }

    @Generated
    public String getDistritoFiscalizacao() {
        return this.distritoFiscalizacao;
    }

    @Generated
    public String getSetorFiscalizacao() {
        return this.setorFiscalizacao;
    }

    @Generated
    public String getTrechoDescr() {
        return this.trechoDescr;
    }

    @Generated
    public String getQuadraFiscalizacao() {
        return this.quadraFiscalizacao;
    }

    @Generated
    public String getLoteFiscalizacao() {
        return this.loteFiscalizacao;
    }

    @Generated
    public String getUnidadeFiscalizacao() {
        return this.unidadeFiscalizacao;
    }

    @Generated
    public Imobiliaria getImobiliaria() {
        return this.imobiliaria;
    }

    @Generated
    public Condominio getCondominio() {
        return this.condominio;
    }

    @Generated
    public Long getCondominioCodigo() {
        return this.condominioCodigo;
    }

    @Generated
    public Loteamento getLoteamento() {
        return this.loteamento;
    }

    @Generated
    public Long getLoteamentoCodigo() {
        return this.loteamentoCodigo;
    }

    @Generated
    public Long getAnoAliquotaProgressiva() {
        return this.anoAliquotaProgressiva;
    }

    @Generated
    public BigDecimal getAreaLote() {
        return this.areaLote;
    }

    @Generated
    public BigDecimal getProfundidadeMedia() {
        return this.profundidadeMedia;
    }

    @Generated
    public BigDecimal getAreaTotalConstruida() {
        return this.areaTotalConstruida;
    }

    @Generated
    public Boolean getLimitaCercaMuro() {
        return this.limitaCercaMuro;
    }

    @Generated
    public Boolean getImovelProprio() {
        return this.imovelProprio;
    }

    @Generated
    public String getMatricula() {
        return this.matricula;
    }

    @Generated
    public String getCartorio() {
        return this.cartorio;
    }

    @Generated
    public LocalDate getDataMatricula() {
        return this.dataMatricula;
    }

    @Generated
    public String getLivro() {
        return this.livro;
    }

    @Generated
    public String getFolha() {
        return this.folha;
    }

    @Generated
    public String getFaceQuadra() {
        return this.faceQuadra;
    }

    @Generated
    public Boolean getCaucionado() {
        return this.caucionado;
    }

    @Generated
    public String getLatitude() {
        return this.latitude;
    }

    @Generated
    public String getLongitude() {
        return this.longitude;
    }

    @Generated
    public BigDecimal getAreaUnidadeConstruida() {
        return this.areaUnidadeConstruida;
    }

    @Generated
    public BigDecimal getAreaUtilLote() {
        return this.areaUtilLote;
    }

    @Generated
    public BigDecimal getAreaPrivativa() {
        return this.areaPrivativa;
    }

    @Generated
    public BigDecimal getAreaComum() {
        return this.areaComum;
    }

    @Generated
    public String getComplementoLote() {
        return this.complementoLote;
    }

    @Generated
    public TipoImovel getTipoImovel() {
        return this.tipoImovel;
    }

    @Generated
    public Long getNotificacaoAliquotaProgressiva() {
        return this.notificacaoAliquotaProgressiva;
    }

    @Generated
    public LocalDate getDataOficioAliquotaProgressiva() {
        return this.dataOficioAliquotaProgressiva;
    }

    @Generated
    public TipoLote getTipoLote() {
        return this.tipoLote;
    }

    @Generated
    public Quadricula getQuadriculaLocalizacao() {
        return this.quadriculaLocalizacao;
    }

    @Generated
    public String getNumeroIncra() {
        return this.numeroIncra;
    }

    @Generated
    public BigDecimal getAreaTotalInscricao() {
        return this.areaTotalInscricao;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getSituacaoDesapropriado() {
        return this.situacaoDesapropriado;
    }

    @Generated
    public String getQuadriculaFiscalizacao() {
        return this.quadriculaFiscalizacao;
    }

    @Generated
    public MemoriaCadastro getMemoriaCadastro() {
        return this.memoriaCadastro;
    }

    @Generated
    public List<ImobiliarioTestadaMemoria> getTestadas() {
        return this.testadas;
    }

    @Generated
    public List<ImobiliarioTestadaGenericaMemoria> getTestadasGenericas() {
        return this.testadasGenericas;
    }

    @Generated
    public CadastroGeralMemoria getCadastroGeralMemoria() {
        return this.cadastroGeralMemoria;
    }

    @Generated
    public List<ImobiliarioAreaVerdeMemoria> getAreasVerde() {
        return this.areasVerde;
    }

    @Generated
    public List<ImobiliarioSegmentoMemoria> getSegmentos() {
        return this.segmentos;
    }

    @Generated
    public List<CadastroImobiliarioProfundidade> getProfundidades() {
        return this.profundidades;
    }

    @Generated
    public List<CadastroImobiliarioSituacao> getSituacoes() {
        return this.situacoes;
    }

    @Generated
    public List<CadastroGeralIsencaoMemoria> getIsencoes() {
        return this.isencoes;
    }

    @Generated
    public void setId(CadastroGeralMemoriaId id) {
        this.id = id;
    }

    @Generated
    public void setInscricaoCadastral(String inscricaoCadastral) {
        this.inscricaoCadastral = inscricaoCadastral;
    }

    @Generated
    public void setInscricaoCadastralAnterior(String inscricaoCadastralAnterior) {
        this.inscricaoCadastralAnterior = inscricaoCadastralAnterior;
    }

    @Generated
    public void setTrechoInscricaoCadastral(Long trechoInscricaoCadastral) {
        this.trechoInscricaoCadastral = trechoInscricaoCadastral;
    }

    @Generated
    public void setSetorLocalizacao(Setor setorLocalizacao) {
        this.setorLocalizacao = setorLocalizacao;
    }

    @Generated
    public void setSetorInscricaocadastral(String setorInscricaocadastral) {
        this.setorInscricaocadastral = setorInscricaocadastral;
    }

    @Generated
    public void setQuadraLocalizacao(SetorQuadra quadraLocalizacao) {
        this.quadraLocalizacao = quadraLocalizacao;
    }

    @Generated
    public void setQuadraInscricaocadastral(String quadraInscricaocadastral) {
        this.quadraInscricaocadastral = quadraInscricaocadastral;
    }

    @Generated
    public void setLoteLocalizacao(String loteLocalizacao) {
        this.loteLocalizacao = loteLocalizacao;
    }

    @Generated
    public void setDistritoLocalizacao(Distrito distritoLocalizacao) {
        this.distritoLocalizacao = distritoLocalizacao;
    }

    @Generated
    public void setUnidadeLocalizacao(String unidadeLocalizacao) {
        this.unidadeLocalizacao = unidadeLocalizacao;
    }

    @Generated
    public void setDistritoFiscalizacao(String distritoFiscalizacao) {
        this.distritoFiscalizacao = distritoFiscalizacao;
    }

    @Generated
    public void setSetorFiscalizacao(String setorFiscalizacao) {
        this.setorFiscalizacao = setorFiscalizacao;
    }

    @Generated
    public void setTrechoDescr(String trechoDescr) {
        this.trechoDescr = trechoDescr;
    }

    @Generated
    public void setQuadraFiscalizacao(String quadraFiscalizacao) {
        this.quadraFiscalizacao = quadraFiscalizacao;
    }

    @Generated
    public void setLoteFiscalizacao(String loteFiscalizacao) {
        this.loteFiscalizacao = loteFiscalizacao;
    }

    @Generated
    public void setUnidadeFiscalizacao(String unidadeFiscalizacao) {
        this.unidadeFiscalizacao = unidadeFiscalizacao;
    }

    @Generated
    public void setImobiliaria(Imobiliaria imobiliaria) {
        this.imobiliaria = imobiliaria;
    }

    @Generated
    public void setCondominio(Condominio condominio) {
        this.condominio = condominio;
    }

    @Generated
    public void setCondominioCodigo(Long condominioCodigo) {
        this.condominioCodigo = condominioCodigo;
    }

    @Generated
    public void setLoteamento(Loteamento loteamento) {
        this.loteamento = loteamento;
    }

    @Generated
    public void setLoteamentoCodigo(Long loteamentoCodigo) {
        this.loteamentoCodigo = loteamentoCodigo;
    }

    @Generated
    public void setAnoAliquotaProgressiva(Long anoAliquotaProgressiva) {
        this.anoAliquotaProgressiva = anoAliquotaProgressiva;
    }

    @Generated
    public void setAreaLote(BigDecimal areaLote) {
        this.areaLote = areaLote;
    }

    @Generated
    public void setProfundidadeMedia(BigDecimal profundidadeMedia) {
        this.profundidadeMedia = profundidadeMedia;
    }

    @Generated
    public void setAreaTotalConstruida(BigDecimal areaTotalConstruida) {
        this.areaTotalConstruida = areaTotalConstruida;
    }

    @Generated
    public void setLimitaCercaMuro(Boolean limitaCercaMuro) {
        this.limitaCercaMuro = limitaCercaMuro;
    }

    @Generated
    public void setImovelProprio(Boolean imovelProprio) {
        this.imovelProprio = imovelProprio;
    }

    @Generated
    public void setMatricula(String matricula) {
        this.matricula = matricula;
    }

    @Generated
    public void setCartorio(String cartorio) {
        this.cartorio = cartorio;
    }

    @Generated
    public void setDataMatricula(LocalDate dataMatricula) {
        this.dataMatricula = dataMatricula;
    }

    @Generated
    public void setLivro(String livro) {
        this.livro = livro;
    }

    @Generated
    public void setFolha(String folha) {
        this.folha = folha;
    }

    @Generated
    public void setFaceQuadra(String faceQuadra) {
        this.faceQuadra = faceQuadra;
    }

    @Generated
    public void setCaucionado(Boolean caucionado) {
        this.caucionado = caucionado;
    }

    @Generated
    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    @Generated
    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    @Generated
    public void setAreaUnidadeConstruida(BigDecimal areaUnidadeConstruida) {
        this.areaUnidadeConstruida = areaUnidadeConstruida;
    }

    @Generated
    public void setAreaUtilLote(BigDecimal areaUtilLote) {
        this.areaUtilLote = areaUtilLote;
    }

    @Generated
    public void setAreaPrivativa(BigDecimal areaPrivativa) {
        this.areaPrivativa = areaPrivativa;
    }

    @Generated
    public void setAreaComum(BigDecimal areaComum) {
        this.areaComum = areaComum;
    }

    @Generated
    public void setComplementoLote(String complementoLote) {
        this.complementoLote = complementoLote;
    }

    @Generated
    public void setTipoImovel(TipoImovel tipoImovel) {
        this.tipoImovel = tipoImovel;
    }

    @Generated
    public void setNotificacaoAliquotaProgressiva(Long notificacaoAliquotaProgressiva) {
        this.notificacaoAliquotaProgressiva = notificacaoAliquotaProgressiva;
    }

    @Generated
    public void setDataOficioAliquotaProgressiva(LocalDate dataOficioAliquotaProgressiva) {
        this.dataOficioAliquotaProgressiva = dataOficioAliquotaProgressiva;
    }

    @Generated
    public void setTipoLote(TipoLote tipoLote) {
        this.tipoLote = tipoLote;
    }

    @Generated
    public void setQuadriculaLocalizacao(Quadricula quadriculaLocalizacao) {
        this.quadriculaLocalizacao = quadriculaLocalizacao;
    }

    @Generated
    public void setNumeroIncra(String numeroIncra) {
        this.numeroIncra = numeroIncra;
    }

    @Generated
    public void setAreaTotalInscricao(BigDecimal areaTotalInscricao) {
        this.areaTotalInscricao = areaTotalInscricao;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setSituacaoDesapropriado(String situacaoDesapropriado) {
        this.situacaoDesapropriado = situacaoDesapropriado;
    }

    @Generated
    public void setQuadriculaFiscalizacao(String quadriculaFiscalizacao) {
        this.quadriculaFiscalizacao = quadriculaFiscalizacao;
    }

    @Generated
    public void setMemoriaCadastro(MemoriaCadastro memoriaCadastro) {
        this.memoriaCadastro = memoriaCadastro;
    }

    @Generated
    public void setTestadas(List<ImobiliarioTestadaMemoria> testadas) {
        this.testadas = testadas;
    }

    @Generated
    public void setTestadasGenericas(List<ImobiliarioTestadaGenericaMemoria> testadasGenericas) {
        this.testadasGenericas = testadasGenericas;
    }

    @Generated
    public void setCadastroGeralMemoria(CadastroGeralMemoria cadastroGeralMemoria) {
        this.cadastroGeralMemoria = cadastroGeralMemoria;
    }

    @Generated
    public void setAreasVerde(List<ImobiliarioAreaVerdeMemoria> areasVerde) {
        this.areasVerde = areasVerde;
    }

    @Generated
    public void setSegmentos(List<ImobiliarioSegmentoMemoria> segmentos) {
        this.segmentos = segmentos;
    }

    @Generated
    public void setIsencoes(List<CadastroGeralIsencaoMemoria> isencoes) {
        this.isencoes = isencoes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroImobiliarioMemoria)) {
            return false;
        }
        CadastroImobiliarioMemoria other = (CadastroImobiliarioMemoria)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$trechoInscricaoCadastral = this.getTrechoInscricaoCadastral();
        Long other$trechoInscricaoCadastral = other.getTrechoInscricaoCadastral();
        if (this$trechoInscricaoCadastral == null ? other$trechoInscricaoCadastral != null : !((Object)this$trechoInscricaoCadastral).equals(other$trechoInscricaoCadastral)) {
            return false;
        }
        Long this$condominioCodigo = this.getCondominioCodigo();
        Long other$condominioCodigo = other.getCondominioCodigo();
        if (this$condominioCodigo == null ? other$condominioCodigo != null : !((Object)this$condominioCodigo).equals(other$condominioCodigo)) {
            return false;
        }
        Long this$loteamentoCodigo = this.getLoteamentoCodigo();
        Long other$loteamentoCodigo = other.getLoteamentoCodigo();
        if (this$loteamentoCodigo == null ? other$loteamentoCodigo != null : !((Object)this$loteamentoCodigo).equals(other$loteamentoCodigo)) {
            return false;
        }
        Long this$anoAliquotaProgressiva = this.getAnoAliquotaProgressiva();
        Long other$anoAliquotaProgressiva = other.getAnoAliquotaProgressiva();
        if (this$anoAliquotaProgressiva == null ? other$anoAliquotaProgressiva != null : !((Object)this$anoAliquotaProgressiva).equals(other$anoAliquotaProgressiva)) {
            return false;
        }
        Boolean this$limitaCercaMuro = this.getLimitaCercaMuro();
        Boolean other$limitaCercaMuro = other.getLimitaCercaMuro();
        if (this$limitaCercaMuro == null ? other$limitaCercaMuro != null : !((Object)this$limitaCercaMuro).equals(other$limitaCercaMuro)) {
            return false;
        }
        Boolean this$imovelProprio = this.getImovelProprio();
        Boolean other$imovelProprio = other.getImovelProprio();
        if (this$imovelProprio == null ? other$imovelProprio != null : !((Object)this$imovelProprio).equals(other$imovelProprio)) {
            return false;
        }
        Boolean this$caucionado = this.getCaucionado();
        Boolean other$caucionado = other.getCaucionado();
        if (this$caucionado == null ? other$caucionado != null : !((Object)this$caucionado).equals(other$caucionado)) {
            return false;
        }
        Long this$notificacaoAliquotaProgressiva = this.getNotificacaoAliquotaProgressiva();
        Long other$notificacaoAliquotaProgressiva = other.getNotificacaoAliquotaProgressiva();
        if (this$notificacaoAliquotaProgressiva == null ? other$notificacaoAliquotaProgressiva != null : !((Object)this$notificacaoAliquotaProgressiva).equals(other$notificacaoAliquotaProgressiva)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        CadastroGeralMemoriaId this$id = this.getId();
        CadastroGeralMemoriaId other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$inscricaoCadastral = this.getInscricaoCadastral();
        String other$inscricaoCadastral = other.getInscricaoCadastral();
        if (this$inscricaoCadastral == null ? other$inscricaoCadastral != null : !this$inscricaoCadastral.equals(other$inscricaoCadastral)) {
            return false;
        }
        String this$inscricaoCadastralAnterior = this.getInscricaoCadastralAnterior();
        String other$inscricaoCadastralAnterior = other.getInscricaoCadastralAnterior();
        if (this$inscricaoCadastralAnterior == null ? other$inscricaoCadastralAnterior != null : !this$inscricaoCadastralAnterior.equals(other$inscricaoCadastralAnterior)) {
            return false;
        }
        Setor this$setorLocalizacao = this.getSetorLocalizacao();
        Setor other$setorLocalizacao = other.getSetorLocalizacao();
        if (this$setorLocalizacao == null ? other$setorLocalizacao != null : !this$setorLocalizacao.equals(other$setorLocalizacao)) {
            return false;
        }
        String this$setorInscricaocadastral = this.getSetorInscricaocadastral();
        String other$setorInscricaocadastral = other.getSetorInscricaocadastral();
        if (this$setorInscricaocadastral == null ? other$setorInscricaocadastral != null : !this$setorInscricaocadastral.equals(other$setorInscricaocadastral)) {
            return false;
        }
        SetorQuadra this$quadraLocalizacao = this.getQuadraLocalizacao();
        SetorQuadra other$quadraLocalizacao = other.getQuadraLocalizacao();
        if (this$quadraLocalizacao == null ? other$quadraLocalizacao != null : !this$quadraLocalizacao.equals(other$quadraLocalizacao)) {
            return false;
        }
        String this$quadraInscricaocadastral = this.getQuadraInscricaocadastral();
        String other$quadraInscricaocadastral = other.getQuadraInscricaocadastral();
        if (this$quadraInscricaocadastral == null ? other$quadraInscricaocadastral != null : !this$quadraInscricaocadastral.equals(other$quadraInscricaocadastral)) {
            return false;
        }
        String this$loteLocalizacao = this.getLoteLocalizacao();
        String other$loteLocalizacao = other.getLoteLocalizacao();
        if (this$loteLocalizacao == null ? other$loteLocalizacao != null : !this$loteLocalizacao.equals(other$loteLocalizacao)) {
            return false;
        }
        Distrito this$distritoLocalizacao = this.getDistritoLocalizacao();
        Distrito other$distritoLocalizacao = other.getDistritoLocalizacao();
        if (this$distritoLocalizacao == null ? other$distritoLocalizacao != null : !this$distritoLocalizacao.equals(other$distritoLocalizacao)) {
            return false;
        }
        String this$unidadeLocalizacao = this.getUnidadeLocalizacao();
        String other$unidadeLocalizacao = other.getUnidadeLocalizacao();
        if (this$unidadeLocalizacao == null ? other$unidadeLocalizacao != null : !this$unidadeLocalizacao.equals(other$unidadeLocalizacao)) {
            return false;
        }
        String this$distritoFiscalizacao = this.getDistritoFiscalizacao();
        String other$distritoFiscalizacao = other.getDistritoFiscalizacao();
        if (this$distritoFiscalizacao == null ? other$distritoFiscalizacao != null : !this$distritoFiscalizacao.equals(other$distritoFiscalizacao)) {
            return false;
        }
        String this$setorFiscalizacao = this.getSetorFiscalizacao();
        String other$setorFiscalizacao = other.getSetorFiscalizacao();
        if (this$setorFiscalizacao == null ? other$setorFiscalizacao != null : !this$setorFiscalizacao.equals(other$setorFiscalizacao)) {
            return false;
        }
        String this$trechoDescr = this.getTrechoDescr();
        String other$trechoDescr = other.getTrechoDescr();
        if (this$trechoDescr == null ? other$trechoDescr != null : !this$trechoDescr.equals(other$trechoDescr)) {
            return false;
        }
        String this$quadraFiscalizacao = this.getQuadraFiscalizacao();
        String other$quadraFiscalizacao = other.getQuadraFiscalizacao();
        if (this$quadraFiscalizacao == null ? other$quadraFiscalizacao != null : !this$quadraFiscalizacao.equals(other$quadraFiscalizacao)) {
            return false;
        }
        String this$loteFiscalizacao = this.getLoteFiscalizacao();
        String other$loteFiscalizacao = other.getLoteFiscalizacao();
        if (this$loteFiscalizacao == null ? other$loteFiscalizacao != null : !this$loteFiscalizacao.equals(other$loteFiscalizacao)) {
            return false;
        }
        String this$unidadeFiscalizacao = this.getUnidadeFiscalizacao();
        String other$unidadeFiscalizacao = other.getUnidadeFiscalizacao();
        if (this$unidadeFiscalizacao == null ? other$unidadeFiscalizacao != null : !this$unidadeFiscalizacao.equals(other$unidadeFiscalizacao)) {
            return false;
        }
        Imobiliaria this$imobiliaria = this.getImobiliaria();
        Imobiliaria other$imobiliaria = other.getImobiliaria();
        if (this$imobiliaria == null ? other$imobiliaria != null : !this$imobiliaria.equals(other$imobiliaria)) {
            return false;
        }
        Condominio this$condominio = this.getCondominio();
        Condominio other$condominio = other.getCondominio();
        if (this$condominio == null ? other$condominio != null : !this$condominio.equals(other$condominio)) {
            return false;
        }
        Loteamento this$loteamento = this.getLoteamento();
        Loteamento other$loteamento = other.getLoteamento();
        if (this$loteamento == null ? other$loteamento != null : !this$loteamento.equals(other$loteamento)) {
            return false;
        }
        BigDecimal this$areaLote = this.getAreaLote();
        BigDecimal other$areaLote = other.getAreaLote();
        if (this$areaLote == null ? other$areaLote != null : !((Object)this$areaLote).equals(other$areaLote)) {
            return false;
        }
        BigDecimal this$profundidadeMedia = this.getProfundidadeMedia();
        BigDecimal other$profundidadeMedia = other.getProfundidadeMedia();
        if (this$profundidadeMedia == null ? other$profundidadeMedia != null : !((Object)this$profundidadeMedia).equals(other$profundidadeMedia)) {
            return false;
        }
        BigDecimal this$areaTotalConstruida = this.getAreaTotalConstruida();
        BigDecimal other$areaTotalConstruida = other.getAreaTotalConstruida();
        if (this$areaTotalConstruida == null ? other$areaTotalConstruida != null : !((Object)this$areaTotalConstruida).equals(other$areaTotalConstruida)) {
            return false;
        }
        String this$matricula = this.getMatricula();
        String other$matricula = other.getMatricula();
        if (this$matricula == null ? other$matricula != null : !this$matricula.equals(other$matricula)) {
            return false;
        }
        String this$cartorio = this.getCartorio();
        String other$cartorio = other.getCartorio();
        if (this$cartorio == null ? other$cartorio != null : !this$cartorio.equals(other$cartorio)) {
            return false;
        }
        LocalDate this$dataMatricula = this.getDataMatricula();
        LocalDate other$dataMatricula = other.getDataMatricula();
        if (this$dataMatricula == null ? other$dataMatricula != null : !((Object)this$dataMatricula).equals(other$dataMatricula)) {
            return false;
        }
        String this$livro = this.getLivro();
        String other$livro = other.getLivro();
        if (this$livro == null ? other$livro != null : !this$livro.equals(other$livro)) {
            return false;
        }
        String this$folha = this.getFolha();
        String other$folha = other.getFolha();
        if (this$folha == null ? other$folha != null : !this$folha.equals(other$folha)) {
            return false;
        }
        String this$faceQuadra = this.getFaceQuadra();
        String other$faceQuadra = other.getFaceQuadra();
        if (this$faceQuadra == null ? other$faceQuadra != null : !this$faceQuadra.equals(other$faceQuadra)) {
            return false;
        }
        String this$latitude = this.getLatitude();
        String other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !this$latitude.equals(other$latitude)) {
            return false;
        }
        String this$longitude = this.getLongitude();
        String other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !this$longitude.equals(other$longitude)) {
            return false;
        }
        BigDecimal this$areaUnidadeConstruida = this.getAreaUnidadeConstruida();
        BigDecimal other$areaUnidadeConstruida = other.getAreaUnidadeConstruida();
        if (this$areaUnidadeConstruida == null ? other$areaUnidadeConstruida != null : !((Object)this$areaUnidadeConstruida).equals(other$areaUnidadeConstruida)) {
            return false;
        }
        BigDecimal this$areaUtilLote = this.getAreaUtilLote();
        BigDecimal other$areaUtilLote = other.getAreaUtilLote();
        if (this$areaUtilLote == null ? other$areaUtilLote != null : !((Object)this$areaUtilLote).equals(other$areaUtilLote)) {
            return false;
        }
        BigDecimal this$areaPrivativa = this.getAreaPrivativa();
        BigDecimal other$areaPrivativa = other.getAreaPrivativa();
        if (this$areaPrivativa == null ? other$areaPrivativa != null : !((Object)this$areaPrivativa).equals(other$areaPrivativa)) {
            return false;
        }
        BigDecimal this$areaComum = this.getAreaComum();
        BigDecimal other$areaComum = other.getAreaComum();
        if (this$areaComum == null ? other$areaComum != null : !((Object)this$areaComum).equals(other$areaComum)) {
            return false;
        }
        String this$complementoLote = this.getComplementoLote();
        String other$complementoLote = other.getComplementoLote();
        if (this$complementoLote == null ? other$complementoLote != null : !this$complementoLote.equals(other$complementoLote)) {
            return false;
        }
        TipoImovel this$tipoImovel = this.getTipoImovel();
        TipoImovel other$tipoImovel = other.getTipoImovel();
        if (this$tipoImovel == null ? other$tipoImovel != null : !this$tipoImovel.equals(other$tipoImovel)) {
            return false;
        }
        LocalDate this$dataOficioAliquotaProgressiva = this.getDataOficioAliquotaProgressiva();
        LocalDate other$dataOficioAliquotaProgressiva = other.getDataOficioAliquotaProgressiva();
        if (this$dataOficioAliquotaProgressiva == null ? other$dataOficioAliquotaProgressiva != null : !((Object)this$dataOficioAliquotaProgressiva).equals(other$dataOficioAliquotaProgressiva)) {
            return false;
        }
        TipoLote this$tipoLote = this.getTipoLote();
        TipoLote other$tipoLote = other.getTipoLote();
        if (this$tipoLote == null ? other$tipoLote != null : !this$tipoLote.equals(other$tipoLote)) {
            return false;
        }
        Quadricula this$quadriculaLocalizacao = this.getQuadriculaLocalizacao();
        Quadricula other$quadriculaLocalizacao = other.getQuadriculaLocalizacao();
        if (this$quadriculaLocalizacao == null ? other$quadriculaLocalizacao != null : !this$quadriculaLocalizacao.equals(other$quadriculaLocalizacao)) {
            return false;
        }
        String this$numeroIncra = this.getNumeroIncra();
        String other$numeroIncra = other.getNumeroIncra();
        if (this$numeroIncra == null ? other$numeroIncra != null : !this$numeroIncra.equals(other$numeroIncra)) {
            return false;
        }
        BigDecimal this$areaTotalInscricao = this.getAreaTotalInscricao();
        BigDecimal other$areaTotalInscricao = other.getAreaTotalInscricao();
        if (this$areaTotalInscricao == null ? other$areaTotalInscricao != null : !((Object)this$areaTotalInscricao).equals(other$areaTotalInscricao)) {
            return false;
        }
        String this$situacaoDesapropriado = this.getSituacaoDesapropriado();
        String other$situacaoDesapropriado = other.getSituacaoDesapropriado();
        if (this$situacaoDesapropriado == null ? other$situacaoDesapropriado != null : !this$situacaoDesapropriado.equals(other$situacaoDesapropriado)) {
            return false;
        }
        String this$quadriculaFiscalizacao = this.getQuadriculaFiscalizacao();
        String other$quadriculaFiscalizacao = other.getQuadriculaFiscalizacao();
        if (this$quadriculaFiscalizacao == null ? other$quadriculaFiscalizacao != null : !this$quadriculaFiscalizacao.equals(other$quadriculaFiscalizacao)) {
            return false;
        }
        MemoriaCadastro this$memoriaCadastro = this.getMemoriaCadastro();
        MemoriaCadastro other$memoriaCadastro = other.getMemoriaCadastro();
        if (this$memoriaCadastro == null ? other$memoriaCadastro != null : !this$memoriaCadastro.equals(other$memoriaCadastro)) {
            return false;
        }
        List this$testadas = this.getTestadas();
        List other$testadas = other.getTestadas();
        if (this$testadas == null ? other$testadas != null : !((Object)this$testadas).equals(other$testadas)) {
            return false;
        }
        List this$testadasGenericas = this.getTestadasGenericas();
        List other$testadasGenericas = other.getTestadasGenericas();
        if (this$testadasGenericas == null ? other$testadasGenericas != null : !((Object)this$testadasGenericas).equals(other$testadasGenericas)) {
            return false;
        }
        CadastroGeralMemoria this$cadastroGeralMemoria = this.getCadastroGeralMemoria();
        CadastroGeralMemoria other$cadastroGeralMemoria = other.getCadastroGeralMemoria();
        if (this$cadastroGeralMemoria == null ? other$cadastroGeralMemoria != null : !this$cadastroGeralMemoria.equals(other$cadastroGeralMemoria)) {
            return false;
        }
        List this$areasVerde = this.getAreasVerde();
        List other$areasVerde = other.getAreasVerde();
        if (this$areasVerde == null ? other$areasVerde != null : !((Object)this$areasVerde).equals(other$areasVerde)) {
            return false;
        }
        List this$segmentos = this.getSegmentos();
        List other$segmentos = other.getSegmentos();
        if (this$segmentos == null ? other$segmentos != null : !((Object)this$segmentos).equals(other$segmentos)) {
            return false;
        }
        List this$profundidades = this.getProfundidades();
        List other$profundidades = other.getProfundidades();
        if (this$profundidades == null ? other$profundidades != null : !((Object)this$profundidades).equals(other$profundidades)) {
            return false;
        }
        List this$situacoes = this.getSituacoes();
        List other$situacoes = other.getSituacoes();
        if (this$situacoes == null ? other$situacoes != null : !((Object)this$situacoes).equals(other$situacoes)) {
            return false;
        }
        List this$isencoes = this.getIsencoes();
        List other$isencoes = other.getIsencoes();
        return !(this$isencoes == null ? other$isencoes != null : !((Object)this$isencoes).equals(other$isencoes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroImobiliarioMemoria;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $trechoInscricaoCadastral = this.getTrechoInscricaoCadastral();
        result = result * 59 + ($trechoInscricaoCadastral == null ? 43 : ((Object)$trechoInscricaoCadastral).hashCode());
        Long $condominioCodigo = this.getCondominioCodigo();
        result = result * 59 + ($condominioCodigo == null ? 43 : ((Object)$condominioCodigo).hashCode());
        Long $loteamentoCodigo = this.getLoteamentoCodigo();
        result = result * 59 + ($loteamentoCodigo == null ? 43 : ((Object)$loteamentoCodigo).hashCode());
        Long $anoAliquotaProgressiva = this.getAnoAliquotaProgressiva();
        result = result * 59 + ($anoAliquotaProgressiva == null ? 43 : ((Object)$anoAliquotaProgressiva).hashCode());
        Boolean $limitaCercaMuro = this.getLimitaCercaMuro();
        result = result * 59 + ($limitaCercaMuro == null ? 43 : ((Object)$limitaCercaMuro).hashCode());
        Boolean $imovelProprio = this.getImovelProprio();
        result = result * 59 + ($imovelProprio == null ? 43 : ((Object)$imovelProprio).hashCode());
        Boolean $caucionado = this.getCaucionado();
        result = result * 59 + ($caucionado == null ? 43 : ((Object)$caucionado).hashCode());
        Long $notificacaoAliquotaProgressiva = this.getNotificacaoAliquotaProgressiva();
        result = result * 59 + ($notificacaoAliquotaProgressiva == null ? 43 : ((Object)$notificacaoAliquotaProgressiva).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        CadastroGeralMemoriaId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $inscricaoCadastral = this.getInscricaoCadastral();
        result = result * 59 + ($inscricaoCadastral == null ? 43 : $inscricaoCadastral.hashCode());
        String $inscricaoCadastralAnterior = this.getInscricaoCadastralAnterior();
        result = result * 59 + ($inscricaoCadastralAnterior == null ? 43 : $inscricaoCadastralAnterior.hashCode());
        Setor $setorLocalizacao = this.getSetorLocalizacao();
        result = result * 59 + ($setorLocalizacao == null ? 43 : $setorLocalizacao.hashCode());
        String $setorInscricaocadastral = this.getSetorInscricaocadastral();
        result = result * 59 + ($setorInscricaocadastral == null ? 43 : $setorInscricaocadastral.hashCode());
        SetorQuadra $quadraLocalizacao = this.getQuadraLocalizacao();
        result = result * 59 + ($quadraLocalizacao == null ? 43 : $quadraLocalizacao.hashCode());
        String $quadraInscricaocadastral = this.getQuadraInscricaocadastral();
        result = result * 59 + ($quadraInscricaocadastral == null ? 43 : $quadraInscricaocadastral.hashCode());
        String $loteLocalizacao = this.getLoteLocalizacao();
        result = result * 59 + ($loteLocalizacao == null ? 43 : $loteLocalizacao.hashCode());
        Distrito $distritoLocalizacao = this.getDistritoLocalizacao();
        result = result * 59 + ($distritoLocalizacao == null ? 43 : $distritoLocalizacao.hashCode());
        String $unidadeLocalizacao = this.getUnidadeLocalizacao();
        result = result * 59 + ($unidadeLocalizacao == null ? 43 : $unidadeLocalizacao.hashCode());
        String $distritoFiscalizacao = this.getDistritoFiscalizacao();
        result = result * 59 + ($distritoFiscalizacao == null ? 43 : $distritoFiscalizacao.hashCode());
        String $setorFiscalizacao = this.getSetorFiscalizacao();
        result = result * 59 + ($setorFiscalizacao == null ? 43 : $setorFiscalizacao.hashCode());
        String $trechoDescr = this.getTrechoDescr();
        result = result * 59 + ($trechoDescr == null ? 43 : $trechoDescr.hashCode());
        String $quadraFiscalizacao = this.getQuadraFiscalizacao();
        result = result * 59 + ($quadraFiscalizacao == null ? 43 : $quadraFiscalizacao.hashCode());
        String $loteFiscalizacao = this.getLoteFiscalizacao();
        result = result * 59 + ($loteFiscalizacao == null ? 43 : $loteFiscalizacao.hashCode());
        String $unidadeFiscalizacao = this.getUnidadeFiscalizacao();
        result = result * 59 + ($unidadeFiscalizacao == null ? 43 : $unidadeFiscalizacao.hashCode());
        Imobiliaria $imobiliaria = this.getImobiliaria();
        result = result * 59 + ($imobiliaria == null ? 43 : $imobiliaria.hashCode());
        Condominio $condominio = this.getCondominio();
        result = result * 59 + ($condominio == null ? 43 : $condominio.hashCode());
        Loteamento $loteamento = this.getLoteamento();
        result = result * 59 + ($loteamento == null ? 43 : $loteamento.hashCode());
        BigDecimal $areaLote = this.getAreaLote();
        result = result * 59 + ($areaLote == null ? 43 : ((Object)$areaLote).hashCode());
        BigDecimal $profundidadeMedia = this.getProfundidadeMedia();
        result = result * 59 + ($profundidadeMedia == null ? 43 : ((Object)$profundidadeMedia).hashCode());
        BigDecimal $areaTotalConstruida = this.getAreaTotalConstruida();
        result = result * 59 + ($areaTotalConstruida == null ? 43 : ((Object)$areaTotalConstruida).hashCode());
        String $matricula = this.getMatricula();
        result = result * 59 + ($matricula == null ? 43 : $matricula.hashCode());
        String $cartorio = this.getCartorio();
        result = result * 59 + ($cartorio == null ? 43 : $cartorio.hashCode());
        LocalDate $dataMatricula = this.getDataMatricula();
        result = result * 59 + ($dataMatricula == null ? 43 : ((Object)$dataMatricula).hashCode());
        String $livro = this.getLivro();
        result = result * 59 + ($livro == null ? 43 : $livro.hashCode());
        String $folha = this.getFolha();
        result = result * 59 + ($folha == null ? 43 : $folha.hashCode());
        String $faceQuadra = this.getFaceQuadra();
        result = result * 59 + ($faceQuadra == null ? 43 : $faceQuadra.hashCode());
        String $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : $latitude.hashCode());
        String $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : $longitude.hashCode());
        BigDecimal $areaUnidadeConstruida = this.getAreaUnidadeConstruida();
        result = result * 59 + ($areaUnidadeConstruida == null ? 43 : ((Object)$areaUnidadeConstruida).hashCode());
        BigDecimal $areaUtilLote = this.getAreaUtilLote();
        result = result * 59 + ($areaUtilLote == null ? 43 : ((Object)$areaUtilLote).hashCode());
        BigDecimal $areaPrivativa = this.getAreaPrivativa();
        result = result * 59 + ($areaPrivativa == null ? 43 : ((Object)$areaPrivativa).hashCode());
        BigDecimal $areaComum = this.getAreaComum();
        result = result * 59 + ($areaComum == null ? 43 : ((Object)$areaComum).hashCode());
        String $complementoLote = this.getComplementoLote();
        result = result * 59 + ($complementoLote == null ? 43 : $complementoLote.hashCode());
        TipoImovel $tipoImovel = this.getTipoImovel();
        result = result * 59 + ($tipoImovel == null ? 43 : $tipoImovel.hashCode());
        LocalDate $dataOficioAliquotaProgressiva = this.getDataOficioAliquotaProgressiva();
        result = result * 59 + ($dataOficioAliquotaProgressiva == null ? 43 : ((Object)$dataOficioAliquotaProgressiva).hashCode());
        TipoLote $tipoLote = this.getTipoLote();
        result = result * 59 + ($tipoLote == null ? 43 : $tipoLote.hashCode());
        Quadricula $quadriculaLocalizacao = this.getQuadriculaLocalizacao();
        result = result * 59 + ($quadriculaLocalizacao == null ? 43 : $quadriculaLocalizacao.hashCode());
        String $numeroIncra = this.getNumeroIncra();
        result = result * 59 + ($numeroIncra == null ? 43 : $numeroIncra.hashCode());
        BigDecimal $areaTotalInscricao = this.getAreaTotalInscricao();
        result = result * 59 + ($areaTotalInscricao == null ? 43 : ((Object)$areaTotalInscricao).hashCode());
        String $situacaoDesapropriado = this.getSituacaoDesapropriado();
        result = result * 59 + ($situacaoDesapropriado == null ? 43 : $situacaoDesapropriado.hashCode());
        String $quadriculaFiscalizacao = this.getQuadriculaFiscalizacao();
        result = result * 59 + ($quadriculaFiscalizacao == null ? 43 : $quadriculaFiscalizacao.hashCode());
        MemoriaCadastro $memoriaCadastro = this.getMemoriaCadastro();
        result = result * 59 + ($memoriaCadastro == null ? 43 : $memoriaCadastro.hashCode());
        List $testadas = this.getTestadas();
        result = result * 59 + ($testadas == null ? 43 : ((Object)$testadas).hashCode());
        List $testadasGenericas = this.getTestadasGenericas();
        result = result * 59 + ($testadasGenericas == null ? 43 : ((Object)$testadasGenericas).hashCode());
        CadastroGeralMemoria $cadastroGeralMemoria = this.getCadastroGeralMemoria();
        result = result * 59 + ($cadastroGeralMemoria == null ? 43 : $cadastroGeralMemoria.hashCode());
        List $areasVerde = this.getAreasVerde();
        result = result * 59 + ($areasVerde == null ? 43 : ((Object)$areasVerde).hashCode());
        List $segmentos = this.getSegmentos();
        result = result * 59 + ($segmentos == null ? 43 : ((Object)$segmentos).hashCode());
        List $profundidades = this.getProfundidades();
        result = result * 59 + ($profundidades == null ? 43 : ((Object)$profundidades).hashCode());
        List $situacoes = this.getSituacoes();
        result = result * 59 + ($situacoes == null ? 43 : ((Object)$situacoes).hashCode());
        List $isencoes = this.getIsencoes();
        result = result * 59 + ($isencoes == null ? 43 : ((Object)$isencoes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CadastroImobiliarioMemoria(super=" + super.toString() + ")";
    }
}

