/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.config;

import br.com.elotech.client.EnableElotechFeignClients;
import br.com.elotech.multitenant.EnableMultiTenant;
import br.com.elotech.multitenant.client.TenantClient;
import br.com.elotech.tributos.config.TributosMultiTenantConfiguration;
import br.com.elotech.tributos.security.AsyncTenantFilter;
import br.com.elotech.tributos.service.impl.EntidadeServiceImpl;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;

@EnableMultiTenant
@EnableElotechFeignClients
@Configuration
@ConditionalOnProperty(name={"multitenant.enabled"}, havingValue="true")
public class TributosMultiTenantConfiguration {
    @Bean
    @ConditionalOnProperty(name={"multitenant.database-initializer.enabled"}, matchIfMissing=true, havingValue="true")
    public DatabaseInitializer databaseInitializer(TenantClient tenantClient, EntidadeServiceImpl entidadeService) {
        return new DatabaseInitializer(tenantClient, entidadeService);
    }

    @Bean
    public FilterRegistrationBean<AsyncTenantFilter> asyncTenantFilter(TenantClient tenantClient) {
        AsyncTenantFilter filter = new AsyncTenantFilter(tenantClient);
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        registrationBean.setEnabled(true);
        registrationBean.setDispatcherTypes(DispatcherType.ASYNC, new DispatcherType[0]);
        registrationBean.setOrder(SecurityWebFiltersOrder.FIRST.getOrder());
        return registrationBean;
    }
}

