/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.config;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.Converter;
import org.apache.commons.lang3.ClassUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

@Configuration
@ComponentScan(basePackages={"br.com.elotech.core.converter"})
public class ConverterConfiguration
implements HibernatePropertiesCustomizer {
    public void customize(Map<String, Object> hibernateProperties) {
        hibernateProperties.put("hibernate.ejb.loaded.classes", this.getConverterClasses());
    }

    public List<Class<?>> getConverterClasses() {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Converter.class));
        return scanner.findCandidateComponents("br.com.elotech.core.converter").stream().map(BeanDefinition::getBeanClassName).map(className -> {
            try {
                return ClassUtils.getClass((String)className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }
}

