/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import br.com.elotech.tributos.calculo.dto.AuxiliaresCalculoDTO;
import br.com.elotech.tributos.calculo.dto.ParametroTesteScriptDTO;
import br.com.elotech.tributos.calculo.service.CalculoProjetoService;
import br.com.elotech.tributos.domain.calculo.CalculoProjeto;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/calculo-projeto"})
public class CalculoProjetoResource
extends CrudResource<CalculoProjeto, Long> {
    private final CalculoProjetoService calculoProjetoService;

    public CalculoProjetoResource(CalculoProjetoService calculoProjetoService) {
        this.calculoProjetoService = calculoProjetoService;
    }

    @GetMapping(value={"/auxiliares"})
    public ResponseEntity<AuxiliaresCalculoDTO> getAuxiliares(@RequestParam Long exercicio) {
        return ResponseEntity.ok((Object)this.calculoProjetoService.getAuxiliares(exercicio));
    }

    @PostMapping(value={"/teste-script"})
    public ResponseEntity<CalculoCadastro> testarScript(@RequestBody ParametroTesteScriptDTO parametroCalculoDTO) {
        return ResponseEntity.ok((Object)this.calculoProjetoService.testarScript(parametroCalculoDTO));
    }
}

