/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.repository;

import br.com.elotech.tributos.calculo.domain.TipoCampoDinamico;
import br.com.elotech.tributos.calculo.dto.CampoDinamicoScriptDTO;
import br.com.elotech.tributos.calculo.dto.RespostaDTO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class CadastroCalculoRepositoryUtils {
    private CadastroCalculoRepositoryUtils() {
    }

    public static String buildFiltroCampoDinamico(TipoCampoDinamico tipoCampoDinamico, Set<CampoDinamicoScriptDTO> camposDinamicos) {
        return camposDinamicos.stream().filter(campoDinamicoScriptDTO -> campoDinamicoScriptDTO.getTipo().equals((Object)tipoCampoDinamico)).map(campoDinamicoScriptDTO -> String.format("'%s'", campoDinamicoScriptDTO.getCampo())).collect(Collectors.joining(","));
    }

    public static Map<String, RespostaDTO> parseBoletim(List<RespostaDTO> respostas) {
        HashMap<String, RespostaDTO> results = new HashMap<String, RespostaDTO>();
        if (Objects.nonNull(respostas)) {
            respostas.forEach(resposta -> results.put(resposta.getIdentificador(), (RespostaDTO)resposta));
        }
        return results;
    }
}

