/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.supersimples.solicitacao.importacao;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoVarredura;
import br.com.elotech.tributos.enums.supersimples.TipoOperacaoSuperSimplesSolicitacao;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.supersimples.ProcessamentoSuperSimplesJobStarter;
import br.com.elotech.tributos.service.supersimples.SuperSimplesSolicitacaoService;
import br.com.elotech.tributos.service.supersimples.SuperSimplesSolicitacaoVarreduraService;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.stereotype.Component;

@Component
public class ImportacaoSuperSimplesJobListener
extends JobExecutionListenerSupport {
    private final SuperSimplesSolicitacaoService superSimplesSolicitacaoService;
    private final SuperSimplesSolicitacaoVarreduraService superSimplesSolicitacaoVarreduraService;
    private final ProcessamentoSuperSimplesJobStarter processamentoSuperSimplesJobStarter;
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private final NotificacaoService notificacaoService;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long idSolicitacao = jobExecution.getJobParameters().getLong("idSolicitacao");
        this.superSimplesSolicitacaoService.iniciarImportacao(idSolicitacao);
        Optional notificacaoId = this.notificacaoService.send(String.format("Iniciada a importa\u00e7\u00e3o do arquivo do Super Simples %d.", idSolicitacao), null, jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long idSolicitacao = jobExecution.getJobParameters().getLong("idSolicitacao");
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.superSimplesSolicitacaoService.finalizarImportacaoSucesso(idSolicitacao);
            this.notificacaoService.send(String.format("Finalizada a importa\u00e7\u00e3o do arquivo do Super Simples %d.", idSolicitacao), null, jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
            try {
                this.gerarArquivoVedadosInicial(idSolicitacao);
            }
            catch (JobParametersInvalidException | JobExecutionAlreadyRunningException | JobInstanceAlreadyCompleteException | JobRestartException e) {
                throw new RuntimeException(e);
            }
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.superSimplesSolicitacaoService.finalizarImportacaoErro(idSolicitacao);
            this.notificacaoService.send(String.format("Ocorreu um erro na importa\u00e7\u00e3o do arquivo do Super Simples %d.", idSolicitacao), null, jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    private void gerarArquivoVedadosInicial(Long idSolicitacao) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        SuperSimplesSolicitacaoVarredura superSimplesSolicitacaoVarredura = this.superSimplesSolicitacaoVarreduraService.createVarredura(idSolicitacao, SecurityUtils.getUserAise(), TipoOperacaoSuperSimplesSolicitacao.INICIAL);
        this.processamentoSuperSimplesJobStarter.startJob(superSimplesSolicitacaoVarredura);
    }

    @Generated
    public ImportacaoSuperSimplesJobListener(SuperSimplesSolicitacaoService superSimplesSolicitacaoService, SuperSimplesSolicitacaoVarreduraService superSimplesSolicitacaoVarreduraService, ProcessamentoSuperSimplesJobStarter processamentoSuperSimplesJobStarter, NotificacaoService notificacaoService) {
        this.superSimplesSolicitacaoService = superSimplesSolicitacaoService;
        this.superSimplesSolicitacaoVarreduraService = superSimplesSolicitacaoVarreduraService;
        this.processamentoSuperSimplesJobStarter = processamentoSuperSimplesJobStarter;
        this.notificacaoService = notificacaoService;
    }
}

