/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.estornoatualizacaomonetariada;

import br.com.elotech.tributos.domain.CreditoContribuinteItem;
import br.com.elotech.tributos.domain.simam.EstornoAtualizacaoMonetariaCreditoCreditoDA;
import br.com.elotech.tributos.domain.simam.EstornoAtualizacaoMonetariaCreditoCreditoDAId;
import br.com.elotech.tributos.domain.simam.EstornoAtualizacaoMonetariaCreditoDA;
import br.com.elotech.tributos.domain.simam.EstornoAtualizacaoMonetariaCreditoParcelamentoDA;
import br.com.elotech.tributos.domain.simam.EstornoAtualizacaoMonetariaCreditoParcelamentoDAId;
import br.com.elotech.tributos.domain.simam.EstornoAtualizacaoMonetariaPagamentoDA;
import br.com.elotech.tributos.domain.simam.EstornoAtualizacaoMonetariaPagamentoDAId;
import br.com.elotech.tributos.domain.simam.EstornoTipoAtualizacaoMonetariaCreditoDA;
import br.com.elotech.tributos.dto.simam.EstornoAtualizacaoMonetariaCreditoDAConsultaDTO;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.simam.EstAtualizacaoMonCreditoDACustomRepository;
import br.com.elotech.tributos.repository.simam.EstornoAtualizacaoMonetariaCreditoDARepository;
import br.com.elotech.tributos.util.DateUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class EstornoAtualizacaoMonetariaCreditoDABatchProcessor
implements ItemProcessor<EstornoAtualizacaoMonetariaCreditoDAConsultaDTO, EstornoTipoAtualizacaoMonetariaCreditoDA> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EstornoAtualizacaoMonetariaCreditoDABatchProcessor.class);
    private static final String PREFIXO = "SIM-AM - Estorno Atualiza\u00e7\u00e3o Monet\u00e1ria da D\u00edvida Ativa - ";
    private final AtomicLong ultimoNrEstorno = new AtomicLong(0L);
    private final EntityManager entityManager;
    private final Map<String, Long> cargaExistente = new ConcurrentHashMap();
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final EstornoAtualizacaoMonetariaCreditoDARepository estornoAtualizacaoMonetariaCreditoDARepository;
    private final EstAtualizacaoMonCreditoDACustomRepository estAtualizacaoMonCreditoDACustomRepository;
    private final ObjectMapper objectMapper;
    private Long nrAnoEstorno;
    private StepExecution stepExecution;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        LOGGER.info("SIM-AM - Estorno Atualiza\u00e7\u00e3o Monet\u00e1ria da D\u00edvida Ativa - Iniciando gera\u00e7\u00e3o de dados");
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        Long entidade = Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getLong("entidade"));
        LOGGER.info("SIM-AM - Estorno Atualiza\u00e7\u00e3o Monet\u00e1ria da D\u00edvida Ativa - Iniciando gera\u00e7\u00e3o de dados - data inicial: {}, data final: {}, entidade: {} ", new Object[]{dataInicial, dataFinal, entidade});
        this.nrAnoEstorno = dataInicial.getYear();
        LOGGER.info("SIM-AM - Estorno Atualiza\u00e7\u00e3o Monet\u00e1ria da D\u00edvida Ativa - Atualizando \u00faltimo NrAtualizacao");
        this.ultimoNrEstorno.set(this.estornoAtualizacaoMonetariaCreditoDARepository.findNextNrEstornoByExercicio(Long.valueOf(dataInicial.getYear())));
        LOGGER.info("SIM-AM - Estorno Atualiza\u00e7\u00e3o Monet\u00e1ria da D\u00edvida Ativa - load da carga existente");
        this.estAtualizacaoMonCreditoDACustomRepository.getCargaExistente(dataInicial, dataFinal).forEach(item -> this.cargaExistente.put(item.getChave(), item.getIdTceAtualizamoneCredDAEst()));
    }

    public EstornoTipoAtualizacaoMonetariaCreditoDA process(EstornoAtualizacaoMonetariaCreditoDAConsultaDTO item) {
        String chave = String.format("%d-%d-%s-%d-%d-%d", item.getNrAtualizacao(), item.getNrAnoAtualizacao(), item.getDtEstorno().toString(), item.getIdAto(), item.getIdTipoAtualizacaoCredito(), item.getIdTipoCredito());
        Long finalId = this.cargaExistente.compute(chave, (k, v) -> {
            if (Objects.nonNull(v)) {
                return v;
            }
            Long nextId = this.sequenceGeneratorRepository.getNextVal("s_estornoatualizamonecredda_id");
            EstornoAtualizacaoMonetariaCreditoDA atualizacao = new EstornoAtualizacaoMonetariaCreditoDA();
            atualizacao.setId(nextId);
            atualizacao.setNrEstorno(Long.valueOf(this.ultimoNrEstorno.getAndIncrement()));
            atualizacao.setNrAnoEstorno(this.nrAnoEstorno);
            atualizacao.setNrAtualizacao(item.getNrAtualizacao());
            atualizacao.setNrAnoAtualizacao(item.getNrAnoAtualizacao());
            atualizacao.setCdControleLeiAto(item.getIdAto());
            atualizacao.setDtEstorno(item.getDtEstorno());
            atualizacao.setDsMotivo(item.getDsMotivo());
            atualizacao.setVlEstorno(item.getVlEstorno());
            atualizacao.setIdTipoAtualizacaoCredito(item.getIdTipoAtualizacaoCredito());
            atualizacao.setIdTipoCredito(item.getIdTipoCredito());
            this.estornoAtualizacaoMonetariaCreditoDARepository.saveAndFlush((Object)atualizacao);
            return nextId;
        });
        if (!Objects.equals(item.getIdCreditoContribuinteItem(), 0L)) {
            EstornoAtualizacaoMonetariaCreditoCreditoDAId id = new EstornoAtualizacaoMonetariaCreditoCreditoDAId();
            id.setAtualizacaoMonetariaCreditoDA((EstornoAtualizacaoMonetariaCreditoDA)this.entityManager.getReference(EstornoAtualizacaoMonetariaCreditoDA.class, (Object)finalId));
            id.setIdCreditoContribuinteItem((CreditoContribuinteItem)this.entityManager.getReference(CreditoContribuinteItem.class, (Object)item.getIdCreditoContribuinteItem()));
            id.setIdDebitoParcelaReceita(item.getIdDebitoParcelaReceita());
            return new EstornoAtualizacaoMonetariaCreditoCreditoDA(id, item.getVlEstorno());
        }
        if (!Objects.equals(item.getIdPagamentoBloqueto(), 0L)) {
            EstornoAtualizacaoMonetariaPagamentoDAId id = new EstornoAtualizacaoMonetariaPagamentoDAId();
            id.setEstornoAtualizacaoMonetariaCreditoDA((EstornoAtualizacaoMonetariaCreditoDA)this.entityManager.getReference(EstornoAtualizacaoMonetariaCreditoDA.class, (Object)finalId));
            id.setIdDebitoParcelaReceita(item.getIdDebitoParcelaReceita());
            id.setIdPagamentoBloqueto(item.getIdPagamentoBloqueto());
            return new EstornoAtualizacaoMonetariaPagamentoDA(id, item.getVlEstorno());
        }
        EstornoAtualizacaoMonetariaCreditoParcelamentoDAId id = new EstornoAtualizacaoMonetariaCreditoParcelamentoDAId();
        id.setIdParcelamento(item.getIdParcelamento());
        id.setIdEstornoParcelamento(item.getIdEstornoParcelamento());
        id.setEstornoAtualizacaoMonetariaCreditoDA((EstornoAtualizacaoMonetariaCreditoDA)this.entityManager.getReference(EstornoAtualizacaoMonetariaCreditoDA.class, (Object)finalId));
        id.setIdDebitoParcelaReceita(item.getIdDebitoParcelaReceita());
        return new EstornoAtualizacaoMonetariaCreditoParcelamentoDA(id, item.getVlEstorno());
    }

    @OnProcessError
    public void onProcessError(EstornoAtualizacaoMonetariaCreditoDAConsultaDTO item, Exception e) throws JsonProcessingException {
        LOGGER.error("SIM-AM - Estorno Atualiza\u00e7\u00e3o Monet\u00e1ria da D\u00edvida Ativa - Erro: {}\n{})", (Object)e.getMessage(), (Object)this.objectMapper.writeValueAsString((Object)item));
    }

    @Generated
    public EstornoAtualizacaoMonetariaCreditoDABatchProcessor(EntityManager entityManager, SequenceGeneratorRepository sequenceGeneratorRepository, EstornoAtualizacaoMonetariaCreditoDARepository estornoAtualizacaoMonetariaCreditoDARepository, EstAtualizacaoMonCreditoDACustomRepository estAtualizacaoMonCreditoDACustomRepository, ObjectMapper objectMapper) {
        this.entityManager = entityManager;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.estornoAtualizacaoMonetariaCreditoDARepository = estornoAtualizacaoMonetariaCreditoDARepository;
        this.estAtualizacaoMonCreditoDACustomRepository = estAtualizacaoMonCreditoDACustomRepository;
        this.objectMapper = objectMapper;
    }
}

