/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.relatoriogerencialarrecadacao.lancamentoarrecadacaoiss;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.service.NotificacaoService;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class LancamentoArrecadacaoIssJobListener
extends JobExecutionListenerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LancamentoArrecadacaoIssJobListener.class);
    private final NotificacaoService notificacaoService;
    private static final String ID_NOTIFICACAO = "idNotificacao";

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long exercicio = jobExecution.getJobParameters().getLong("exercicio");
        Long mes = jobExecution.getJobParameters().getLong("mes");
        String notificacao = String.format("Iniciada a atualiza\u00e7\u00e3o do lan\u00e7amento x arrecada\u00e7\u00e3o ISS por per\u00edodo referente a %d/%d", mes, exercicio);
        Optional notificacaoId = this.notificacaoService.send(notificacao, null, jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        NotificationStatus status;
        super.afterJob(jobExecution);
        Long exercicio = jobExecution.getJobParameters().getLong("exercicio");
        Long mes = jobExecution.getJobParameters().getLong("mes");
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        String notificacao = "";
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            notificacao = String.format("Finalizada a atualiza\u00e7\u00e3o do lan\u00e7amento x arrecada\u00e7\u00e3o ISS referente ao per\u00edodo %d/%d", mes, exercicio);
            status = NotificationStatus.COMPLETED;
        } else {
            notificacao = String.format("Ocorreu um erro na atualiza\u00e7\u00e3o do lan\u00e7amento x arrecada\u00e7\u00e3o ISS referente ao per\u00edodo %d/%d", mes, exercicio);
            status = NotificationStatus.FAILED;
        }
        this.notificacaoService.send(notificacao, null, jobExecution, Optional.of(notificacaoId), status);
    }

    @Generated
    public LancamentoArrecadacaoIssJobListener(NotificacaoService notificacaoService) {
        this.notificacaoService = notificacaoService;
    }
}

