/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.ws.mapper.impl;

import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.dto.mobile.DebitoMobileDTO;
import br.com.elotech.tributos.dto.mobile.DebitoParcelaMobileDTO;
import br.com.elotech.tributos.ws.rest.dto.DebitoCarneAiseDTO;
import br.com.elotech.tributos.ws.rest.dto.DebitoCarneResponseDTO;
import br.com.elotech.tributos.ws.rest.dto.DebitoMapper;
import br.com.elotech.tributos.ws.rest.dto.DebitoResponseDTO;
import br.com.elotech.tributos.ws.rest.dto.ParcelaMapper;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class DebitoMapperImpl
implements DebitoMapper {
    private final ParcelaMapper parcelaMapper;

    public DebitoMapperImpl(ParcelaMapper parcelaMapper) {
        this.parcelaMapper = parcelaMapper;
    }

    public DebitoDTO toDebitoDTO(DebitoResponseDTO debitoResponseDTO) {
        if (debitoResponseDTO == null) {
            return null;
        }
        DebitoDTO debitoDTO = new DebitoDTO();
        debitoDTO.setCadastroGeral(debitoResponseDTO.getCadastroGeral());
        debitoDTO.setDescricaoGuia(debitoResponseDTO.getDescricaoGuia());
        debitoDTO.setEntidade(debitoResponseDTO.getEntidade());
        debitoDTO.setExercicio(debitoResponseDTO.getExercicio());
        debitoDTO.setGuiaRecolhimento(debitoResponseDTO.getGuiaRecolhimento());
        debitoDTO.setNome(debitoResponseDTO.getNome());
        debitoDTO.setPessoa(debitoResponseDTO.getPessoa());
        debitoDTO.setSubDivida(debitoResponseDTO.getSubDivida());
        debitoDTO.setTipoCadastro(debitoResponseDTO.getTipoCadastro());
        debitoDTO.setValor(debitoResponseDTO.getValor());
        debitoDTO.setDescricaoSituacao(debitoResponseDTO.getDescricaoSituacao());
        debitoDTO.setEmiteBloqueto(debitoResponseDTO.getEmiteBloqueto());
        if (debitoResponseDTO.getParcela() != null) {
            debitoDTO.setParcela(Long.valueOf(debitoResponseDTO.getParcela().longValue()));
        }
        debitoDTO.setSituacao(debitoResponseDTO.getSituacao());
        debitoDTO.setVencimento(debitoResponseDTO.getVencimento());
        if (debitoResponseDTO.getIdParcelamento() != null) {
            debitoDTO.setIdParcelamento(Long.valueOf(debitoResponseDTO.getIdParcelamento().longValue()));
        }
        if (debitoResponseDTO.getNumeroContrato() != null) {
            debitoDTO.setNumeroContrato(Long.valueOf(debitoResponseDTO.getNumeroContrato().longValue()));
        }
        debitoDTO.setAnoContrato(debitoResponseDTO.getAnoContrato());
        debitoDTO.setTipoContrato(debitoResponseDTO.getTipoContrato());
        debitoDTO.setProprio(debitoResponseDTO.getProprio());
        debitoDTO.setIdDebito(debitoResponseDTO.getIdDebito());
        debitoDTO.setValorJuros(debitoResponseDTO.getValorJuros());
        debitoDTO.setValorMulta(debitoResponseDTO.getValorMulta());
        debitoDTO.setValorCorrecao(debitoResponseDTO.getValorCorrecao());
        debitoDTO.setValorPrincipal(debitoResponseDTO.getValorPrincipal());
        debitoDTO.setValorDescontoPrincipal(debitoResponseDTO.getValorDesconto());
        debitoDTO.setDataLancamento(debitoResponseDTO.getDataLancamento());
        debitoDTO.setSituacaoLegal(debitoResponseDTO.getSituacaoLegal());
        return debitoDTO;
    }

    public DebitoResponseDTO toDebitoDelphiDTO(DebitoDTO debitoDTO) {
        if (debitoDTO == null) {
            return null;
        }
        DebitoResponseDTO debitoResponseDTO = new DebitoResponseDTO();
        debitoResponseDTO.setCadastroGeral(debitoDTO.getCadastroGeral());
        debitoResponseDTO.setDescricaoGuia(debitoDTO.getDescricaoGuia());
        debitoResponseDTO.setEntidade(debitoDTO.getEntidade());
        debitoResponseDTO.setExercicio(debitoDTO.getExercicio());
        debitoResponseDTO.setGuiaRecolhimento(debitoDTO.getGuiaRecolhimento());
        debitoResponseDTO.setNome(debitoDTO.getNome());
        debitoResponseDTO.setPessoa(debitoDTO.getPessoa());
        debitoResponseDTO.setSubDivida(debitoDTO.getSubDivida());
        debitoResponseDTO.setTipoCadastro(debitoDTO.getTipoCadastro());
        debitoResponseDTO.setValor(debitoDTO.getValor());
        debitoResponseDTO.setDescricaoSituacao(debitoDTO.getDescricaoSituacao());
        debitoResponseDTO.setEmiteBloqueto(debitoDTO.getEmiteBloqueto());
        debitoResponseDTO.setProprio(debitoDTO.getProprio());
        if (debitoDTO.getParcela() != null) {
            debitoResponseDTO.setParcela(Integer.valueOf(debitoDTO.getParcela().intValue()));
        }
        debitoResponseDTO.setSituacao(debitoDTO.getSituacao());
        debitoResponseDTO.setVencimento(debitoDTO.getVencimento());
        if (debitoDTO.getIdParcelamento() != null) {
            debitoResponseDTO.setIdParcelamento(Integer.valueOf(debitoDTO.getIdParcelamento().intValue()));
        }
        if (debitoDTO.getNumeroContrato() != null) {
            debitoResponseDTO.setNumeroContrato(Integer.valueOf(debitoDTO.getNumeroContrato().intValue()));
        }
        debitoResponseDTO.setAnoContrato(debitoDTO.getAnoContrato());
        debitoResponseDTO.setTipoContrato(debitoDTO.getTipoContrato());
        debitoResponseDTO.setIdDebito(debitoDTO.getIdDebito());
        return debitoResponseDTO;
    }

    public DebitoCarneAiseDTO toDebitoCarneDTO(DebitoCarneResponseDTO debitoCarneResponseDTO) {
        if (debitoCarneResponseDTO == null) {
            return null;
        }
        DebitoCarneAiseDTO debitoCarneDTO = new DebitoCarneAiseDTO();
        debitoCarneDTO.setCadastroGeral(debitoCarneResponseDTO.getCadastroGeral());
        debitoCarneDTO.setDescricaoGuia(debitoCarneResponseDTO.getDescricaoGuia());
        debitoCarneDTO.setEntidade(debitoCarneResponseDTO.getEntidade());
        debitoCarneDTO.setExercicio(debitoCarneResponseDTO.getExercicio());
        debitoCarneDTO.setGuiaRecolhimento(debitoCarneResponseDTO.getGuiaRecolhimento());
        debitoCarneDTO.setNome(debitoCarneResponseDTO.getNome());
        debitoCarneDTO.setPessoa(debitoCarneResponseDTO.getPessoa());
        debitoCarneDTO.setSubDivida(debitoCarneResponseDTO.getSubDivida());
        debitoCarneDTO.setTipoCadastro(debitoCarneResponseDTO.getTipoCadastro());
        debitoCarneDTO.setValor(debitoCarneResponseDTO.getValor());
        this.parcelaMapper.mapperParcelas(debitoCarneResponseDTO, debitoCarneDTO);
        return debitoCarneDTO;
    }

    public DebitoCarneResponseDTO toDebitoCarneResponseDTO(DebitoCarneAiseDTO debitoCarneDTO) {
        if (debitoCarneDTO == null) {
            return null;
        }
        DebitoCarneResponseDTO debitoCarneResponseDTO = new DebitoCarneResponseDTO();
        debitoCarneResponseDTO.setCadastroGeral(debitoCarneDTO.getCadastroGeral());
        debitoCarneResponseDTO.setDescricaoGuia(debitoCarneDTO.getDescricaoGuia());
        debitoCarneResponseDTO.setEntidade(debitoCarneDTO.getEntidade());
        debitoCarneResponseDTO.setExercicio(debitoCarneDTO.getExercicio());
        debitoCarneResponseDTO.setGuiaRecolhimento(debitoCarneDTO.getGuiaRecolhimento());
        debitoCarneResponseDTO.setNome(debitoCarneDTO.getNome());
        debitoCarneResponseDTO.setPessoa(debitoCarneDTO.getPessoa());
        debitoCarneResponseDTO.setSubDivida(debitoCarneDTO.getSubDivida());
        debitoCarneResponseDTO.setTipoCadastro(debitoCarneDTO.getTipoCadastro());
        debitoCarneResponseDTO.setValor(debitoCarneDTO.getValor());
        this.parcelaMapper.mapperDtoParcelas(debitoCarneDTO, debitoCarneResponseDTO);
        return debitoCarneResponseDTO;
    }

    public DebitoParcelaMobileDTO toDebitoParcelaMobileDTO(DebitoResponseDTO debitoResponseDTO) {
        if (debitoResponseDTO == null) {
            return null;
        }
        DebitoParcelaMobileDTO debitoParcelaMobileDTO = new DebitoParcelaMobileDTO();
        debitoParcelaMobileDTO.setIdDebito(debitoResponseDTO.getIdDebito());
        debitoParcelaMobileDTO.setParcela(debitoResponseDTO.getParcela());
        debitoParcelaMobileDTO.setValor(debitoResponseDTO.getValor());
        debitoParcelaMobileDTO.setVencimento(debitoResponseDTO.getVencimento());
        debitoParcelaMobileDTO.setEmiteBloqueto(debitoResponseDTO.getEmiteBloqueto());
        return debitoParcelaMobileDTO;
    }

    public DebitoParcelaMobileDTO toDebitoParcelaMobileDTO(DebitoDTO debitoDTO) {
        if (debitoDTO == null) {
            return null;
        }
        DebitoParcelaMobileDTO debitoParcelaMobileDTO = new DebitoParcelaMobileDTO();
        debitoParcelaMobileDTO.setIdDebito(debitoDTO.getIdDebito());
        if (debitoDTO.getParcela() != null) {
            debitoParcelaMobileDTO.setParcela(Integer.valueOf(debitoDTO.getParcela().intValue()));
        }
        debitoParcelaMobileDTO.setValor(debitoDTO.getValor());
        debitoParcelaMobileDTO.setVencimento(debitoDTO.getVencimento());
        debitoParcelaMobileDTO.setEmiteBloqueto(debitoDTO.getEmiteBloqueto());
        return debitoParcelaMobileDTO;
    }

    public DebitoMobileDTO toDebitoMobileDTO(DebitoDTO debitoDTO) {
        if (debitoDTO == null) {
            return null;
        }
        DebitoMobileDTO debitoMobileDTO = new DebitoMobileDTO();
        debitoMobileDTO.setExercicio(debitoDTO.getExercicio());
        debitoMobileDTO.setIdParcelamento(debitoDTO.getIdParcelamento());
        debitoMobileDTO.setTipoCadastro(debitoDTO.getTipoCadastro());
        if (debitoDTO.getCadastroGeral() != null) {
            debitoMobileDTO.setCadastroGeral(Long.valueOf(debitoDTO.getCadastroGeral().longValue()));
        }
        debitoMobileDTO.setIdDebito(debitoDTO.getIdDebito());
        debitoMobileDTO.setDescricaoVisualizacao(debitoDTO.getDescricaoVisualizacao());
        debitoMobileDTO.setValor(debitoDTO.getValor());
        debitoMobileDTO.setDebitosContratoParcelamento(debitoDTO.getDebitos().stream().map(DebitoDTO::toDebitoContratoParcelamentoDTO).collect(Collectors.toList()));
        return debitoMobileDTO;
    }
}

