/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util;

import br.com.elotech.tributos.service.exception.ConvertToUpperCaseException;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConvertToUpperCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConvertToUpperCase.class);

    private ConvertToUpperCase() {
    }

    public static <T> T convert(T object) {
        if (!Optional.ofNullable(object).isPresent()) {
            return object;
        }
        if (object instanceof String) {
            Locale locale = new Locale("pt", "BR");
            return (T)object.toString().toUpperCase(locale);
        }
        for (Field field : object.getClass().getDeclaredFields()) {
            if (!field.getType().equals(String.class)) continue;
            try {
                field.setAccessible(true);
                field.set(object, StringUtils.upperCase((String)((String)field.get(object))));
                field.setAccessible(false);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LOGGER.error("N\u00e3o foi poss\u00edvel converter atributos para mai\u00fasculo. {}", (Object)e.getMessage());
                throw new ConvertToUpperCaseException("N\u00e3o foi poss\u00edvel converter atributos para mai\u00fasculo", (Throwable)e);
            }
        }
        return object;
    }
}

