/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto;

import br.com.elotech.tributos.domain.integracoes.IntegracaoToken;
import br.com.elotech.tributos.enums.IntegracaoTokenOperation;
import br.com.elotech.tributos.repository.integracoes.IntegracaoTokenRepository;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoRefreshTokenService;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoTokenService;
import com.fasterxml.jackson.databind.JsonNode;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class IntegracaoTokenDefaultServiceImpl
implements IntegracaoTokenService,
IntegracaoRefreshTokenService {
    private final IntegracaoTokenRepository repository;

    public IntegracaoTokenDefaultServiceImpl(IntegracaoTokenRepository repository) {
        this.repository = repository;
    }

    public boolean accept(String tipo) {
        return "DEFAULT".equals(tipo);
    }

    public String saveIntegracaoToken(Long codigoBanco, IntegracaoTokenOperation operation, JsonNode json) {
        Optional token = this.getIntegracaoToken(codigoBanco, operation);
        return token.isEmpty() ? this.createIntegracaoToken(codigoBanco, operation, json).getValor() : this.updateIntegracaoToken((IntegracaoToken)token.get(), json).getValor();
    }

    public Optional<String> getAccessToken(Long codigoBanco, IntegracaoTokenOperation operation) {
        return this.getIntegracaoToken(codigoBanco, operation).filter(IntegracaoToken::isValid).map(IntegracaoToken::getValor);
    }

    public Optional<String> getRefreshToken(Long codigoBanco, IntegracaoTokenOperation operation) {
        return this.getIntegracaoToken(codigoBanco, operation).filter(IntegracaoToken::isValidRefreshToken).map(IntegracaoToken::getValorRefreshToken);
    }

    public String saveIntegracaoWithRefreshToken(Long codigoBanco, IntegracaoTokenOperation operation, JsonNode json) {
        Optional token = this.getIntegracaoToken(codigoBanco, operation);
        return token.isEmpty() ? this.createIntegracaoWithRefreshToken(codigoBanco, operation, json).getValor() : this.updateIntegracaoWithRefreshToken((IntegracaoToken)token.get(), json).getValor();
    }

    private Optional<IntegracaoToken> getIntegracaoToken(Long codigoBanco, IntegracaoTokenOperation operation) {
        return this.repository.findIntegracaoTokenByBancoAndAndOperation(codigoBanco, operation);
    }

    private IntegracaoToken createIntegracaoToken(Long codigoBanco, IntegracaoTokenOperation operation, JsonNode json) {
        String newAccessToken = json.get("access_token").asText();
        IntegracaoToken token = new IntegracaoToken();
        token.setBanco(codigoBanco);
        token.setOperation(operation);
        token.setValor(newAccessToken);
        Long expirationTime = Long.parseLong(json.get("expires_in").asText());
        token.setExpiracao(this.getExpirationTimeInSecondFromResponse(expirationTime));
        return (IntegracaoToken)this.repository.save((Object)token);
    }

    private IntegracaoToken updateIntegracaoToken(IntegracaoToken token, JsonNode json) {
        String newAccessToken = json.get("access_token").asText();
        token.setValor(newAccessToken);
        Long expirationTime = Long.parseLong(json.get("expires_in").asText());
        token.setExpiracao(this.getExpirationTimeInSecondFromResponse(expirationTime));
        return (IntegracaoToken)this.repository.save((Object)token);
    }

    private String getExpirationTimeInSecondFromResponse(Long expirationTime) {
        Long currentSeconds = LocalDateTime.now().atZone(ZoneId.of("America/Sao_Paulo")).toEpochSecond();
        Long totalSeconds = currentSeconds + expirationTime;
        return String.valueOf(totalSeconds);
    }

    private IntegracaoToken createIntegracaoWithRefreshToken(Long codigoBanco, IntegracaoTokenOperation operation, JsonNode json) {
        String newAccessToken = json.get("access_token").asText();
        String refresh_token = json.get("refresh_token").asText();
        IntegracaoToken token = new IntegracaoToken();
        token.setBanco(codigoBanco);
        token.setOperation(operation);
        token.setValor(newAccessToken);
        token.setValorRefreshToken(refresh_token);
        Long expirationTime = Long.parseLong(json.get("expires_in").asText());
        token.setExpiracao(this.getExpirationTimeInSecondFromResponse(expirationTime));
        Long expirationTimeRefreshToken = Long.parseLong(json.get("refresh_expires_in").asText());
        token.setExpiracaoRefreshToken(this.getExpirationTimeInSecondFromResponse(expirationTimeRefreshToken));
        return (IntegracaoToken)this.repository.save((Object)token);
    }

    private IntegracaoToken updateIntegracaoWithRefreshToken(IntegracaoToken token, JsonNode json) {
        String newAccessToken = json.get("access_token").asText();
        String refresh_token = json.get("refresh_token").asText();
        token.setValor(newAccessToken);
        token.setValorRefreshToken(refresh_token);
        Long expirationTime = Long.parseLong(json.get("expires_in").asText());
        token.setExpiracao(this.getExpirationTimeInSecondFromResponse(expirationTime));
        Long expirationTimeRefreshToken = Long.parseLong(json.get("refresh_expires_in").asText());
        token.setExpiracaoRefreshToken(this.getExpirationTimeInSecondFromResponse(expirationTimeRefreshToken));
        return (IntegracaoToken)this.repository.save((Object)token);
    }
}

