/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.documento;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.SituacaoMobiliario;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.DocumentoGenericoDTO;
import br.com.elotech.tributos.dto.DocumentoSearchInitialValuesDTO;
import br.com.elotech.tributos.dto.GeracaoDocumentoDTO;
import br.com.elotech.tributos.service.CadastroMobiliarioService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.GeraDocumentoService;
import java.io.Serializable;
import javax.validation.Valid;
import org.springframework.stereotype.Service;

@Service
public class CertidaoInscricaoService {
    private final CadastroMobiliarioService cadastroMobiliarioService;
    private final GeraDocumentoService geraDocumentoService;
    private final DocumentoService documentoService;

    public CertidaoInscricaoService(CadastroMobiliarioService cadastroMobiliarioService, GeraDocumentoService geraDocumentoService, DocumentoService documentoService) {
        this.cadastroMobiliarioService = cadastroMobiliarioService;
        this.geraDocumentoService = geraDocumentoService;
        this.documentoService = documentoService;
    }

    public DocumentoDTO save(@Valid DocumentoGenericoDTO documentoGenericoDTO) {
        CadastroMobiliario cadastroMobiliario = (CadastroMobiliario)this.cadastroMobiliarioService.findById((Serializable)documentoGenericoDTO.getIdCadastro()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado cadastro mobili\u00e1rio com id %d.", documentoGenericoDTO.getIdCadastro())));
        SituacaoMobiliario situacaoMobiliario = cadastroMobiliario.getSituacaoAtual();
        if (situacaoMobiliario.getTipoSituacaoMobiliario().getEncerramento().booleanValue()) {
            throw new EloValidationException(String.format("Cadastro %s: %d est\u00e1 com situa\u00e7\u00e3o '%s'! Para a emiss\u00e3o da certid\u00e3o de inscri\u00e7\u00e3o, o cadastro n\u00e3o pode possuir situa\u00e7\u00e3o marcada como encerramento.", cadastroMobiliario.getTipoCadastro().getDescricao(), cadastroMobiliario.getCadastroGeral(), situacaoMobiliario.getDescricao()));
        }
        Documento documento = this.geraDocumentoService.getDocumentoAndValida(GeracaoDocumentoDTO.from((DocumentoGenericoDTO)documentoGenericoDTO, (CadastroGeral)cadastroMobiliario, (TipoDocumentoEnum)TipoDocumentoEnum.CERTIDAO_INSCRICAO));
        documento.setSituacaoCadastral(cadastroMobiliario.getSituacaoAtual().getDescricao());
        Documento saved = (Documento)this.documentoService.save((EloEntity)documento, null);
        return DocumentoDTO.from((Documento)saved);
    }

    public DocumentoGenericoDTO getInitialValues(DocumentoSearchInitialValuesDTO documentoSearchInitialValuesDTO) {
        return this.documentoService.getInitialValues(documentoSearchInitialValuesDTO, TipoDocumentoEnum.CERTIDAO_INSCRICAO);
    }
}

