/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.comunicado;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlSpecification;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.domain.ComunicadoCadastro;
import br.com.elotech.tributos.domain.ComunicadoCadastroId;
import br.com.elotech.tributos.domain.ComunicadoId;
import br.com.elotech.tributos.domain.ConsultaDebito;
import br.com.elotech.tributos.domain.TipoFiltroNotificacaoComunicado;
import br.com.elotech.tributos.domain.TipoNotificacaoComunicado;
import br.com.elotech.tributos.domain.relatorio.Relatorio;
import br.com.elotech.tributos.domain.relatorio.TipoRelatorio;
import br.com.elotech.tributos.dto.ComunicadoCadastroDto;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTOFactory;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.SituacaoComunicadoCadastro;
import br.com.elotech.tributos.dto.SubReportDTO;
import br.com.elotech.tributos.dto.SubReportItemDTO;
import br.com.elotech.tributos.dto.comunicadocadastro.ComunicadoCadastroGeraBoletoRequest;
import br.com.elotech.tributos.report.loader.ComunicadoParamLoader;
import br.com.elotech.tributos.repository.ComunicadoCadastroRepository;
import br.com.elotech.tributos.repository.ComunicadoRepository;
import br.com.elotech.tributos.repository.DebitoRepository;
import br.com.elotech.tributos.service.ConsultaDebitoBatchService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.service.ws.AiseRelatorioService;
import br.com.elotech.tributos.specs.ComunicadoCadastroSpecifications;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class ComunicadoCadastroService
extends CrudService<ComunicadoCadastro, ComunicadoCadastroId> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComunicadoCadastroService.class);
    private final ComunicadoCadastroRepository comunicadoCadastroRepository;
    private final ComunicadoRepository comunicadoRepository;
    private final EntityManager em;
    private final AiseRelatorioService aiseRelatorioService;
    private final ComunicadoParamLoader comunicadoParamLoader;
    private final GeraBoletoService geraBoletoService;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final ConsultaDebitoBatchService consultaDebitoBatchService;
    private final DebitoRepository debitoRepository;

    public Page<ComunicadoCadastroDto> findByRsqlComunicadoCadastro(Long entidade, Long exercicio, Long idComunicado, String search, Pageable pageable) {
        Specification specification = this.getComunicadoCadastroSpecification(entidade, exercicio, idComunicado, search);
        return this.comunicadoCadastroRepository.findAll(specification, pageable).map(ComunicadoCadastroDto::from);
    }

    public List<ComunicadoCadastro> findByRsql(Long entidade, Long exercicio, Long idComunicado, String search, Sort sort) {
        Specification specification = this.getComunicadoCadastroSpecification(entidade, exercicio, idComunicado, search);
        return this.comunicadoCadastroRepository.findAll(specification, sort);
    }

    public ComunicadoCadastroDto validateEnderecoNotificacao(Long entidade, Long exercicio, Long idComunicado, Long sequencia) {
        ComunicadoId comunicadoId = ComunicadoId.of((Long)entidade, (Long)exercicio, (Long)idComunicado);
        Comunicado comunicado = new Comunicado();
        comunicado.setId(comunicadoId);
        ComunicadoCadastroId comunicadoCadastroId = new ComunicadoCadastroId();
        comunicadoCadastroId.setComunicado(comunicado);
        comunicadoCadastroId.setSequencia(sequencia);
        ComunicadoCadastro notificacao = (ComunicadoCadastro)this.comunicadoCadastroRepository.findOne((Object)comunicadoCadastroId);
        if (Objects.isNull(notificacao)) {
            throw new EloValidationException(String.format("N\u00e3o foi encontrada notifica\u00e7\u00e3o com identificador: Entidade %d, Exercicio %d, idComunicado %d e sequencia %d", entidade, exercicio, idComunicado, sequencia));
        }
        if (SituacaoComunicadoCadastro.IMPRESSO.equals((Object)notificacao.getSituacao()) || SituacaoComunicadoCadastro.CANCELADO.equals((Object)notificacao.getSituacao())) {
            throw new EloValidationException("Essa notifica\u00e7\u00e3o j\u00e1 foi validada ou est\u00e1 cancelada");
        }
        if (Objects.isNull(notificacao.getPessoa())) {
            throw new EloValidationException("Essa notifica\u00e7\u00e3o n\u00e3o tem pessoa vinculada");
        }
        List inconsistencias = notificacao.getInconsistencias();
        notificacao.setSituacao(SituacaoComunicadoCadastro.validateEnderecoPorInconsistencia((List)inconsistencias));
        String mensagem = inconsistencias.isEmpty() ? "Endere\u00e7o validado com sucesso!" : String.join((CharSequence)", ", inconsistencias);
        notificacao.setDescricaoSituacao(mensagem);
        this.comunicadoCadastroRepository.save((Object)notificacao);
        ComunicadoCadastroDto comunicadoCadastroDTO = ComunicadoCadastroDto.from((ComunicadoCadastro)notificacao);
        comunicadoCadastroDTO.setDescricaoSituacao((String)(inconsistencias.isEmpty() ? mensagem : "Problema End.: " + mensagem));
        Boolean todasNotificacoesValidas = this.comunicadoRepository.areAllNotificacoesValidadas(entidade, exercicio, idComunicado);
        this.comunicadoRepository.setValidacaoComunicado(entidade, exercicio, idComunicado, todasNotificacoesValidas);
        return comunicadoCadastroDTO;
    }

    public ComunicadoCadastroDto cancelaComunicadoCadastro(Long entidade, Long exercicio, Long idComunicado, Long sequencia) {
        ComunicadoId comunicadoIdParam = ComunicadoId.of((Long)entidade, (Long)exercicio, (Long)idComunicado);
        Comunicado comunicadoParam = new Comunicado();
        comunicadoParam.setId(comunicadoIdParam);
        ComunicadoCadastroId comunicadoCadastroIdParam = new ComunicadoCadastroId();
        comunicadoCadastroIdParam.setComunicado(comunicadoParam);
        comunicadoCadastroIdParam.setSequencia(sequencia);
        ComunicadoCadastro comunicadoCadastro = (ComunicadoCadastro)this.comunicadoCadastroRepository.findOne((Object)comunicadoCadastroIdParam);
        if (Objects.isNull(comunicadoCadastro)) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar a notifica\u00e7\u00e3o com identificador: Entidade %d, Exercicio %d, idComunicado %d e sequencia %d", entidade, exercicio, idComunicado, sequencia));
        }
        if (SituacaoComunicadoCadastro.CANCELADO.equals((Object)comunicadoCadastro.getSituacao())) {
            throw new EloValidationException("Esta notifica\u00e7\u00e3o j\u00e1 est\u00e1 cancelada");
        }
        comunicadoCadastro.setSituacao(SituacaoComunicadoCadastro.CANCELADO);
        this.comunicadoCadastroRepository.save((Object)comunicadoCadastro);
        return ComunicadoCadastroDto.from((ComunicadoCadastro)comunicadoCadastro);
    }

    public byte[] print(Long entidade, Long exercicio, Long idComunicado, Long sequencia) {
        ComunicadoCadastro comunicadoCadastro = this.getComunicadoCadastro(entidade, exercicio, idComunicado, sequencia);
        if (!SituacaoComunicadoCadastro.PRONTO_PARA_IMPRESSAO.equals((Object)comunicadoCadastro.getSituacao()) && !SituacaoComunicadoCadastro.IMPRESSO.equals((Object)comunicadoCadastro.getSituacao())) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "N\u00e3o \u00e9 poss\u00edvel imprimir um comunicado que n\u00e3o esteja com a situa\u00e7\u00e3o Impressa ou Pronto para Impress\u00e3o.");
        }
        byte[] file = this.aiseRelatorioService.imprimirRelatorioGenerico(this.buildReportFilters(comunicadoCadastro));
        if (Objects.isNull(file)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel imprimir o comunicado.");
        }
        if (!SituacaoComunicadoCadastro.IMPRESSO.equals((Object)comunicadoCadastro.getSituacao())) {
            comunicadoCadastro.setSituacao(SituacaoComunicadoCadastro.IMPRESSO);
            this.comunicadoCadastroRepository.save((Object)comunicadoCadastro);
        }
        return file;
    }

    public AtomicLong findNextSequencia(ComunicadoId id) {
        return Optional.ofNullable(this.comunicadoCadastroRepository.findNextSequencia(id.getEntidade(), id.getExercicio(), id.getIdComunicado())).orElse(new AtomicLong(1L));
    }

    public void gerarBloqueto(ComunicadoCadastroGeraBoletoRequest request) {
        ComunicadoCadastro cadastro = this.findByIdWithValidation(request.toComunicadoCadastroId());
        GeraBoletoDTO geraBoletoDTO = GeraBoletoDTOFactory.makeToComunicadoCadastro((ComunicadoCadastro)cadastro);
        geraBoletoDTO.setDebitos(this.findDebitosParaBoleto(cadastro, request));
        if (request.getIdConsultaDebito() != null) {
            ConsultaDebito consultaDebito = (ConsultaDebito)this.consultaDebitoBatchService.findOne((Serializable)request.getIdConsultaDebito());
            geraBoletoDTO.setDataReferencia(consultaDebito.getDataReferencia());
        }
        try {
            Bloqueto bloqueto = this.geraBoletoService.geraBoleto(geraBoletoDTO, this.calculoAcrescimoService.createNecessariasCalculaAcrescimo()).stream().findFirst().orElse(null);
            cadastro.setBoleto(bloqueto);
            cadastro.setSituacao(bloqueto == null ? SituacaoComunicadoCadastro.SITUACAO_DEBITO : SituacaoComunicadoCadastro.PRONTO_PARA_IMPRESSAO);
            cadastro.setMensagemErroBoleto(null);
            cadastro.setDescricaoSituacao(cadastro.getSituacao().getDescricao());
        }
        catch (Exception e) {
            cadastro.setSituacao(SituacaoComunicadoCadastro.ERRO_BOLETO);
            cadastro.setMensagemErroBoleto(e.getMessage());
            cadastro.setBoleto(null);
        }
        this.save((EloEntity)cadastro, null);
    }

    private ComunicadoCadastro findByIdWithValidation(ComunicadoCadastroId comunicadoCadastroId) {
        ComunicadoId comunicadoId = comunicadoCadastroId.getComunicado().getId();
        return (ComunicadoCadastro)this.findById((Serializable)comunicadoCadastroId).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado comunicado cadastro com os dados entidade: %s, exercicio: %s, comunicado: %s, sequencia: %s", comunicadoId.getEntidade(), comunicadoId.getExercicio(), comunicadoId.getIdComunicado(), comunicadoCadastroId.getSequencia())));
    }

    private List<DebitoParcelaDTO> findDebitosParaBoleto(ComunicadoCadastro cadastro, ComunicadoCadastroGeraBoletoRequest request) {
        if (request.getIdConsultaDebito() != null) {
            return this.debitoRepository.findReceitasIdConsultaDebito(request.getIdConsultaDebito(), cadastro.getCadastroGeral().getTipoCadastro().getValue(), cadastro.getCadastroGeral().getCadastroGeral()).stream().map(receita -> DebitoParcelaDTO.from((Long)receita.getIdDebito(), (Long)receita.getParcela())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private ImprimirRelatorioDTO buildReportFilters(ComunicadoCadastro comunicadoCadastro) {
        Comunicado comunicado = this.getComunicado(comunicadoCadastro);
        Relatorio relatorio = this.getRelatorio(comunicado);
        ImprimirRelatorioDTO dto = new ImprimirRelatorioDTO();
        dto.setRelatorio(relatorio.getId().getRelatorio());
        dto.setModulo(relatorio.getId().getModulo());
        dto.setTipoRelatorio(TipoRelatorio.fromValue((String)relatorio.getTipoRelatorio().getValue()));
        dto.setFiltro(String.format(" b.exercicio = %d and b.idComunicado = %d and b.sequencia = %d", comunicadoCadastro.getId().getComunicado().getId().getExercicio(), comunicadoCadastro.getId().getComunicado().getId().getIdComunicado(), comunicadoCadastro.getId().getSequencia()));
        dto.setListParametros(this.comunicadoParamLoader.load());
        dto.setSubReports(this.createSubReport(dto.getFiltro(), comunicado));
        return dto;
    }

    private SubReportDTO createSubReport(String filtro, Comunicado comunicado) {
        SubReportDTO subReportDTO = new SubReportDTO();
        subReportDTO.setItems((Set)Sets.newHashSet((Object[])new SubReportItemDTO[]{new SubReportItemDTO("Bloqueto", filtro), new SubReportItemDTO("Setor", filtro)}));
        if (TipoFiltroNotificacaoComunicado.CONTRIBUICAO_MELHORIA.equals((Object)comunicado.getTipoNotificacao().getTipoFiltro())) {
            subReportDTO.getItems().add(new SubReportItemDTO("Proposta", filtro));
            subReportDTO.getItems().add(new SubReportItemDTO("Testada", filtro));
        }
        if (TipoFiltroNotificacaoComunicado.SUPER_SIMPLES.equals((Object)comunicado.getTipoNotificacao().getTipoFiltro())) {
            subReportDTO.getItems().add(new SubReportItemDTO("Cadastro", filtro));
        }
        return subReportDTO;
    }

    private ComunicadoCadastro getComunicadoCadastro(Long entidade, Long exercicio, Long idComunicado, Long sequencia) {
        ComunicadoId comunicadoId = ComunicadoId.of((Long)entidade, (Long)exercicio, (Long)idComunicado);
        Comunicado comunicado = new Comunicado();
        comunicado.setId(comunicadoId);
        ComunicadoCadastroId comunicadoCadastroId = new ComunicadoCadastroId();
        comunicadoCadastroId.setComunicado(comunicado);
        comunicadoCadastroId.setSequencia(sequencia);
        return (ComunicadoCadastro)this.comunicadoCadastroRepository.findById((Object)comunicadoCadastroId).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "Comunicado Cadastro n\u00e3o encontrado"));
    }

    private Comunicado getComunicado(ComunicadoCadastro comunicadoCadastro) {
        ComunicadoId comunicadoId = ComunicadoId.of((Long)comunicadoCadastro.getId().getComunicado().getId().getEntidade(), (Long)comunicadoCadastro.getId().getComunicado().getId().getExercicio(), (Long)comunicadoCadastro.getId().getComunicado().getId().getIdComunicado());
        return (Comunicado)this.comunicadoRepository.findById((Object)comunicadoId).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "Comunicado n\u00e3o encontrado"));
    }

    private Relatorio getRelatorio(Comunicado comunicado) {
        return Optional.ofNullable(comunicado).map(Comunicado::getTipoNotificacao).map(TipoNotificacaoComunicado::getRelatorio).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, String.format("Comunicado %s sem relat\u00f3rio informado", comunicado.getId().toString())));
    }

    private Specification<ComunicadoCadastro> getComunicadoCadastroSpecification(Long entidade, Long exercicio, Long idComunicado, String search) {
        Specification specification = Specification.where((Specification)ComunicadoCadastroSpecifications.comunicadoCadastroIdEntidadeSpecification((Long)entidade)).and(ComunicadoCadastroSpecifications.comunicadoCadastroIdExercicioSpecification((Long)exercicio)).and(ComunicadoCadastroSpecifications.comunicadoCadastroIdIdComunicadoSpecification((Long)idComunicado));
        if (StringUtils.isNotBlank((CharSequence)search)) {
            specification = specification.and((Specification)new RsqlSpecification(this.em, search));
        }
        return specification;
    }

    @Generated
    public ComunicadoCadastroService(ComunicadoCadastroRepository comunicadoCadastroRepository, ComunicadoRepository comunicadoRepository, EntityManager em, AiseRelatorioService aiseRelatorioService, ComunicadoParamLoader comunicadoParamLoader, GeraBoletoService geraBoletoService, CalculoAcrescimoService calculoAcrescimoService, ConsultaDebitoBatchService consultaDebitoBatchService, DebitoRepository debitoRepository) {
        this.comunicadoCadastroRepository = comunicadoCadastroRepository;
        this.comunicadoRepository = comunicadoRepository;
        this.em = em;
        this.aiseRelatorioService = aiseRelatorioService;
        this.comunicadoParamLoader = comunicadoParamLoader;
        this.geraBoletoService = geraBoletoService;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.consultaDebitoBatchService = consultaDebitoBatchService;
        this.debitoRepository = debitoRepository;
    }
}

