/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Date;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class CorrecaoCarneCalculoJobStarter {
    private final JobLauncher jobLauncher;
    private final JobExplorer jobExplorer;
    private final Job correcaoCarneCalculoJob;

    public CorrecaoCarneCalculoJobStarter(JobLauncher jobLauncher, JobExplorer jobExplorer, @Qualifier(value="correcaoCarneCalculoJob") Job correcaoCarneCalculoJob) {
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        this.correcaoCarneCalculoJob = correcaoCarneCalculoJob;
    }

    public JobExecution startJob(Long idCalculo) throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JsonProcessingException {
        boolean existeJobNaoFinalizadoComMesmoFiltro = this.jobExplorer.findRunningJobExecutions(JobType.CORRECAO_CARNE_CALCULO.getTipo()).stream().anyMatch(job -> idCalculo.equals(job.getJobParameters().getLong("idCalculo")));
        if (existeJobNaoFinalizadoComMesmoFiltro) {
            throw new EloValidationException("J\u00e1 existe uma job com estes par\u00e2metros.");
        }
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong("idCalculo", idCalculo);
        jobParametersBuilder.addDate("date", new Date());
        return this.jobLauncher.run(this.correcaoCarneCalculoJob, jobParametersBuilder.toJobParameters());
    }
}

