/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.acertopagameto;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.AcertoPagamento;
import br.com.elotech.tributos.domain.AcertoPagamentoItem;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.dto.pagamento.EstornoPagamentoDTO;
import br.com.elotech.tributos.dto.pagamento.EstornoPagamentoItemSelecionadoDTO;
import br.com.elotech.tributos.service.EstornoPagamentoService;
import br.com.elotech.tributos.service.acertopagameto.AcertoPagamentoService;
import br.com.elotech.tributos.service.pagamentocredito.CreditoService;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class EstornoAcertoPagamentoService {
    private final AcertoPagamentoService acertoPagamentoService;
    private final EstornoPagamentoService estornoPagamentoService;
    private final CreditoService pagamentoCreditoService;

    public AcertoPagamento estornoAcerto(Long id) {
        AcertoPagamento acertoPagamento = (AcertoPagamento)this.acertoPagamentoService.findById((Serializable)id).orElseThrow(() -> new EloValidationException(String.format("Acerto de Pagamento %d n\u00e3o encontrado.", id)));
        if (Boolean.TRUE.equals(acertoPagamento.getEstornado())) {
            throw new EloValidationException("O acerto de pagamento j\u00e1 foi estornado.");
        }
        this.estornarPagamentosNovos(acertoPagamento);
        this.estornarCredito(acertoPagamento);
        return (AcertoPagamento)this.acertoPagamentoService.save((EloEntity)acertoPagamento, null);
    }

    private void estornarPagamentosNovos(AcertoPagamento acertoPagamento) {
        List pagamentosSelecionados = acertoPagamento.getAcertoPagamentoItemList().stream().map(item -> {
            EstornoPagamentoItemSelecionadoDTO itemSelecionado = new EstornoPagamentoItemSelecionadoDTO();
            itemSelecionado.setExercicio(item.getPagamentoNovo().getId().getExercicioPagamento());
            itemSelecionado.setPagamento(item.getPagamentoNovo().getId().getPagamento());
            return itemSelecionado;
        }).collect(Collectors.toList());
        EstornoPagamentoDTO estornoPagamentoDTO = new EstornoPagamentoDTO();
        estornoPagamentoDTO.setTodosSelecionados(Boolean.FALSE);
        estornoPagamentoDTO.setSelecionados(pagamentosSelecionados);
        estornoPagamentoDTO.setData(LocalDate.now());
        estornoPagamentoDTO.setMotivoEstorno(estornoPagamentoDTO.getMotivoEstorno());
        estornoPagamentoDTO.setUtilizarComoCredito(Boolean.valueOf(false));
        estornoPagamentoDTO.setValidaAcertoDePagamento(Boolean.valueOf(false));
        this.estornoPagamentoService.estornarPagamento(estornoPagamentoDTO);
        acertoPagamento.setEstornado(Boolean.TRUE);
    }

    private void estornarCredito(AcertoPagamento acertoPagamento) {
        for (AcertoPagamentoItem item : acertoPagamento.getAcertoPagamentoItemList()) {
            Bloqueto boletoPago = item.getPagamentoNovo().getPagamentoBoleto().getBoleto();
            List creditosUtilizados = this.pagamentoCreditoService.findCreditoByBoletoPago(boletoPago);
            creditosUtilizados.forEach(credito -> credito.estornarMovimentacaoPorBoleto(boletoPago));
            this.pagamentoCreditoService.save(creditosUtilizados);
        }
    }

    @Generated
    public EstornoAcertoPagamentoService(AcertoPagamentoService acertoPagamentoService, EstornoPagamentoService estornoPagamentoService, CreditoService pagamentoCreditoService) {
        this.acertoPagamentoService = acertoPagamentoService;
        this.estornoPagamentoService = estornoPagamentoService;
        this.pagamentoCreditoService = pagamentoCreditoService;
    }
}

