/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.tarefaassincrona.SituacaoTarefaAssincrona;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincrona;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaParametro;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoParametro;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoTarefaAssincrona;
import br.com.elotech.tributos.dto.parcelamento.AtualizacaoMonetariaDTO;
import br.com.elotech.tributos.dto.tarefaassincrona.TarefaAssincronaDTO;
import br.com.elotech.tributos.dto.tarefaassincrona.TarefaAssincronaExecucaoDTO;
import br.com.elotech.tributos.repository.TarefaAssincronaRepository;
import br.com.elotech.tributos.service.TarefaAssincronaExecucaoService;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TarefaAssincronaService {
    private final TarefaAssincronaRepository tarefaAssincronaRepository;
    private final TarefaAssincronaExecucaoService tarefaAssincronaExecucaoService;
    private static final Logger LOGGER = LoggerFactory.getLogger(TarefaAssincronaService.class);

    public TarefaAssincronaService(TarefaAssincronaRepository tarefaAssincronaRepository, TarefaAssincronaExecucaoService tarefaAssincronaExecucaoService) {
        this.tarefaAssincronaRepository = tarefaAssincronaRepository;
        this.tarefaAssincronaExecucaoService = tarefaAssincronaExecucaoService;
    }

    public TarefaAssincrona findOne(Long tarefa) {
        return (TarefaAssincrona)this.tarefaAssincronaRepository.findById((Object)tarefa).orElseThrow(() -> new EloValidationException(String.format("Tarefa %s n\u00e3o encontrada.", tarefa)));
    }

    public Page<TarefaAssincronaDTO> searchTarefas(String search, Pageable pageable) {
        return this.tarefaAssincronaRepository.searchTarefas(search, pageable);
    }

    public List<TarefaAssincronaExecucaoDTO> findHistoricoExecucoesByTarefa(Long tarefa) {
        return this.tarefaAssincronaRepository.findHistoricoExecucoesByTarefa(tarefa);
    }

    public void validarTarefaIntegracaoContabilProcessandoComMesmaData(List<LocalDate> datasSelecionadas) {
        List datas = datasSelecionadas.stream().map(LocalDate::toString).collect(Collectors.toList());
        List parametros = this.tarefaAssincronaRepository.getParametrosTarefaIntegracaoContabilProcessandoComMesmaData(datas);
        if (!parametros.isEmpty()) {
            String datasProcessando = parametros.stream().map(parametro -> DateUtils.localDateToStringFormatoBrasileiro((LocalDate)DateUtils.stringToLocalDate((String)parametro.getValor()))).distinct().collect(Collectors.joining(", "));
            throw new EloValidationException(String.format("J\u00e1 existe tarefa sendo processada com a mesma data: %s.", datasProcessando));
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public synchronized TarefaAssincronaExecucao criarTarefaAssincronaIntegracaoContabil(List<LocalDate> datas) {
        TarefaAssincrona tarefa = new TarefaAssincrona();
        tarefa.setTipo(TipoTarefaAssincrona.INTEGRACAO_CONTABIL_DIA);
        datas.forEach(data -> {
            TarefaAssincronaParametro parametro = new TarefaAssincronaParametro();
            parametro.setTarefaAssincrona(tarefa);
            parametro.setTipo(TipoParametro.DATA);
            parametro.setChave("DATA_INTEGRACAO");
            parametro.setValor(DateUtils.DATE_TIME_FORMATTER.format((TemporalAccessor)data));
            tarefa.addParametro(parametro);
        });
        TarefaAssincronaExecucao execucao = new TarefaAssincronaExecucao();
        execucao.setSituacao(SituacaoTarefaAssincrona.PROCESSANDO);
        tarefa.addExecucao(execucao);
        this.tarefaAssincronaRepository.save((Object)tarefa);
        return execucao;
    }

    public TarefaAssincronaExecucao criarNovaExecucao(TarefaAssincrona tarefa) {
        return this.tarefaAssincronaExecucaoService.criarNovaExecucao(tarefa);
    }

    public void marcarExecucaoComErro(TarefaAssincronaExecucao execucao, String mensagemErro) {
        this.tarefaAssincronaExecucaoService.marcarExecucaoComErro(execucao, mensagemErro);
    }

    public void finalizarExecucao(TarefaAssincronaExecucao execucao) {
        this.finalizarExecucao(execucao, null);
    }

    public void finalizarExecucao(TarefaAssincronaExecucao execucao, TarefaAssincronaParametro parametro) {
        if (Objects.nonNull(parametro)) {
            execucao.getTarefaAssincrona().addParametro(parametro);
            TarefaAssincrona tarefaSalva = (TarefaAssincrona)this.tarefaAssincronaRepository.save((Object)execucao.getTarefaAssincrona());
            execucao.setTarefaAssincrona(tarefaSalva);
        }
        this.tarefaAssincronaExecucaoService.finalizarExecucao(execucao);
    }

    public boolean existsProcessoEmExecucao(TipoTarefaAssincrona tipoTarefaAssincrona, String chave, String valor) {
        List tarefaAssincronaEmProcessamento = this.tarefaAssincronaRepository.getTarefaAssincronaEmProcessamento(tipoTarefaAssincrona, chave, valor);
        return !Objects.isNull(tarefaAssincronaEmProcessamento) && !tarefaAssincronaEmProcessamento.isEmpty();
    }

    public void beforeStartTarefaAssincrona(TipoTarefaAssincrona tipo, String chave, String valor) {
        if (this.existsProcessoEmExecucao(tipo, chave, valor)) {
            LOGGER.info("J\u00e1 existe uma tarefa em execu\u00e7\u00e3o com os parametros TipoTarefaAssincrona {} Chave {} Valor {}", new Object[]{tipo, chave, valor});
            throw new EloValidationException("J\u00e1 existe uma tarefa em execu\u00e7\u00e3o para essa rotina!");
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public synchronized TarefaAssincronaExecucao createTarefaAssincronaImpressaoAgrupadaLoteCDA(Long idLoteCDA) {
        TarefaAssincrona tarefa = new TarefaAssincrona();
        tarefa.setTipo(TipoTarefaAssincrona.IMPRESSAO_CDA_LOTE);
        TarefaAssincronaParametro parametro = new TarefaAssincronaParametro();
        parametro.setTarefaAssincrona(tarefa);
        parametro.setTipo(TipoParametro.NUMBER);
        parametro.setChave("ID_LOTE_CDA");
        parametro.setValor(idLoteCDA.toString());
        tarefa.addParametro(parametro);
        TarefaAssincronaExecucao execucao = new TarefaAssincronaExecucao();
        execucao.setSituacao(SituacaoTarefaAssincrona.PROCESSANDO);
        tarefa.addExecucao(execucao);
        this.tarefaAssincronaRepository.save((Object)tarefa);
        return execucao;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public synchronized TarefaAssincronaExecucao createTarefaASsincronaImpressaoAgrupadaLotePeticao(Long idLotePeticao) {
        TarefaAssincrona tarefa = new TarefaAssincrona();
        tarefa.setTipo(TipoTarefaAssincrona.IMPRESSAO_PETICAO_LOTE);
        TarefaAssincronaParametro parametro = new TarefaAssincronaParametro();
        parametro.setTarefaAssincrona(tarefa);
        parametro.setTipo(TipoParametro.NUMBER);
        parametro.setChave("ID_LOTE_PETICAO");
        parametro.setValor(idLotePeticao.toString());
        tarefa.addParametro(parametro);
        TarefaAssincronaExecucao execucao = new TarefaAssincronaExecucao();
        execucao.setSituacao(SituacaoTarefaAssincrona.PROCESSANDO);
        tarefa.addExecucao(execucao);
        this.tarefaAssincronaRepository.save((Object)tarefa);
        return execucao;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public synchronized TarefaAssincronaExecucao createTarefaAssincronaImpressaoLoteComunicado(String idComunicado) {
        TarefaAssincrona tarefa = new TarefaAssincrona();
        tarefa.setTipo(TipoTarefaAssincrona.IMPRESSAO_COMUNICADO_LOTE);
        TarefaAssincronaParametro parametro = new TarefaAssincronaParametro();
        parametro.setTarefaAssincrona(tarefa);
        parametro.setTipo(TipoParametro.NUMBER);
        parametro.setChave("ID_LOTE_COMUNICADO");
        parametro.setValor(idComunicado);
        tarefa.addParametro(parametro);
        TarefaAssincronaExecucao execucao = new TarefaAssincronaExecucao();
        execucao.setSituacao(SituacaoTarefaAssincrona.PROCESSANDO);
        tarefa.addExecucao(execucao);
        this.tarefaAssincronaRepository.save((Object)tarefa);
        return execucao;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public synchronized TarefaAssincronaExecucao createTarefaAssincronaVerificacaoPamanentoLote(String idPagamentoLote) {
        TarefaAssincrona tarefa = new TarefaAssincrona();
        tarefa.setTipo(TipoTarefaAssincrona.VERIFICACAO_PAGAMENTO_LOTE);
        TarefaAssincronaParametro parametro = new TarefaAssincronaParametro();
        parametro.setTarefaAssincrona(tarefa);
        parametro.setTipo(TipoParametro.NUMBER);
        parametro.setChave("ID_PAGAMENTO_LOTE");
        parametro.setValor(idPagamentoLote);
        tarefa.addParametro(parametro);
        TarefaAssincronaExecucao execucao = new TarefaAssincronaExecucao();
        execucao.setSituacao(SituacaoTarefaAssincrona.PROCESSANDO);
        tarefa.addExecucao(execucao);
        this.tarefaAssincronaRepository.save((Object)tarefa);
        return execucao;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public synchronized TarefaAssincronaExecucao criarTarefaAssincronaParcelamentoCarne(String chave, Long parcelaInicial, Long parcelaFinal) {
        TarefaAssincrona tarefa = new TarefaAssincrona();
        tarefa.setTipo(TipoTarefaAssincrona.PARCELAMENTO_GERACAO_CARNE);
        TarefaAssincronaParametro parametro = new TarefaAssincronaParametro();
        parametro.setTarefaAssincrona(tarefa);
        parametro.setTipo(TipoParametro.NUMBER);
        parametro.setChave("ID_PARCELAMENTO");
        parametro.setValor(chave);
        tarefa.addParametro(parametro);
        TarefaAssincronaParametro parametroParcelaInicial = new TarefaAssincronaParametro();
        parametroParcelaInicial.setTarefaAssincrona(tarefa);
        parametroParcelaInicial.setTipo(TipoParametro.NUMBER);
        parametroParcelaInicial.setChave("PARCELA_INICIAL");
        parametroParcelaInicial.setValor(parcelaInicial.toString());
        tarefa.addParametro(parametroParcelaInicial);
        TarefaAssincronaParametro parametroParcelaFinal = new TarefaAssincronaParametro();
        parametroParcelaFinal.setTarefaAssincrona(tarefa);
        parametroParcelaFinal.setTipo(TipoParametro.NUMBER);
        parametroParcelaFinal.setChave("PARCELA_FINAL");
        parametroParcelaFinal.setValor(parcelaFinal.toString());
        tarefa.addParametro(parametroParcelaFinal);
        TarefaAssincronaExecucao execucao = new TarefaAssincronaExecucao();
        execucao.setSituacao(SituacaoTarefaAssincrona.PROCESSANDO);
        tarefa.addExecucao(execucao);
        this.tarefaAssincronaRepository.save((Object)tarefa);
        return execucao;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public synchronized TarefaAssincronaExecucao createTarefaAssincronaGeracaoParcelamento(String chaveParcelamento) {
        TarefaAssincrona tarefa = new TarefaAssincrona();
        tarefa.setTipo(TipoTarefaAssincrona.GERACAO_PARCELAMENTO);
        TarefaAssincronaParametro parametro = new TarefaAssincronaParametro();
        parametro.setTarefaAssincrona(tarefa);
        parametro.setTipo(TipoParametro.NUMBER);
        parametro.setChave("ID_PARCELAMENTO_ASSINCRONO");
        parametro.setValor(chaveParcelamento);
        tarefa.addParametro(parametro);
        TarefaAssincronaExecucao execucao = new TarefaAssincronaExecucao();
        execucao.setSituacao(SituacaoTarefaAssincrona.PROCESSANDO);
        tarefa.addExecucao(execucao);
        this.tarefaAssincronaRepository.save((Object)tarefa);
        return execucao;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public synchronized TarefaAssincronaExecucao createTarefaAssincronaGeracaoArquivoGrafica(String chaveImpressaoCarne) {
        TarefaAssincrona tarefa = new TarefaAssincrona();
        tarefa.setTipo(TipoTarefaAssincrona.GERACAO_ARQUIVO_GRAFICA);
        TarefaAssincronaParametro parametro = new TarefaAssincronaParametro();
        parametro.setTarefaAssincrona(tarefa);
        parametro.setTipo(TipoParametro.NUMBER);
        parametro.setChave("CHAVE_ID_GERACAO_ARQUIVO_GRAFICA");
        parametro.setValor(chaveImpressaoCarne);
        tarefa.addParametro(parametro);
        TarefaAssincronaExecucao execucao = new TarefaAssincronaExecucao();
        execucao.setSituacao(SituacaoTarefaAssincrona.PROCESSANDO);
        tarefa.addExecucao(execucao);
        this.tarefaAssincronaRepository.save((Object)tarefa);
        return execucao;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public synchronized TarefaAssincronaExecucao createTarefaAssincronaImpressaoCarneLotePdf(String chaveImpressaoCarne) {
        TarefaAssincrona tarefa = new TarefaAssincrona();
        tarefa.setTipo(TipoTarefaAssincrona.IMPRESSAO_CARNE_LOTE_PDF);
        TarefaAssincronaParametro parametro = new TarefaAssincronaParametro();
        parametro.setTarefaAssincrona(tarefa);
        parametro.setTipo(TipoParametro.NUMBER);
        parametro.setChave("CHAVE_ID_IMPRESSAO_CARNE_LOTE_PDF");
        parametro.setValor(chaveImpressaoCarne);
        tarefa.addParametro(parametro);
        TarefaAssincronaExecucao execucao = new TarefaAssincronaExecucao();
        execucao.setSituacao(SituacaoTarefaAssincrona.PROCESSANDO);
        tarefa.addExecucao(execucao);
        this.tarefaAssincronaRepository.save((Object)tarefa);
        return execucao;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public synchronized TarefaAssincronaExecucao createTarefaAssincronaAtualizacaoMonetariaDeParcelamento(AtualizacaoMonetariaDTO params) {
        TarefaAssincrona tarefa = new TarefaAssincrona();
        tarefa.setTipo(TipoTarefaAssincrona.ATUALIZACAO_MONETARIA_PARCELAMENTO);
        this.addParameter(tarefa, TipoParametro.NUMBER, "ANO", (Object)params.getAno());
        this.addParameter(tarefa, TipoParametro.NUMBER, "MES", (Object)params.getMes());
        if (params.getIdparcelamento() != null) {
            this.addParameter(tarefa, TipoParametro.NUMBER, "ID_PARCELAMENTO", (Object)params.getIdparcelamento());
        }
        TarefaAssincronaExecucao execucao = TarefaAssincronaExecucao.start((TarefaAssincrona)tarefa);
        tarefa.addExecucao(execucao);
        this.tarefaAssincronaRepository.save((Object)tarefa);
        return execucao;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public synchronized TarefaAssincronaExecucao createTarefaAssincronaAtualizacaoMonetariaDireta(String chaveAtualizacaoDireta) {
        TarefaAssincrona tarefa = new TarefaAssincrona();
        tarefa.setTipo(TipoTarefaAssincrona.ATUALIZACAO_MONETARIA_DIRETA);
        this.addParameter(tarefa, TipoParametro.NUMBER, "CHAVE_ID_ATUALIZACAO_DIRETA", (Object)chaveAtualizacaoDireta);
        TarefaAssincronaExecucao execucao = TarefaAssincronaExecucao.start((TarefaAssincrona)tarefa);
        tarefa.addExecucao(execucao);
        this.tarefaAssincronaRepository.save((Object)tarefa);
        return execucao;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public synchronized TarefaAssincronaExecucao createTarefaAssincronaCancelamentoDebitoPorReceita(String filtro) {
        TarefaAssincrona tarefa = new TarefaAssincrona();
        tarefa.setTipo(TipoTarefaAssincrona.CANCELAMENTO_DEBITO);
        this.addParameter(tarefa, TipoParametro.TEXTO, "CHAVE_CANCELAMENTO_DEBITO", (Object)filtro);
        TarefaAssincronaExecucao execucao = TarefaAssincronaExecucao.start((TarefaAssincrona)tarefa);
        tarefa.addExecucao(execucao);
        this.tarefaAssincronaRepository.save((Object)tarefa);
        return execucao;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public synchronized TarefaAssincronaExecucao createTarefaAssincronaGeracaoArquivoUnificadoPeticaoCda(List<Long> idsPeticoes) {
        TarefaAssincrona tarefa = new TarefaAssincrona();
        tarefa.setTipo(TipoTarefaAssincrona.GERACAO_ARQUIVO_UNIFICADO_PETICAO_CDA);
        this.addParameter(tarefa, TipoParametro.TEXTO, "CHAVE_IDSPETICOES_GERACAO_ARQUIVO_UNIFICADO_PETICAO_CDA", idsPeticoes);
        TarefaAssincronaExecucao execucao = TarefaAssincronaExecucao.start((TarefaAssincrona)tarefa);
        tarefa.addExecucao(execucao);
        this.tarefaAssincronaRepository.save((Object)tarefa);
        return execucao;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public synchronized TarefaAssincronaExecucao createTarefaAssincronaCancelamentoBoletos(Long idCancelamentoBloqueto) {
        TarefaAssincrona tarefa = new TarefaAssincrona();
        tarefa.setTipo(TipoTarefaAssincrona.CANCELAMENTO_BOLETO);
        this.addParameter(tarefa, TipoParametro.NUMBER, "ID_CANCELAMENTO_BLOQUETO", (Object)idCancelamentoBloqueto);
        TarefaAssincronaExecucao execucao = TarefaAssincronaExecucao.start((TarefaAssincrona)tarefa);
        tarefa.addExecucao(execucao);
        this.tarefaAssincronaRepository.save((Object)tarefa);
        return execucao;
    }

    private void addParameter(TarefaAssincrona tarefa, TipoParametro tipo, String chave, Object valor) {
        TarefaAssincronaParametro parametro = new TarefaAssincronaParametro();
        parametro.setTarefaAssincrona(tarefa);
        parametro.setTipo(tipo);
        parametro.setChave(chave);
        parametro.setValor(String.valueOf(valor));
        tarefa.addParametro(parametro);
    }

    public TarefaAssincrona updateTarefaComParametroUrlArquivo(TarefaAssincrona tarefa, String url) {
        this.addParameter(tarefa, TipoParametro.TEXTO, "CHAVE_URL_ARQUIVO_UNIFICADO_ZIP", (Object)url);
        return this.updateTarefaAssincrona(tarefa);
    }

    public TarefaAssincrona updateTarefaAssincrona(TarefaAssincrona tarefaAssincrona) {
        return (TarefaAssincrona)this.tarefaAssincronaRepository.save((Object)tarefaAssincrona);
    }
}

